#define STRICT
#include <windows.h>
#include <windowsx.h>
#include "ui_windows_resource.h"
#include "achat.h"
#include "string.h"

#define ID_EDIT 100
#define CMDWND_HEIGHT 24

char szClassName[] = "achat";        //EBhENX
HINSTANCE hInst;
HWND hMsg,hCmd,hMainWindow;

/*  */
/*  */
/* bb                                                  bb */
/* bb             \Pbg֘AR[obN             bb */
/* bb                                                  bb */
/*  */
/*  */

void
UIPrint(int type,const char *st)
{
  ALCSTR as;
  static int length=0;

  as=alcstrJIStoMSKanji(st);
  realcstrConcatenate(&as,"\r\n");

  if(type&0xFF)
    {
      Edit_SetSel(hMsg,length,-1);
      Edit_ReplaceSel(hMsg,as);
      length+=strlen(as);
    }

  alcstrDestroy(as);
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                R}hEBhE                bb */
/* bb                                                  bb */
/*  */
/*  */
static WNDPROC cmdwndOrgProc;

LRESULT CALLBACK
cmdwndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
  if(msg==WM_CHAR)
    {
      if(wp==VK_RETURN)
	{
	  char tmp[256];
	  GetWindowText(hCmd,tmp,sizeof(tmp));
	  CmdString(tmp);
	  SetWindowText(hCmd,"");
	  return 0;
	}
    }

  return CallWindowProc(cmdwndOrgProc,hCmd,msg,wp,lp);
}

static void
cmdwndCreate(HWND parent)
{
  RECT rc;
  GetClientRect(parent, &rc);

  hCmd = CreateWindowEx(WS_EX_CLIENTEDGE,
			"EDIT",
			"",
			WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL,
			0, rc.bottom-CMDWND_HEIGHT,
			rc.right, CMDWND_HEIGHT,
			parent,
			NULL,
			hInst,
			NULL);
  cmdwndOrgProc=(WNDPROC)GetWindowLong(hCmd,GWL_WNDPROC);
  SetWindowLong(hCmd,GWL_WNDPROC,(LONG)cmdwndProc);
}

/*  */
/*  */
/* bb                                                  bb */
/* bb              EBhEvV[W              bb */
/* bb                                                  bb */
/*  */
/*  */
#define TIMER_DESCRIPTER 32767

LRESULT CALLBACK
WndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
#if 0
  if(hWnd!=hMainWindow)
    {
      char tmp[256];
      wsprintf(tmp,"%s %X\r\n",
	       (hWnd==hMsg)?"Meg":((hWnd==hCmd)?"Cmd":"???"),msg);
      OutputDebugString(tmp);
    }
#endif

  switch (msg)
    {
    case WM_CREATE:
      {
	RECT rc;
	GetClientRect(hWnd, &rc);
	hMsg = CreateWindowEx(WS_EX_CLIENTEDGE,
			      "EDIT",
			      "",
			      WS_CHILD | WS_VISIBLE |
			      ES_WANTRETURN | ES_MULTILINE |
			      ES_AUTOVSCROLL | WS_VSCROLL |
			      ES_AUTOHSCROLL | WS_HSCROLL |
			      ES_READONLY,
			      0, 0,
			      rc.right, rc.bottom-CMDWND_HEIGHT,
			      hWnd,
			      NULL,
			      hInst,
			      NULL);
	SendMessage(hMsg, EM_SETLIMITTEXT, (WPARAM)1024*64, 0);
      }
      cmdwndCreate(hWnd);
      if(SetTimer(hWnd, TIMER_DESCRIPTER, 1000, NULL) == 0)
	{
	  MessageBox(hWnd,
		     (LPCSTR)"^C}[sI",
		     (LPCSTR)"s",
		     MB_OK | MB_ICONEXCLAMATION);
	}
      break;

    case WM_SIZE:
      {
	static BOOL initilized=FALSE;
	WSADATA wsa;
	if(!initilized)
	  {
	    int i;
	    /* \Pbg */
	    if(i=WSAStartup(MAKEWORD(1,1), &wsa))
	      {
		char msg[256];
		wsprintf(msg,
			 "\Pbgg킹ĂȂ悧`(Error code:%d)", i);
		MessageBox(hMainWindow, msg, "G[", MB_OK|MB_ICONSTOP);
		DestroyWindow(hWnd);
		break;
	      }
	    /* R[obN֘A */
	    /* acceptCallback.fd=-1;
	       for(i=0;i<MAXCONNECTION;i++) readCallback[i].fd=-1;*/

	    /* C */
	    Initilize();
	    
	    initilized=TRUE;
	  }
      }
      {
	RECT rc;
	GetClientRect(hWnd, &rc);
	MoveWindow(hMsg, rc.left, rc.top,
		   rc.right, rc.bottom-CMDWND_HEIGHT,
		   TRUE);
	MoveWindow(hCmd, rc.left, rc.bottom-CMDWND_HEIGHT,
		   rc.right, CMDWND_HEIGHT, //rc.bottom,
		   TRUE);
      }
      break;

    case WM_TIMER:
      AchatMain();
      break;

    case WM_KEYDOWN:
      {
	char tmp[256];
	wsprintf(tmp,"KeyDown %X\r\n",wp);
	OutputDebugString(tmp);
      }
      if(wp==VK_RETURN)
	{
	  SetWindowText(hCmd,"");
	}
      else
	return (DefWindowProc(hWnd, msg, wp, lp));
      break;
      
    case WM_SYSKEYDOWN:
      {
	char tmp[256];
	wsprintf(tmp,"SysKey %X\r\n",wp);
	OutputDebugString(tmp);
      }
      if(wp==VK_RETURN)
	SetWindowText(hCmd,"");
      else
	return (DefWindowProc(hWnd, msg, wp, lp));
      break;
    case WM_COMMAND:
      switch (LOWORD(wp))
	{
	case ID_FILE_QUIT:
	  SendMessage(hWnd, WM_CLOSE, 0, 0);
	  break;
	case ID_SETUP_FONT:
	  {
	    LOGFONT lf;
	    CHOOSEFONT cf;
	    memset(&cf, 0, sizeof(CHOOSEFONT));
	    cf.lStructSize = sizeof(CHOOSEFONT);
	    cf.hwndOwner = hWnd;
	    cf.lpLogFont = &lf;
	    cf.Flags = CF_SCREENFONTS | CF_EFFECTS;
	    cf.rgbColors = RGB(0, 0, 0);
	    cf.nFontType = SCREEN_FONTTYPE;
	    if(GetObject(GetWindowFont(hMsg),sizeof(lf),&lf)>0)
	      cf.Flags |= CF_INITTOLOGFONTSTRUCT;
	    if(ChooseFont(&cf))
	      SetWindowFont(hMsg,CreateFontIndirect(&lf),TRUE);
	  }
	}
      break;
    case WM_CLOSE:
      DestroyWindow(hWnd);
      break;
    case WM_DESTROY:
      KillTimer(hWnd, TIMER_DESCRIPTER);
      PostQuitMessage(0);
      break;
    default:
      return (DefWindowProc(hWnd, msg, wp, lp));
    }
  return 0L;
}

int WINAPI
WinMain(HINSTANCE hCurInst, HINSTANCE hPrevInst,
	LPSTR lpsCmdLine, int nCmdShow)
{
  MSG msg;
  Platform="Win32";

  if (!hPrevInst)
    {
      WNDCLASS wc;
      wc.style = CS_HREDRAW | CS_VREDRAW;
      wc.lpfnWndProc = WndProc;    /* vV[W */
      wc.cbClsExtra = 0;
      wc.cbWndExtra = 0;
      wc.hInstance = hCurInst;        /* CX^X */
      wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
      wc.hCursor = LoadCursor(NULL, IDC_ARROW);
      wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      wc.lpszMenuName = MAKEINTRESOURCE(IDR_MENU);   /* j[ */
      wc.lpszClassName = (LPCTSTR)szClassName;
      if(!RegisterClass(&wc))
	return FALSE;
    }
  
  /* VFEBhE̐ */
  {
    hInst = hCurInst;
    hMainWindow = CreateWindow(szClassName,"aCHU^Hat",
			       WS_OVERLAPPEDWINDOW,
			       CW_USEDEFAULT,    //wW
			       CW_USEDEFAULT,    //xW
			       CW_USEDEFAULT,    //
			       CW_USEDEFAULT,    //
			       NULL,    /* eEBhẼnhA
					   eƂNULL */
			       NULL,    /* j[nhA
					   NXj[gƂNULL */
			       hInst,
			       NULL);
    if (!hMainWindow)
      return FALSE;
    ShowWindow(hMainWindow, nCmdShow);
    UpdateWindow(hMainWindow);
  }

  /* Cxg[v */
  while(GetMessage(&msg,NULL,0,0))
    {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }

  return msg.wParam;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb               INCu               bb */
/* bb                                                  bb */
/*  */
/*  */

void *
UILibraryOpen(const char *libname)
{
  void *handle;

  ALCSTR_BEGIN
    {
      ALCSTR dll;
      /* char cwd[1024];
	 getcwd(cwd,1024);
	 dll=alcstrFormat("$PWD\\achat-$NAME.dll.",
	 "PWD", ASFORMAT_STRING,cwd,
	 "NAME",ASFORMAT_STRING,libname,
	 NULL); */
      dll=alcstrFormat("achat-$NAME",
		       "NAME",ASFORMAT_STRING,libname,
		       NULL);
      handle=LoadLibrary(dll);
    }
  ALCSTR_END;

  return handle;
}

void *
UILibraryGetSymbol(void *handle,const char *symname)
{
  return GetProcAddress(handle,symname);
}

void
UILibraryClose(void *handle)
{
  FreeLibrary(handle);
}
