/*
 * ui_shell.c
 *
 * $B%7%'%kHG$N(B aCHU^Hat $B$N%f!<%6%$%s%?!<%U%'%$%9ItJ,!#(B
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include "string.h"
#include "achat.h"
#include "ui.h"

/* #define DISABLE_SYSMSGLOG */

#ifdef DISABLE_SYSMSGLOG
static char LogFile[]="_log####";
static FILE *
fopenLogFile(const char *mode)
{
  time_t tim;
  struct tm *ttm;
  time(&tim);
  ttm=localtime(&tim);
  LogFile[4]='0'+(ttm->tm_mon+1)/10;
  LogFile[5]='0'+(ttm->tm_mon+1)%10;
  LogFile[6]='0'+(ttm->tm_mday)/10;
  LogFile[7]='0'+(ttm->tm_mday)%10;
  return fopen(LogFile,mode);
}
#endif

void
UIPrint(int type,const char *st)
{
  /* Standard Output $B$X=PNO(B */
  if( type&0x00FF )
    {
      printf("%s\n",st);
      fflush(stdout);
    }
  /* $B%m%0%U%!%$%k$X=PNO(B */
#ifdef DISABLE_SYSMSGLOG
  {
    FILE *fp;
    fp=fopenLogFile("at");
    if( fp)
      {
	fprintf(fp,"%s\n",st);
	fclose(fp);
      }
  }
#endif
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                    $B%W%i%0%$%s(B                    $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
#include <dlfcn.h>

void *
UILibraryOpen(const char *libname)
{
  void *handle;

  ALCSTR_BEGIN
    {
      ALCSTR so;
      char cwd[1024];
      getcwd(cwd,1024);
      so=alcstrFormat("$PWD/achat-$NAME.so",
		      "PWD", ASFORMAT_STRING,cwd,
		      "NAME",ASFORMAT_STRING,libname,
		      NULL);
      handle=dlopen(so,RTLD_LAZY);
    }
  ALCSTR_END;

  return handle;
}

void *
UILibraryGetSymbol(void *handle,const char *symname)
{
  return dlsym(handle,symname);
}

void
UILibraryClose(void *handle)
{
  dlclose(handle);
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                    $B%a%$%s4X?t(B                    $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

#include <dlfcn.h>

int
main(int argc,char *argv[])
{
  signal(SIGPIPE,SIG_IGN);

  {
    char *cp;
    cp=getenv("OSTYPE");
    Platform=(cp!=NULL)?alcstrCopySet(cp):alcstrCopySet("Unix");
  }

  Initilize();
  for(;;)
    {
      AchatMain();
      sleep(1);
    }

  return 0;
}
