#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#include "bufsock.h"
#include "string.h"
#include "plist.h"

#include "achat.h"
#include "datas.h"
#include "plugin.h"

static int     enableReturnFunc=0;
static PLUGIN *processingPlugin=NULL;
static CPLIST *returnString=NULL;
static PLIST  *allocated=NULL;

/*  */
/*  */
/* bb                                                  bb */
/* bb             vOCpo^֐             bb */
/* bb                                                  bb */
/*  */
/*  */

static PLIST *registeredFuncList=NULL;

typedef enum {
  REGFUNC_SYSTEM_MESSAGE,
  REGFUNC_WRITE_CONNECTION,
  REGFUNC_WRITE_MESSAGE,
  REGFUNC_WRITE_CLIENT,
  REGFUNC_COMMAND
} RegisteredFuncType;

/*  */
typedef struct{
  RegisteredFuncType type;
  ALCSTR plugin;
} RegisteredAnyFunc;

/* VXebZ[W */
typedef struct{
  RegisteredFuncType type;
  ALCSTR plugin;
  ALCSTR message;
} RegisteredSystemMessageFunc;

/* RlNVւ̃bZ[W */
typedef struct{
  RegisteredFuncType type;
  ALCSTR plugin;
  ALCSTR connection;
  ALCSTR message;
} RegisteredWriteConnectionFunc;

/* PRIVMSG/NOTICE */
typedef struct{
  RegisteredFuncType type;
  ALCSTR plugin;
  ALCSTR connection;
  ALCSTR command;
  ALCSTR target;
  ALCSTR message;
} RegisteredWriteMessageFunc;

/* NCAgւ̃bZ[W */
typedef struct{
  RegisteredFuncType type;
  ALCSTR plugin;
  ALCSTR client;
  ALCSTR message;
} RegisteredWriteClientFunc;

/* R}h */
typedef struct{
  RegisteredFuncType type;
  ALCSTR plugin;
  ALCSTR command;
} RegisteredCommandFunc;

/* p */
typedef union{
  RegisteredFuncType type;
  RegisteredAnyFunc             any;
  RegisteredSystemMessageFunc   systemMessage;
  RegisteredWriteConnectionFunc writeConnection;
  RegisteredWriteMessageFunc    writeMessage;
  RegisteredWriteClientFunc     writeClient;
  RegisteredCommandFunc         command;
} RegisteredFunc;

/* -------------------------------------------------- */
/* =============== VXebZ[W =============== */
/* -------------------------------------------------- */
static void
PluginCtrl_SystemMessage(const char *message)
{
  RegisteredSystemMessageFunc *rfp;
  if( processingPlugin==NULL || message==NULL )
    return;

  rfp=malloc(sizeof(RegisteredSystemMessageFunc));
  rfp->type   =REGFUNC_SYSTEM_MESSAGE;
  rfp->plugin =alcstrCopySet(processingPlugin->name);
  rfp->message=alcstrCopySet(message);

  plistAddItem(&registeredFuncList,rfp);
}

/* -------------------------------------------------- */
/* ========= RlNVւ̃bZ[Wo ========= */
/* -------------------------------------------------- */
static void
PluginCtrl_WriteToConnection(const char *connection,const char *message)
{
  RegisteredWriteConnectionFunc *rfp;
  if( processingPlugin==NULL || connection==NULL || message==NULL )
    return;

  rfp=malloc(sizeof(RegisteredWriteConnectionFunc));
  rfp->type      =REGFUNC_WRITE_CONNECTION;
  rfp->plugin    =alcstrCopySet(processingPlugin->name);
  rfp->connection=(connection!=NULL)?alcstrCopySet(connection):NULL;
  rfp->message   =alcstrCopySet(message);

  plistAddItem(&registeredFuncList,rfp);
}

/* -------------------------------------------------- */
/* =============== PRIVMSG/NOTICE =============== */
/* -------------------------------------------------- */
static void
PluginCtrl_WriteMessage(const char *connection, const char *command,
			const char *target, const char *message)
{
  RegisteredWriteMessageFunc *rfp;
  if( processingPlugin==NULL
      || connection==NULL || command==NULL || target==NULL || message==NULL
      || (!stringCmp(command, PLUGIN_CMD_PRIVMSG)
	  && !stringCmp(command, PLUGIN_CMD_NOTICE)) )
    return;

  rfp=malloc(sizeof(RegisteredWriteMessageFunc));
  rfp->type      =REGFUNC_WRITE_MESSAGE;
  rfp->plugin    =alcstrCopySet(processingPlugin->name);
  rfp->connection=alcstrCopySet(connection);
  rfp->command   =alcstrCopySet(command);
  rfp->target    =alcstrCopySet(target);
  rfp->message   =alcstrCopySet(message);

  plistAddItem(&registeredFuncList,rfp);
}

/* -------------------------------------------------- */
/* ========= NCAgւ̃bZ[Wo ========= */
/* -------------------------------------------------- */
static void
PluginCtrl_WriteToClient(const char *client,const char *message)
{
  RegisteredWriteClientFunc *rfp;
  if( processingPlugin==NULL || client==NULL || message==NULL )
    return;

  rfp=malloc(sizeof(RegisteredWriteClientFunc));
  rfp->type   =REGFUNC_WRITE_CLIENT;
  rfp->plugin =alcstrCopySet(processingPlugin->name);
  rfp->client =(client!=NULL)?alcstrCopySet(client):NULL;
  rfp->message=alcstrCopySet(message);

  plistAddItem(&registeredFuncList,rfp);
}

/* -------------------------------------------------- */
/* ==================== R}h ==================== */
/* -------------------------------------------------- */
static void
PluginCtrl_Command(const char *command)
{
  RegisteredCommandFunc *rfp;
  if( processingPlugin==NULL || command==NULL )
    return;

  rfp=malloc(sizeof(RegisteredCommandFunc));
  rfp->type   =REGFUNC_COMMAND;
  rfp->plugin =alcstrCopySet(processingPlugin->name);
  rfp->command=alcstrCopySet(command);

  plistAddItem(&registeredFuncList,rfp);
}

/* -------------------------------------------------- */
/* ================== Xg̏ ================== */
/* -------------------------------------------------- */
void
PluginFlushRegisteredFunc()
{
  RegisteredFunc *rfp;
  while( (rfp=plistGetItem(registeredFuncList,0)) != NULL )
    {
      PLUGIN *pp;
      pp=PluginGet(rfp->any.plugin);

      switch(rfp->type)
	{
	  /* VXebZ[W */
	case REGFUNC_SYSTEM_MESSAGE:
	  {
	    if(pp!=NULL)
	      SystemMessageF(SYSMSG_PLUGIN,"$PLUGIN: $MESSAGE",
			     "PLUGIN",  ASFORMAT_STRING, pp->name,
			     "MESSAGE", ASFORMAT_STRING,
			     ( rfp->systemMessage.message ),
			     NULL);
	    alcstrDestroy(rfp->systemMessage.message);
	    break;
	  }

	/* RlNVւ̏ */
	case REGFUNC_WRITE_CONNECTION:
	  {
	    CONNECTION *cnp;
	    cnp=ConnectionGet(rfp->writeConnection.connection);
	    if(cnp!=NULL)
	      ConnectionSendMessage(cnp,rfp->writeConnection.message);

	    alcstrDestroy(rfp->writeConnection.connection);
	    alcstrDestroy(rfp->writeConnection.message);
	    break;
	  }	  

	/* PRIVMSG/NOTICE  */
	case REGFUNC_WRITE_MESSAGE:
	  {
	    CONNECTION *cnp;
	    cnp=ConnectionGet(rfp->writeMessage.connection);
	    if(cnp!=NULL)
	      {
		/* T[o֑M */
		ConnectionSendMessageF(cnp, "$COMMAND $TARGET :$MESSAGE",
				       "COMMAND", ASFORMAT_STRING,
				       ( rfp->writeMessage.command ),
				       "TARGET", ASFORMAT_STRING,
				       ( rfp->writeMessage.target ),
				       "MESSAGE", ASFORMAT_STRING,
				       ( rfp->writeMessage.message ),
				       NULL);
		/* NCAgɑM */
		ALCSTR_BEGIN
		  {
		    CHANNEL *chp;
		    ALCSTR msg;
		    chp=ChannelGet(cnp,rfp->writeMessage.target);
		    msg=alcstrFormat(":$NICKNAME!$USERNAME@$ADDRESS "
				     "$COMMAND $TARGET :$MESSAGE",
				     "NICKNAME",ASFORMAT_STRING,Nickname,
				     "USERNAME",ASFORMAT_STRING,Username,
				     "ADDRESS", ASFORMAT_STRING,Hostname,
				     "COMMAND", ASFORMAT_STRING,
				     ( rfp->writeMessage.command ),
				     "TARGET",  ASFORMAT_STRING,
				     ( (chp!=NULL)
				       ? ChannelGetName(chp)
				       : rfp->writeMessage.target ),
				     "MESSAGE", ASFORMAT_STRING,
				     ( rfp->writeMessage.message ),
				     NULL);
		    PLISTLOOP_BEGIN( clp, CLIENT, Client )
		      {
			if( (chp!=NULL && !ClientIsJoinChannel(clp,chp))
			    || (chp==NULL && clp->flags&&CLFLAG_IGNOREPRIV) )
			  continue;
			ClientSendMessage(clp,msg);
		      }
		    PLISTLOOP_END;
		  }
		ALCSTR_END;
	      }
	    alcstrDestroy(rfp->writeMessage.connection);
	    alcstrDestroy(rfp->writeMessage.command);
	    alcstrDestroy(rfp->writeMessage.target);
	    alcstrDestroy(rfp->writeMessage.message);
	    break;
	  }	  

	/* NCAgւ̏ */
	case REGFUNC_WRITE_CLIENT:
	  {
	    CLIENT *clp;
	    clp=ClientGet(rfp->writeClient.client);
	    if(clp!=NULL)
	      ClientSendMessage(clp,rfp->writeClient.message);

	    alcstrDestroy(rfp->writeClient.client);
	    alcstrDestroy(rfp->writeClient.message);
	    break;
	  }

	/* aCHU^HatR}h */
	case REGFUNC_COMMAND:
	  {
	    CmdString(rfp->command.command);
	    alcstrDestroy(rfp->command.command);
	    break;
	  }
	}

      /* j */
      alcstrDestroy(rfp->any.plugin);
      plistDeleteItem(&registeredFuncList,rfp);
      free(rfp);
    }
}

/*  */
/*  */
/* bb                                                  bb */
/* bb             vOCp擾֐             bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ================= [J擾 ================= */
/* -------------------------------------------------- */
static const char *
PluginCtrl_GetLocalName(const char *connection,const char *globalName)
{
  CONNECTION *cnp;
  /* RlNṼ|C^擾 */
  cnp=ConnectionGet(connection);
  if(cnp==NULL) return NULL;
  /* ʎqt */
  return ConnectionAddDescriptor(cnp,globalName);
}

/* -------------------------------------------------- */
/* ================ lbg[N ================ */
/* -------------------------------------------------- */
static const NetworkInfo *
PluginCtrl_GetNetworkInfo(const char *network)
{
  NETWORK *np;
  int numServers;
  NetworkInfo *data;

  /* RlNVf[^擾 */
  np=NetworkGet(network);
  if(np==NULL)
    return NULL;

  /* `l擾 */
  numServers=plistNumberOfItem(np->server);

  /* ̈m */
  data=malloc( sizeof(NetworkInfo)
	       + numServers*sizeof(ALCSTR) );
  /* mۃۑ(ŊJ) */
  plistAddItem(&allocated, data);

  /* f[^̍쐬 */
  data->numServers=numServers;
  {
    int i;
    for(i=0; i<numServers; i++)
      {
	SERVER *sp;
	sp=plistGetItem(np->server,i);
	data->servers[i]=alcstrCopy(sp->name);
      }
  }

  return data;
}

/* -------------------------------------------------- */
/* =================== T[o =================== */
/* -------------------------------------------------- */
static const ServerInfo *
PluginCtrl_GetServerInfo(const char *server)
{
  SERVER *sp;
  ServerInfo *data;

  /* RlNVf[^擾 */
  sp=ServerGet(server);
  if(sp==NULL)
    return NULL;

  /* ̈m */
  data=malloc( sizeof(ServerInfo) );
  /* mۃۑ(ŊJ) */
  plistAddItem(&allocated, data);

  /* f[^̍쐬 */
  data->network = sp->network ? alcstrCopy(sp->network->name) : NULL;
  data->address = alcstrCopy(sp->address);
  data->port = sp->port;
  data->password = sp->password ? alcstrCopy(sp->password) : NULL;

  return data;
}

/* -------------------------------------------------- */
/* ================ RlNV ================ */
/* -------------------------------------------------- */
static const ConnectionInfo *
PluginCtrl_GetConnectionInfo(const char *connection)
{
  CONNECTION *cnp;
  int numChannels;
  ConnectionInfo *data;

  /* RlNVf[^擾 */
  cnp=ConnectionGet(connection);
  if(cnp==NULL)
    return NULL;

  /* `l擾 */
  numChannels=plistNumberOfItem(cnp->channel);

  /* ̈m */
  data=malloc( sizeof(ConnectionInfo)
	       + numChannels*sizeof(ALCSTR) );
  /* mۃۑ(ŊJ) */
  plistAddItem(&allocated, data);

  /* f[^̍쐬 */
  data->server     =alcstrCopy(cnp->server->name);
  data->isConnected=(cnp->bufsock!=NULL);
  data->nickname   =(cnp->myself!=NULL)?alcstrCopy(cnp->myself->nick):NULL;
  data->numChannels=numChannels;
  data->channels   =(ALCSTR*)(data+1);
  {
    int i;
    for(i=0; i<numChannels; i++)
      {
	CHANNEL *chp;
	chp=plistGetItem(cnp->channel,i);
	data->channels[i]=alcstrCopy(chp->name);
      }
  }

  return data;
}

/* -------------------------------------------------- */
/* =================== [U =================== */
/* -------------------------------------------------- */
static const UserInfo *
PluginCtrl_GetUserInfo(const char *connection,const char *nick)
{
  USER *up;
  UserInfo *data;
  int numChannels;

  /* [Uf[^̎擾 */
  {
    CONNECTION *cnp;
    cnp=ConnectionGet(connection);
    if(cnp==NULL)
      return NULL;
    up=UserGet(cnp,nick);
    if(up==NULL)
      return NULL;
  }

  /* `l */
  numChannels=
    plistNumberOfItem(up->channel);

  /* ̈̊m */
  data=malloc( sizeof(UserInfo)
	       + numChannels*sizeof(ALCSTR) );
  /* mۃۑ(ŊJ) */
  plistAddItem(&allocated, data);

  /* f[^̍쐬 */
  data->numChannels=numChannels;
  data->channels=(ALCSTR*)(data+1);
  {
    int i;
    for(i=0; i<numChannels; i++)
      {
	CHANNEL *chp;
	chp=plistGetItem(up->channel,i);
	data->channels[i]=alcstrCopy(chp->name);
      }
  }
 
  return data;
}

/* -------------------------------------------------- */
/* ================= `l ================= */
/* -------------------------------------------------- */
static const ChannelInfo *
PluginCtrl_GetChannelInfo(const char *connection,const char *channel)
{
  CHANNEL *chp;
  ChannelInfo *data;
  int numUsers;
  ChannelInfoUser *users;

  /* `lf[^̎擾 */
  {
    CONNECTION *cnp;
    cnp=ConnectionGet(connection);
    if(cnp==NULL)
      return NULL;
    chp=ChannelGet(cnp,channel);
    if(chp==NULL)
      return NULL;
  }

  /* [U */
  numUsers=
    plistNumberOfItem(chp->chuser);

  /* ̈̊m */
  data=malloc( sizeof(ChannelInfo)
	       + numUsers*sizeof(ChannelInfoUser) );
  /* mۃۑ(ŊJ) */
  plistAddItem(&allocated, data);

  /* f[^̍쐬 */
  data->topic=alcstrCopy(chp->topic);
  data->numUsers=numUsers;
  data->users=users=(ChannelInfoUser*)(data+1);
  {
    int i;
    for(i=0; i<numUsers; i++)
      {
	CHUSER *cup;
	cup=plistGetItem(chp->chuser,i);
	users[i].modeo=cup->modeo;
	users[i].modev=cup->modev;
	users[i].nick =alcstrCopy(cup->user->nick);
      }
  }
 
  return data;
}

/* -------------------------------------------------- */
/* =============== CRlNV =============== */
/* -------------------------------------------------- */
static const char *
PluginCtrl_GetMainConnection()
{
  if(MainConnection==NULL)
    return NULL;
  return alcstrCopy(MainConnection->name);
}

/* -------------------------------------------------- */
/* ================== ̃jbN ================== */
/* -------------------------------------------------- */
static const char *
PluginCtrl_GetNickname()
{
  return alcstrCopy(Nickname);
}

/*  */
/*  */
/* bb                                                  bb */
/* bb              ̑̃vOC֐              bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ================ ߂蕶񃊃Xg ================ */
/* -------------------------------------------------- */
static int
PluginCtrl_ReturnString(const char *string)
{ 
  /* ̖߂Ă邩`FbN */
  if(!enableReturnFunc)
    return -1;

  /* Xgɒǉ */
  cplistAddItem( &returnString, alcstrCopySet(string) );

  return 0;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb              vOC⏕֐              bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* =========== vOC̑p֐擾 =========== */
/* -------------------------------------------------- */
void
PluginSetCtrlFunc(PluginCtrl *ctrl)
{
  ctrl->getLocalName=PluginCtrl_GetLocalName;
  ctrl->getNetworkInfo    = PluginCtrl_GetNetworkInfo;
  ctrl->getServerInfo     = PluginCtrl_GetServerInfo;
  ctrl->getConnectionInfo = PluginCtrl_GetConnectionInfo;
  ctrl->getChannelInfo    = PluginCtrl_GetChannelInfo;
  ctrl->getUserInfo       = PluginCtrl_GetUserInfo;
  ctrl->getMainConnection = PluginCtrl_GetMainConnection;
  ctrl->getNickname       = PluginCtrl_GetNickname;

  ctrl->systemMessage     = PluginCtrl_SystemMessage;
  ctrl->writeToConnection = PluginCtrl_WriteToConnection;
  ctrl->writeMessage      = PluginCtrl_WriteMessage;
  ctrl->writeToClient     = PluginCtrl_WriteToClient;
  ctrl->command           = PluginCtrl_Command;

  ctrl->returnFunc        = PluginCtrl_ReturnString;
}

/* -------------------------------------------------- */
/* ============== vOCw ============== */
/* -------------------------------------------------- */
/* w */
void
PluginSetProcessing(PLUGIN *plugin,int enableReturnFuncSpecification)
{
  if(processingPlugin!=NULL)
    PluginResetProcessing();

  processingPlugin=plugin;
  enableReturnFunc=enableReturnFuncSpecification;
  returnString=NULL;
  allocated=NULL;
}

/* w */
CPLIST *
PluginResetProcessing(void)
{
  CPLIST *returnStringTmp;
  returnStringTmp=returnString;

  processingPlugin=NULL;
  returnString=NULL;
  while(allocated!=NULL)
    {
      void *tmp;
      tmp=plistGetItem(allocated,0);
      plistDeleteItem(&allocated,tmp);
      free(tmp);
    }

  return returnStringTmp;
}

/* -------------------------------------------------- */
/* ============= vOC֐Ăяo ============= */
/* -------------------------------------------------- */
void
PluginCallFunction( const char *arg1, const char *arg2, int funcPos )
{
  PLISTLOOP_BEGIN(pp,PLUGIN,Plugin)
    {
      void (*func)( const char *arg1, const char *arg2 );
      func = *( (void (**)(const char *,const char *))
		( ((char*)pp)+funcPos )                );

      if(func==NULL)
	continue;
      
      PluginSetProcessing(pp,0);
      ALCSTR_BEGIN
	{
	  func( arg1, arg2);
	}
      ALCSTR_END;
      PluginResetProcessing();
    }
  PLISTLOOP_END;
}

CPLIST *
PluginFilterFunction( const char *arg1, const char *line, int funcPos )
{
  CPLIST *lines=NULL;
  cplistAddItem( &lines, alcstrCopySet(line) );

  PLISTLOOP_BEGIN(pp,PLUGIN,Plugin)
    {
      void (*func)( const char *arg1, const char *arg2 );
      func = *( (void (**)(const char *,const char *))
		( ((char*)pp)+funcPos )                );

      if(func==NULL)
	continue;
      
      PluginSetProcessing(pp,1);
      ALCSTR_BEGIN
	{
	  ALCSTR arg2;
	  while( (arg2=cplistGetItem(lines,0)) )
	    {
	      func( arg1, arg2 );
	      cplistDeleteItem( &lines, arg2 );
	    }
	}
      ALCSTR_END;
      lines=PluginResetProcessing();
    }
  PLISTLOOP_END;

  return lines;
}
