/*
 * main.c
 *
 * aCHU^HatCB
 */

#ifdef _WIN32
#  include <windows.h>
#else
#  ifdef HAVE_CONFIG_H
#    include "config.h"
#  endif
#  include <stdio.h>
#  include <stdlib.h>
#  include <string.h>
#  include <sys/types.h>
#  include <sys/time.h>
#  include <unistd.h>
#endif

#include "plist.h"
#include "string.h"
#include "achat.h"
#include "ui.h"

int RetryTime=10;
time_t StartTime,NowTime;
ALCSTR Hostname;
ALCSTR Version ;		/* o[W */
ALCSTR Platform;		/* vbgz[ */
ALCSTR RCFilename=NULL;

int ErrorReason;

void
SystemMessage(int type,const char *msg)
{
  ALCSTR_BEGIN
    {
      ALCSTR as;
      as=alcstrFormat("NOTICE $NICKNAME :$MESSAGE\r\n",
		      "NICKNAME",ASFORMAT_STRING,Nickname,
		      "MESSAGE" ,ASFORMAT_STRING,msg,
		      NULL);
      PLISTCLIENTLOOP_BEGIN(clp)
	{
	  if(clp->check==CLIENT_CHECK_ALLRIGHT && type&clp->sysmsgMask)
	    bufsockWriteString(clp->bufsock,as);
	}
      PLISTLOOP_END;
    }
  ALCSTR_END;

  UIPrint(type,msg);
}

void
SystemMessageF(int type,const char *fmt,...)
{
  va_list argp;
  va_start(argp, fmt);
  ALCSTR_BEGIN
    {
      SystemMessage(type,alcstrFormatV(fmt,argp));
    }
  ALCSTR_END;
  va_end(argp);
}


int
ListenStart()
{
  /* łɐڑҋ@Ȃ΁ÃfBXNv^N[Y */
  if(ListenBufsock!=NULL)
    bufsockDestroy(ListenBufsock);
  /* ڑҋ@ */
  ListenBufsock=bufsockCreateListen(ListenPort);
  /* s */
  if(ListenBufsock==NULL)
    {
      SystemMessageF(SYSMSG_SYSTEM,
		     "Couldn't bind to port $PORT",
		     "PORT",ASFORMAT_INT,ListenPort,
		     NULL);
      ListenLastTry=NowTime;
      return -1;
    }
  /*  */
  else
    {
      SystemMessageF(SYSMSG_SYSTEM,"$HOSTNAME:$PORT listen Ok",
		     "HOSTNAME",ASFORMAT_STRING,Hostname,
		     "PORT"    ,ASFORMAT_INT   ,ListenPort,
		     NULL);
      return AERROR_NONE;
    }
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                     main֐                     bb */
/* bb                                                  bb */
/*  */
/*  */

void
Initilize(void)
{
  /* Nԕۑ */
  time(&StartTime);
  /* zXg擾 */
  {
    char tmp[256];
    gethostname(tmp,256);
    Hostname=alcstrCopySet(tmp);
  }
  /* jbN */
  Nickname=alcstrCopySet("*");
  /* o[W񐶐 */
  Version=alcstrSet(alcstrFormat(SERVER_VERSION" $PLATFORM",
				 "PLATFORM",ASFORMAT_STRING,Platform,
				 NULL));

  /* ݒt@Cǂݍ */
  if(RCFilename==NULL)
    RCFilename=alcstrCopySet("achat.rc");
  CmdFile(RCFilename);

  /* X^oC */
  SystemMessageF(SYSMSG_SYSTEM,"$VERSION stand by!",
		 "VERSION",ASFORMAT_STRING,Version,
		 NULL);
}

void
AchatMain(void)
{
  for(;;)
    {
      int i,maxfd;
      fd_set fds;
      struct timeval timeout;

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ---------------- select ---------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      FD_ZERO(&fds);
      maxfd=0;

      /* ڑҋ@ */
      if(ListenBufsock!=NULL)
	maxfd=bufsockSetFdset(ListenBufsock,&fds,maxfd);

      /* RlNV */
      PLISTCONNECTIONLOOP_BEGIN(cnp)
	{
	  if(cnp->bufsock!=NULL)
	    maxfd=bufsockSetFdset(cnp->bufsock,&fds,maxfd);
	}
      PLISTLOOP_END;

    /* NCAg */
    PLISTCLIENTLOOP_BEGIN(clp)
      {
      maxfd=bufsockSetFdset(clp->bufsock,&fds,maxfd);
      }
    PLISTLOOP_END;

    /* ^CAEg */
    timeout.tv_sec =       0;
    timeout.tv_usec=100*1000;

    /* select */
    i=select(maxfd+1,&fds,NULL,NULL,&timeout);
    if(i<=0)
      break;

    /* QQQQQQQQQQQQQQQQQQQQ */
    /* ---------- bZ[Wǂݎ ---------- */
    /* PPPPPPPPPPPPPPPPPPPP */
    /* T[õbZ[W */
    PLISTCONNECTIONLOOP_BEGIN(cnp)
      {
	if(bufsockIsSetFdset(cnp->bufsock,&fds))
	  {
	    cnp->update=NowTime;
	    cnp->flags&=~CNFLAG_SENDPING;
	    if(bufsockRead(cnp->bufsock)==0)
	      ConnectionClose(cnp);
	  }
      }
    PLISTLOOP_END;

    /* NCAg̃bZ[W */
    PLISTCLIENTLOOP_BEGIN(clp)
      {
	if(bufsockIsSetFdset(clp->bufsock,&fds))
	  {
	    clp->update=NowTime;
	    clp->flags&=~CLFLAG_SENDPING;
	    if(bufsockRead(clp->bufsock)==0)
	      ClientDestroy(clp);
	  }
      }
    PLISTLOOP_END;

    /* QQQQQQQQQQQQQQQQQQQQ */
    /* --------- NCAgڑҋ@ --------- */
    /* PPPPPPPPPPPPPPPPPPPP */
    if(bufsockIsSetFdset(ListenBufsock,&fds))
      {
	CLIENT *clp;
	BUFSOCK bufsock;
	bufsock=bufsockCreateAccept(ListenBufsock);
	clp=ClientCreate(bufsock);
	ALCSTR_BEGIN
	  {
	    SystemMessageF(SYSMSG_CLIENT,
			   "Accept client $ADDRESS:$PORT",
			   "ADDRESS",ASFORMAT_STRING,
			   bufsockGetAddress(clp->bufsock),
			   "PORT",ASFORMAT_INT,
			   bufsockGetPort(clp->bufsock),
			   NULL);
	  }
	ALCSTR_END;
      }

    }
  time(&NowTime);

  /* NCAgҋ@ */
  if(ListenBufsock==NULL)
    {
      if(NowTime-ListenLastTry>RetryTime)
	ListenStart();
    }
  /* QQQQQQQQQQQQQQQQQQQQ */
  /* -------- RlNVf[^ -------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  PLISTCONNECTIONLOOP_BEGIN(cnp)
    {
      ReadConnectionMessage(cnp);
    }
  PLISTLOOP_END;
  
  /* QQQQQQQQQQQQQQQQQQQQ */
  /* -------- NCAgf[^ -------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  PLISTCLIENTLOOP_BEGIN(clp)
    {
      SetReplyTarget(clp);
      ReadClientMessage(clp);
    }
  PLISTLOOP_END;
  SetReplyTarget(NULL);

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ------------ vOC ------------ */
  /* PPPPPPPPPPPPPPPPPPPP */
  PLISTLOOP_BEGIN(pp,PLUGIN,Plugin)
    {
      if(pp->timer==NULL)
	continue;
      PluginSetProcessing(pp,0);
      ALCSTR_BEGIN
	{
	  pp->timer();
	}
      ALCSTR_END;
      PluginResetProcessing();
    }
  PLISTLOOP_END;

  PluginFlushRegisteredFunc();
}
