#ifndef __ACHAT_DATAS_HEADER__
#define __ACHAT_DATAS_HEADER__

#include "plist.h"
#include "time.h"
#include "bufsock.h"
#include "plugin.h"

typedef struct irc_network	NETWORK;
typedef struct irc_server	SERVER;
typedef struct irc_channel	CHANNEL;
typedef struct irc_user		USER;
typedef struct connection	CONNECTION;
typedef struct irc_client	CLIENT;
typedef struct join_request	JOINREQ;

extern int ErrorReason;
#define AERROR_NONE                        0x000
#define AERROR_CANT_ALLOC                  0x001
#define AERROR_NETWORK_HASNO_SERVER        0x002
#define AERROR_NAME_EXIST                  0x003
#define AERROR_CLOSED                      0x004
#define AERROR_NAME_NOTEXAST               0x100
#define AERROR_NOSUCH_NETWORK              0x101
#define AERROR_NOSUCH_SERVER               0x102
#define AERROR_NOSUCH_NETWORK_OR_SERVER    0x103
#define AERROR_NOSUCH_CONNECTION           0x104
#define AERROR_NOSUCH_CLIENT               0x108
#define AERROR_NOSUCH_CHANNEL              0x110
#define AERROR_NOSUCH_USER                 0x120
#define AERROR_TOOLONG_STRING              0x201
#define AERROR_NOT_CONNECTED               0x301
#define AERROR_COULDNT_CONNECTED           0x302
#define AERROR_ALREADYJOIN_CHANNEL         0x401
#define AERROR_NOTJOIN_CHANNEL             0x402

#define ERRORRETURN(error) {ErrorReason=(error); return NULL;}
#define NOERRORRETURN      {return AERROR_NONE;}
#define FATALERROR          *((int*)NULL)=0


/* -------------------------------------------------- */
/* ================== lbg[N ================== */
/* -------------------------------------------------- */
struct irc_network{
  ALCSTR  name;
  PLIST  *server;
  PLIST  *joinRequest;
};

NETWORK *NetworkGet(const char *name);
NETWORK *NetworkCreate(const char *name);
void     NetworkDestroy(NETWORK *net);

/* -------------------------------------------------- */
/* ===================== T[o ===================== */
/* -------------------------------------------------- */
struct irc_server{
  NETWORK *network;
  ALCSTR   name;
  ALCSTR   address;
  ALCSTR   password;
  int      port;
  PLIST   *connection;
  PLIST   *joinRequest;
};

SERVER *ServerGet(const char *name);
SERVER *ServerCreate(const char *name);
void    ServerDestroy(SERVER *sp);
void    ServerSet(SERVER *sp,const char *addr,int port,const char *pass);
void    ServerSetNetwork   (SERVER *sp,NETWORK *np);
void    ServerChangeNetwork(SERVER *sp,NETWORK *np);
void    ServerResetNetwork (SERVER *sp);

/* -------------------------------------------------- */
/* =================== `l =================== */
/* -------------------------------------------------- */
typedef struct irc_channel_user{
  USER   *user;
  time_t  joined;
  int     modeo;
  int     modev;
} CHUSER;

struct irc_channel{
  ALCSTR name;
  ALCSTR topic;
  PLIST  *chuser;
  CONNECTION *connection;
};

CHANNEL *ChannelGet(CONNECTION *cnp,const char *name);
CHANNEL *ChannelCreate(CONNECTION *cnp,const char *name);
void     ChannelDestroy(CHANNEL *chp);
ALCSTR   ChannelGetName(CHANNEL *chp);
/* [U */
int     ChannelHasUser   (CHANNEL *chp,USER *up);
void    ChannelAddUser   (CHANNEL *chp,USER *up);
void    ChannelDeleteUser(CHANNEL *chp,USER *up);
CHUSER *ChannelGetChuser (CHANNEL *chp,USER *up);
void ChannelSetOp  (CHANNEL *chp,USER *up);
void ChannelSetV   (CHANNEL *chp,USER *up);
void ChannelResetOp(CHANNEL *chp,USER *up);
void ChannelResetV (CHANNEL *chp,USER *up);
int  ChannelCheckOp(CHANNEL *chp,USER *up);
int  ChannelCheckV (CHANNEL *chp,USER *up);

#define PLISTCHANNELLOOP_BEGIN(channelp) \
  PLISTLOOP_BEGIN(channelp,CHANNEL,Channel)
#define PLISTCHUSERLOOP_BEGIN(userp,channelp) \
  PLISTLOOP_BEGINDETAIL(cup,CHUSER,(channelp)->chuser,USER *userp,userp=cup->user)

/* -------------------------------------------------- */
/* ===================== [U ===================== */
/* -------------------------------------------------- */
struct irc_user{
  ALCSTR  nick;
  PLIST  *channel;
  CONNECTION *connection;
};

USER   *UserGet(CONNECTION *cnp,const char *nick);
USER   *UserCreate(CONNECTION *cnp,const char *nick);
void    UserDestroy(USER *up);
ALCSTR  UserGetNick(USER *up);
void    UserNick(USER *up,const char *newNick);

/* -------------------------------------------------- */
/* ================== RlNV ================== */
/* -------------------------------------------------- */
#define CNFLAG_AUTOCONNECT   0x0001 /* ڑtO */
#define CNFLAG_AUTOREJOIN    0x0002 /* KICK̎JOINtO */
#define CNFLAG_SPECIFYSERVER 0x0100 /* T[ow肩lbg[Nw肩 */
#define CNFLAG_REGISTERED    0x0200 /* ڑo^tO */
#define CNFLAG_SENDPING      0x0400 /* PINGMǂ */
#define CNSTAT_NONE  0
#define CNSTAT_NAMES 1

typedef struct keep_channel{
  ALCSTR name;
  time_t lastTry;
  int    hasJoined;
} KPCHANNEL;

struct connection{
  BUFSOCK  bufsock;		/* \Pbg */
  ALCSTR   name;		/* RlNV */
  time_t   update;		/* XV(ڑAؒfAbZ[WMɍXV) */
  SERVER  *server;		/* T[o */
  PLIST   *channel;		/* `l */
  PLIST   *user;		/* [U */
  PLIST   *kpchannel;		/* ێ`l */
  PLIST   *loseSightUser;	/* [U */
  USER    *myself;		/* g̃[U */
  int      flags;		/* tO(CNFLAG_*Q) */
  int      stat;		/* Xe[^X(CNSTAT_*Q) */
  CPLIST  *statarg;		/* Xe[^X */
};

extern CONNECTION dummyConnection;
#define CONNECTION_NOT_SPECIFIED (&dummyConnection)

CONNECTION *ConnectionGet(const char *name);
CONNECTION *ConnectionGetByBufsock(BUFSOCK  bufsock);
CONNECTION *ConnectionGetByNetwork(NETWORK *network);
CONNECTION *ConnectionGetByServer (SERVER  *server );
CONNECTION *ConnectionGetByName(ALCSTR *realname,
				const char *name,
				CONNECTION *defaultConnection);
CONNECTION *ConnectionCreate(const char *name);
void ConnectionDestroy(CONNECTION *cnp);

/* ێ`l */
KPCHANNEL *ConnectionGetKpchannel(CONNECTION *cnp,ALCSTR cname);
KPCHANNEL *ConnectionAddKpchannel(CONNECTION *cnp,ALCSTR cname);
int ConnectionClearKpchannel(CONNECTION *cnp);

/* \Pbg֘A */
int  ConnectionOpen(CONNECTION *cnp);
int  ConnectionClose(CONNECTION *cnp);
int  ConnectionCheck(CONNECTION *cnp);
int  ConnectionSendMessage (CONNECTION *cnp,const char *msg);
int  ConnectionSendMessageF(CONNECTION *cnp,const char *fmt,...);
/* T[ow */
void ConnectionChangeServer(CONNECTION *cnp,SERVER *sp);
void ConnectionChangeServerNetworkFirst(CONNECTION *cnp);
void ConnectionChangeServerNetworkNext (CONNECTION *cnp);
void ConnectionSetServer (CONNECTION *cnp,SERVER *sp);
void ConnectionSetNetwork(CONNECTION *cnp,NETWORK *np);

/* RlNVʎq */
ALCSTR ConnectionAddDescriptor(CONNECTION *cnp,const char *name);

#define PLISTCONNECTIONLOOP_BEGIN(connectionp) \
  PLISTLOOP_BEGIN(connectionp,CONNECTION,Connection)

/* -------------------------------------------------- */
/* ================== NCAg ================== */
/* -------------------------------------------------- */

#define CLIENT_CHECK_PASS     1
#define CLIENT_CHECK_USER     2
#define CLIENT_CHECK_NICK     4
#define CLIENT_CHECK_NONE     0
#define CLIENT_CHECK_ALLRIGHT 7
#define CLFLAG_ALLCHANNEL     0x0001
#define CLFLAG_IGNOREPRIV     0x0002
#define CLFLAG_SENDPING       0x0100

struct irc_client{
  BUFSOCK  bufsock;	/* \Pbg */
  time_t   update;	/* XV(ڑAؒfAbZ[WMɍXV) */
  int      check;	/* F؃`FbN */
  int      flags;	/* tO(CLFLAG_* Q) */
  int      sysmsgMask;	/* \VXebZ[W̃}XN */
  ALCSTR   name;	/* NCAg */
  PLIST   *channel;	/* `l */
  PLIST   *joinRequest;	/* JOINNGXg */
};

CLIENT *ClientGet(const char *name);
CLIENT *ClientCreate(BUFSOCK bufsock);
void    ClientDestroy(CLIENT *clp);
/* `l */
int ClientIsJoinChannel(CLIENT *clp,CHANNEL *chp);
int ClientJoinChannel(CLIENT *clp,CHANNEL *chp);
int ClientPartChannel(CLIENT *clp,CHANNEL *chp);
/* \Pbg֘A */
int ClientSendNotice  (CLIENT *clp,const char *notice);
int ClientSendNoticeF (CLIENT *clp,const char *fmt,...);
int ClientSendMessage (CLIENT *clp,const char *msg);
int ClientSendMessageF(CLIENT *clp,const char *fmt,...);

#define PLISTCLIENTLOOP_BEGIN(clientp) \
  PLISTLOOP_BEGIN(clientp,CLIENT,Client)

/* -------------------------------------------------- */
/* ==================== JOINv ==================== */
/* -------------------------------------------------- */

struct join_request{
  NETWORK *network;	/* lbg[N */
  SERVER  *server;	/* T[o
			   (T[oƃlbg[NꂩNULLƂ) */
  CLIENT  *client;	/* NCAg */
  ALCSTR   channelName;	/* `l */
  time_t time;
};

JOINREQ *JoinreqCreate(CLIENT *client,const char *channelName);
JOINREQ *JoinreqCreateByServer(CLIENT *client,
			       SERVER *server,const char *channelName);
JOINREQ *JoinreqCreateByNetwork(CLIENT *client,
			       NETWORK *network,const char *channelName);
JOINREQ *JoinreqCreateByConnection(CLIENT *client,
				   CONNECTION *connection,
				   const char *channelName);

JOINREQ *JoinreqGetByConnection(CLIENT *client,
				CONNECTION *connection,
				const char *channelName);
int JoinreqDestroy(JOINREQ *joinreq);

/* -------------------------------------------------- */
/* ============== vOCW[ ============== */
/* -------------------------------------------------- */
typedef struct plugin_module{
  ALCSTR name,library;
  void *libHandle;
  PluginCtrl *pluginCtrl;
  void (*initilize)(PluginCtrl *ctrl);
  void (*timer)();
  int  (*command)(const char *line);
  void (*connectionClose)      (const char *connection,const char *reason);
  void (*connectionRead)       (const char *connection,const char *line);
  void (*connectionWrite)      (const char *connection,const char *line);
  void (*connectionReadFilter) (const char *connection,const char *line);
  void (*connectionWriteFilter)(const char *connection,const char *line);
  void (*clientClose)      (const char *client,const char *reason);
  void (*clientRead)       (const char *client,const char *line);
  void (*clientWrite)      (const char *client,const char *line);
  void (*clientReadFilter) (const char *client,const char *line);
  void (*clientWriteFilter)(const char *client,const char *line);
} PLUGIN;

PLUGIN *PluginGet(const char *name);
PLUGIN *PluginCreate(const char *name);
void    PluginDestroy(PLUGIN *pp);
int     PluginOpenLibrary(PLUGIN *pp,const char *library);
void    PluginCloseLibrary(PLUGIN *pp);

/* ===== ȉ plugin.c ̊֐ ===== */
void    PluginSetProcessing(PLUGIN *pp,int enableReturnFunc);
CPLIST *PluginResetProcessing(void);
void    PluginFlushRegisteredFunc(void);
void    PluginSetCtrlFunc(PluginCtrl *ctrl);

void    PluginCallFunction  ( const char *arg1,
			      const char *arg2, int funcPos );
CPLIST *PluginFilterFunction( const char *arg1,
			      const char *arg2, int funcPos );

#define PLUGIN_FUNCPOS(func) ( (int) &( ((PLUGIN*)NULL)->func ) )


/* -------------------------------------------------- */
/* ================== ݒt@C ================== */
/* -------------------------------------------------- */
CPLIST *RCFileRead(void);
int RCFileWrite(CPLIST *lines);
int RCFileClear(CPLIST *lines);

#endif
