/*
 * data.c
 *
 * aCHU^Hatň{f[^̏
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "string.h"
#include "plist.h"

#include "achat.h"

PLIST *Network   =NULL;
PLIST *Server    =NULL;
PLIST *Channel   =NULL;
PLIST *User      =NULL;
PLIST *Connection=NULL;
PLIST *Client    =NULL;
PLIST *Plugin    =NULL;

CONNECTION *MainConnection=NULL;
CPLIST *StartNick=NULL;
ALCSTR Username=NULL,Realname=NULL,Nickname,Password;
time_t  ListenLastTry=   0;
int     ListenPort   =6667;
BUFSOCK ListenBufsock=NULL;
int NameSplit='/';
int LogLines=10;

int DefaultClientFlags    =0;
int DefaultConnectionFlags=0;


#define GETPOINTERFUNC(type,start,bool) \
  PLISTLOOP_BEGIN(pointer,type,start){		\
    if(bool) return pointer;			\
  }PLISTLOOP_END;				\
  return NULL

/*  */
/*  */
/* bb                                                  bb */
/* bb                lbg[Nf[^                bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ====================== 擾 ====================== */
/* -------------------------------------------------- */
NETWORK *
NetworkGet(const char *name)
{
  GETPOINTERFUNC(NETWORK,Network,stringCmp(pointer->name,name));
}

/* -------------------------------------------------- */
/* ====================== ǉ ====================== */
/* -------------------------------------------------- */
NETWORK *
NetworkCreate(const char *name)
{
  NETWORK *np;
  if((np=NetworkGet(name))!=NULL)
    return NULL;

  plistAddItem(&Network,np=malloc(sizeof(NETWORK)));
  np->name       =alcstrSet(alcstrCopy(name));
  np->server     =NULL;
  np->joinRequest=NULL;

  /* bZ[W */
  SystemMessageF(SYSMSG_NETWORK,"Network($NETWORK) has created",
		 "NETWORK",ASFORMAT_STRING,np->name,
		 NULL);
  return np;
}

/* -------------------------------------------------- */
/* ====================== 폜 ====================== */
/* -------------------------------------------------- */
void
NetworkDestroy(NETWORK *np)
{
  PLISTLOOP_BEGIN(sp,SERVER,np->server)
    ServerResetNetwork(sp);
  PLISTLOOP_END;

  while(np->joinRequest!=NULL)
    JoinreqDestroy(plistGetItem(np->joinRequest,0));

  /* bZ[W */
  SystemMessageF(SYSMSG_NETWORK,"Network($NETWROK) has destroied",
		 "NETWORK",ASFORMAT_STRING,np->name,
		 NULL);

  plistDeleteItem(&Network,np);
  alcstrDestroy(np->name);
  free(np);
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                   T[of[^                   bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ====================== 擾 ====================== */
/* -------------------------------------------------- */
SERVER *
ServerGet(const char *name)
{
  GETPOINTERFUNC(SERVER,Server,stringCmp(pointer->name,name));
}

/* -------------------------------------------------- */
/* ====================== ǉ ====================== */
/* -------------------------------------------------- */
SERVER *
ServerCreate(const char *name)
{
  SERVER *sp;
  if(NetworkGet(name)!=NULL)
    return NULL;
  if(ServerGet(name) !=NULL)
    return NULL;

  sp=malloc(sizeof(SERVER));
  plistAddItem(&Server,sp);
  sp->name       =alcstrSet(alcstrCopy(name));
  sp->address    =NULL;
  sp->port       =  -1;
  sp->password   =NULL;
  sp->network    =NULL;
  sp->connection =NULL;
  sp->joinRequest=NULL;

  SystemMessageF(SYSMSG_SERVER,"Server($server) has created",
		 "SERVER" ,ASFORMAT_STRING,sp->name,
		 NULL);
  return sp;
}

/* -------------------------------------------------- */
/* ====================== 폜 ====================== */
/* -------------------------------------------------- */
void
ServerDestroy(SERVER *sp)
{
  if(sp->network!=NULL)
    ServerResetNetwork(sp);

  PLISTLOOP_BEGIN(cnp,CONNECTION,Connection)
    {
      if(cnp->server==sp)
	ConnectionDestroy(cnp);
    }
  PLISTLOOP_END;

  while(sp->joinRequest!=NULL)
    JoinreqDestroy(plistGetItem(sp->joinRequest,0));

  /* bZ[W */
  SystemMessageF(SYSMSG_SERVER,"Server($SERVER) has destroied",
		 "SERVER",ASFORMAT_STRING,sp->name,
		 NULL);

  plistDeleteItem(&Server,sp);
  /* ̈J */
  alcstrDestroy(sp->name);
  if(sp->address !=NULL)
    alcstrDestroy(sp->address );
  if(sp->password!=NULL)
    alcstrDestroy(sp->password);

  free(sp);
}

/* -------------------------------------------------- */
/* ====================== ݒ ====================== */
/* -------------------------------------------------- */
void
ServerSet(SERVER *sp,const char *addr,int port,const char *pass)
{
  int update=0;
  if(sp==NULL)
    FATALERROR;

  /* T[o */
  if(sp->address==NULL)
    update=1;
  else
    {
      if(strcmp(sp->address,addr)!=0)
	update=1;
    }
  alcstrUpdate(&sp->address,addr);

  /* |[gԍ */
  if(port!=sp->port)
    update=1;
  sp->port=port;

  /* pX[h */
  if(sp->password==NULL)
    update=1;
  else
    {
      if(strcmp(sp->password,pass)!=0)
	update=1;
    }
  alcstrUpdate(&sp->password,pass);

  /* 񂪍XVꂽꍇ́ARlNVUؒf */
  if(update)
    {
      PLISTCONNECTIONLOOP_BEGIN(cnp)
	{
	  if(cnp->server==sp && cnp->bufsock!=NULL)
	    {
	      ConnectionClose(cnp);
	      ConnectionChangeServer(cnp,sp);
	    }
	}
      PLISTLOOP_END;
      if(sp->password!=NULL)
	SystemMessageF(SYSMSG_SERVER,"Server($SERVER) has set "
		     "$ADDRESS:$PORT(password:$PASSWORD)",
		     "SERVER",  ASFORMAT_STRING,sp->name,
		     "ADDRESS", ASFORMAT_STRING,sp->address,
		     "PORT",    ASFORMAT_INT   ,sp->port,
		     "PASSWORD",ASFORMAT_STRING,sp->password,
		     NULL);
      else
	SystemMessageF(SYSMSG_SERVER,"Server($SERVER) has set $ADDRESS:$PORT",
		       "SERVER",  ASFORMAT_STRING,sp->name,
		       "ADDRESS", ASFORMAT_STRING,sp->address,
		       "PORT",    ASFORMAT_INT   ,sp->port,
		       NULL);
    }
}

/* -------------------------------------------------- */
/* ================== lbg[N ================== */
/* -------------------------------------------------- */
void
ServerSetNetwork(SERVER *sp,NETWORK *np)
{
  if(sp==NULL)
    FATALERROR;
  if(np==NULL)
    FATALERROR;
  if(sp->network!=NULL)
    FATALERROR;

  /* T[of[^Ƀlbg[No^ */
  sp->network=np;

  /* lbg[Nf[^ɃT[oo^ */
  plistAddItem(&np->server,sp);

  /* bZ[W */
  SystemMessageF(SYSMSG_SERVER,"Server($SERVER) has set network($NETWORK)",
		 "SERVER", ASFORMAT_STRING,sp->name,
		 "NETWORK",ASFORMAT_STRING,np->name,
		 NULL);
}

void
ServerResetNetwork(SERVER *sp)
{
  NETWORK *np;
  if(sp==NULL)
    FATALERROR;
  if(sp->network==NULL)
    FATALERROR;
  np=sp->network;
  /* T[of[^Ƀlbg[No^ */
  sp->network=NULL;
  /* lbg[Nf[^ɃT[oo^ */
  plistDeleteItem(&np->server,sp);

  /* T[owłȂ(lbg[Nw)ł̃RlNV̏ */
  {
    int i;
    CONNECTION *cnp;
    for(i=0;(cnp=plistGetItem(Connection,i))!=NULL;i++)
      {
	if(cnp->server==sp && !(cnp->flags&CNFLAG_SPECIFYSERVER))
	  {
	    if(cnp->bufsock!=NULL)
	      ConnectionClose(cnp);

	    if(np->server==NULL)
	      /* lbg[NɃT[o܂ꍇ́ARlNVΈU
		 ؒfAlbg[N̍ŏ̃T[oɐڑƂB */
	      ConnectionSetNetwork(cnp,np);

	    else
	      /* T[oȂȂꍇ́Ãlbg[N͏ł̂ŃRlNV
		 폜 */
	      ConnectionDestroy(cnp);
	  }
      }
  }
  SystemMessageF(SYSMSG_SERVER,"Server($SERVER) has reset network($NETWORK)",
		 "SERVER", ASFORMAT_STRING,sp->name,
		 "NETWORK",ASFORMAT_STRING,np->name,
		 NULL);
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                 `lf[^                 bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ============== \`l擾 ============== */
/* -------------------------------------------------- */
ALCSTR
ChannelGetName(CHANNEL *chp)
{
  return ConnectionAddDescriptor(chp->connection,chp->name);
}

/* -------------------------------------------------- */
/* ====================== 擾 ====================== */
/* -------------------------------------------------- */
CHANNEL *
ChannelGet(CONNECTION *cnp,const char *name)
{
  GETPOINTERFUNC(CHANNEL,cnp->channel,stringCmp(pointer->name,name));
}

/* -------------------------------------------------- */
/* ====================== ǉ ====================== */
/* -------------------------------------------------- */
CHANNEL *
ChannelCreate(CONNECTION *cnp,const char *name)
{
  CHANNEL *chp;
  if((chp=ChannelGet(cnp,name))!=NULL)
    return NULL;
  chp=malloc(sizeof(CHANNEL));
  plistAddItem(&Channel     ,chp);
  plistAddItem(&cnp->channel,chp);
  chp->connection=cnp;
  chp->name      =alcstrCopySet(name);
  chp->topic     =alcstrCopySet("");
  chp->chuser    =NULL;

  ALCSTR_BEGIN
    {
      SystemMessageF(SYSMSG_CHANNEL,"Channel($CHANNEL) has created.",
		     "CHANNEL",ASFORMAT_STRING,ChannelGetName(chp),
		     NULL);
      SystemMessageF(SYSMSG_CONNECTION,
		     "Connection($CONNECTION) has joind channel($CHANNEL).",
		     "CONNECTION",ASFORMAT_STRING,cnp->name,
		     "CHANNEL",   ASFORMAT_STRING,chp->name,
		     NULL);
    }
  ALCSTR_END;

  {
    KPCHANNEL *kp;
    if((kp=ConnectionGetKpchannel(cnp,name))!=NULL)
      kp->hasJoined=1;
  }
  return chp;
}

/* -------------------------------------------------- */
/* ====================== 폜 ====================== */
/* -------------------------------------------------- */
void
ChannelDestroy(CHANNEL *chp)
{
  PLISTLOOP_BEGIN(tclp,CLIENT,Client)
    {
      if(ClientIsJoinChannel(tclp,chp))
	ClientPartChannel(tclp,chp);
    }
  PLISTLOOP_END;

  PLISTLOOP_BEGIN(cup,CHUSER,chp->chuser)
    {
      USER *up;
      ChannelDeleteUser(chp,up=cup->user);
      if(up->channel==NULL && chp->connection->myself!=up)
	UserDestroy(up);
    }
  PLISTLOOP_END;

  ALCSTR_BEGIN
    {
      SystemMessageF(SYSMSG_CONNECTION,
		     "Connection($CONNECTION) has parted channel($CHANNEL).",
		     "CONNECTION",ASFORMAT_STRING,chp->connection->name,
		     "CHANNEL",   ASFORMAT_STRING,chp->name,
		     NULL);
      SystemMessageF(SYSMSG_CHANNEL,"Channel($CHANNEL) has destroied.",
		     "CHANNEL",ASFORMAT_STRING,ChannelGetName(chp),
		     NULL);
    }
  ALCSTR_END;

  {
    KPCHANNEL *kp;
    kp=ConnectionGetKpchannel(chp->connection,chp->name);
    if(kp!=NULL)
      {
	kp->hasJoined=0;
	kp->lastTry=NowTime;
      }
  }
  plistDeleteItem(&Channel,chp);
  plistDeleteItem(&chp->connection->channel,chp);

  alcstrDestroy(chp->name );
  alcstrDestroy(chp->topic);
  free(chp);
}

/* -------------------------------------------------- */
/* ===================== [U ===================== */
/* -------------------------------------------------- */
/* QQQQQQQQQQQQQQQQQQQQ */
/* ----------------- mF ----------------- */
/* PPPPPPPPPPPPPPPPPPPP */
int
ChannelHasUser(CHANNEL *chp,USER *up)
{
  return ChannelGetChuser(chp,up)!=NULL;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ----------------- 擾 ----------------- */
/* PPPPPPPPPPPPPPPPPPPP */
CHUSER *
ChannelGetChuser(CHANNEL *chp,USER *up)
{
  int i;
  CHUSER *cup;
  for(i=0;(cup=plistGetItem(chp->chuser,i))!=NULL;i++)
    {
      if(cup->user==up)
	return cup;
    }
  return NULL;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ----------------- ǉ ----------------- */
/* PPPPPPPPPPPPPPPPPPPP */
void
ChannelAddUser(CHANNEL *chp,USER *up)
{
  CHUSER *cup;
  if(chp->connection!=up->connection)
    FATALERROR;
  if(ChannelGetChuser(chp,up)!=NULL)
    FATALERROR;

  cup=malloc(sizeof(CHUSER));
  cup->user=up;
  cup->joined=NowTime;
  cup->modeo=cup->modev=0;
  plistAddItem(&up->channel,chp);
  plistAddItem(&chp->chuser,cup);
  ALCSTR_BEGIN
    SystemMessageF(SYSMSG_USER,"User($USER) has join to channel $CHANNEL",
		   "USER"   ,ASFORMAT_STRING,UserGetNick(up),
		   "CHANNEL",ASFORMAT_STRING,ChannelGetName(chp),
		   NULL);
  ALCSTR_END;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ----------------- 폜 ----------------- */
/* PPPPPPPPPPPPPPPPPPPP */
void
ChannelDeleteUser(CHANNEL *chp,USER *up)
{
  CHUSER *cup;
  if((cup=ChannelGetChuser(chp,up))==NULL)
    FATALERROR;

  ALCSTR_BEGIN
    SystemMessageF(SYSMSG_USER,"User($USER) has part to channel($CHANNEL)",
		   "USER"   ,ASFORMAT_STRING,UserGetNick(up),
		   "CHANNEL",ASFORMAT_STRING,ChannelGetName(chp),
		   NULL);
  ALCSTR_END;

  plistDeleteItem(&up->channel,chp);
  plistDeleteItem(&chp->chuser,cup);
  free(cup);

  /* [U */
  if(up->channel==NULL && up!=up->connection->myself)
    plistAddItem(&up->connection->loseSightUser,up);
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ---------------- [h ---------------- */
/* PPPPPPPPPPPPPPPPPPPP */
/* [h:+o */
void
ChannelSetOp(CHANNEL *chp,USER *up)
{
  CHUSER *cup;
  if(chp==NULL || up==NULL)
    FATALERROR;
  if((cup=ChannelGetChuser(chp,up))==NULL)
    FATALERROR;
  if(!cup->modeo) ALCSTR_BEGIN
    {
      cup->modeo=1;
      SystemMessageF(SYSMSG_USER,"User($USER) has set +o "
		     "on channel($CHANNEL)",
		     "USER"   ,ASFORMAT_STRING,UserGetNick(up),
		     "CHANNEL",ASFORMAT_STRING,ChannelGetName(chp),
		     NULL);
    }
  ALCSTR_END;
}
/* [h:+v */
void
ChannelSetV(CHANNEL *chp,USER *up)
{
  CHUSER *cup;
  if(chp==NULL || up==NULL)
    FATALERROR;
  if((cup=ChannelGetChuser(chp,up))==NULL)
    FATALERROR;
  if(!cup->modev) ALCSTR_BEGIN
    {
      cup->modev=1;
      SystemMessageF(SYSMSG_USER,"User($USER) has set +v "
		     "on channel($CHANNEL)",
		     "USER"   ,ASFORMAT_STRING,UserGetNick(up),
		     "CHANNEL",ASFORMAT_STRING,ChannelGetName(chp),
		     NULL);
    }
  ALCSTR_END;
}
/* [h:-o */
void
ChannelResetOp(CHANNEL *chp,USER *up)
{
  CHUSER *cup;
  if(chp==NULL || up==NULL)
    FATALERROR;
  if((cup=ChannelGetChuser(chp,up))==NULL)
    FATALERROR;
  if(cup->modeo) ALCSTR_BEGIN
    {
      cup->modeo=0;
      SystemMessageF(SYSMSG_USER,"User($USER) has set -o "
		     "on channel($CHANNEL)",
		     "USER"   ,ASFORMAT_STRING,UserGetNick(up),
		     "CHANNEL",ASFORMAT_STRING,ChannelGetName(chp),
		   NULL);
    }
  ALCSTR_END;
}
/* [h:-v */
void
ChannelResetV(CHANNEL *chp,USER *up)
{
  CHUSER *cup;
  if(chp==NULL || up==NULL)
    FATALERROR;
  if((cup=ChannelGetChuser(chp,up))==NULL)
    FATALERROR;

  if(cup->modev) ALCSTR_BEGIN
    {
      cup->modev=0;
      SystemMessageF(SYSMSG_USER,"User($USER) has set -v "
		     "on channel($CHANNEL)",
		     "USER"   ,ASFORMAT_STRING,UserGetNick(up),
		     "CHANNEL",ASFORMAT_STRING,ChannelGetName(chp),
		     NULL);
    }
  ALCSTR_END;
}
/* [h`FbN:o */
int
ChannelCheckOp(CHANNEL *chp,USER *up)
{
  CHUSER *cup;
  if(chp==NULL || up==NULL)
    FATALERROR;
  if((cup=ChannelGetChuser(chp,up))==NULL)
    FATALERROR;

  return cup->modeo;
}
/* [h`FbN:v */
int
ChannelCheckV(CHANNEL *chp,USER *up)
{
  CHUSER *cup;
  if(chp==NULL || up==NULL)
    FATALERROR;
  if((cup=ChannelGetChuser(chp,up))==NULL)
    FATALERROR;

  return cup->modev;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                   [Uf[^                   bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ====================== 擾 ====================== */
/* -------------------------------------------------- */
USER *
UserGet(CONNECTION *cnp,const char *nick)
{
  GETPOINTERFUNC(USER,cnp->user,stringCmp(pointer->nick,nick));
}

/* -------------------------------------------------- */
/* ====================== ǉ ====================== */
/* -------------------------------------------------- */
USER *
UserCreate(CONNECTION *cnp,const char *nick)
{
  USER *up;
  if((up=UserGet(cnp,nick))!=NULL)
    return NULL;

  up=malloc(sizeof(USER));
  plistAddItem(&User     ,up);
  plistAddItem(&cnp->user,up);
  up->connection=cnp;
  up->nick=alcstrCopySet(nick);
  up->channel=NULL;

  ALCSTR_BEGIN
    SystemMessageF(SYSMSG_USER,
		   "User($USER) has created.",
		   "USER",ASFORMAT_STRING,UserGetNick(up),
		   NULL);
  ALCSTR_END;

  return up;
}

/* -------------------------------------------------- */
/* ====================== 폜 ====================== */
/* -------------------------------------------------- */
void
UserDestroy(USER *up)
{
  CHANNEL *chp;
  while((chp=plistGetItem(up->channel,0))!=NULL)
    ChannelDeleteUser(chp,up);

  ALCSTR_BEGIN
    SystemMessageF(SYSMSG_USER,
		   "User($USER) has destroied.",
		   "USER",ASFORMAT_STRING,UserGetNick(up),
		   NULL);
  ALCSTR_END;

  plistDeleteItem(&User,up);
  plistDeleteItem(&up->connection->user,up);
  plistDeleteItem(&up->connection->loseSightUser,up);
  alcstrDestroy(up->nick);

  free(up);
}

/* -------------------------------------------------- */
/* ================= \jbN擾 ================= */
/* -------------------------------------------------- */
ALCSTR
UserGetNick(USER *up)
{
  return ConnectionAddDescriptor(up->connection,up->nick);
}

/* -------------------------------------------------- */
/* =================== jbNύX =================== */
/* -------------------------------------------------- */
void
UserNick(USER *up,const char *newNick)
{
  if(up==up->connection->myself)
    SystemMessageF(SYSMSG_CONNECTION,
		   "Connection($CONNECTION) has changed nick $NEWNICK",
		   "CONNECTION",ASFORMAT_STRING,up->connection->name,
		   "NEWNICK",   ASFORMAT_STRING,newNick,
		   NULL);

  alcstrUpdate(&up->nick,newNick);
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                RlNVf[^                bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ====================== 擾 ====================== */
/* -------------------------------------------------- */

/* O */
CONNECTION *
ConnectionGet(const char *name)
{
  GETPOINTERFUNC(CONNECTION,Connection,stringCmp(pointer->name,name));
}

/* \Pbg */
CONNECTION *
ConnectionGetByBufsock(BUFSOCK bufsock)
{
  GETPOINTERFUNC(CONNECTION,Connection,pointer->bufsock==bufsock);
}

/* T[o */
CONNECTION *
ConnectionGetByServer(SERVER *sp)
{
  GETPOINTERFUNC(CONNECTION,Connection,pointer->server==sp);
}

/* lbg[N */
CONNECTION *
ConnectionGetByNetwork(NETWORK *np)
{
  GETPOINTERFUNC(CONNECTION,Connection,
		 pointer->server->network==np && np!=NULL);
}

/* O */
CONNECTION dummyConnection;
CONNECTION *
ConnectionGetByName(ALCSTR *realname,
		    const char *name,
		    CONNECTION *defaultConnection)
{
  CONNECTION *cnp;
  int namelen,i;
  namelen=strlen(name);

  /* RlNVwqEo */
  for(i=namelen-1;i>=0;i--)
    {
      if(name[i] <0x20     )
	{
	  i=-1;
	  break;
	}
      if(name[i]==NameSplit)
	break;
    }
  /* w肪Ȃ */
  if(i==-1)
    {
      *realname=alcstrCopy(name);
      return defaultConnection;
    }
  /* wqRlNV𔻕 */
  *realname=alcstrMiddle(name,0,i);
  ALCSTR_BEGIN
    {
      ALCSTR connectionName;
      int j;

      /* wq̏I[Eo(:*.jp͎wq̌) */
      for(j=i;name[j]!=':' && name[j]!='\0';j++);
      connectionName=alcstrMiddle(name,i+1,j-i-1);
      if(name[j]==':')
	realcstrConcatenate(realname,alcstrMiddle(name,j,-1));

      /* ̐ڑ̐ڑT */
      if((cnp=ConnectionGet(connectionName))==NULL)
	{
	  /* ̃T[oւ̐ڑT */
	  if((cnp=ConnectionGetByServer(ServerGet(connectionName)))==NULL)
	    {
	      /* ̃lbg[Nւ̐ڑT */
	      cnp=ConnectionGetByNetwork(NetworkGet(connectionName));
	    }
	}
    }
  ALCSTR_END;

  return cnp;
}

/* -------------------------------------------------- */
/* ============= RlNVLqqt ============= */
/* -------------------------------------------------- */
ALCSTR
ConnectionAddDescriptor(CONNECTION *cnp,const char *realname)
{
  int namelen,maskpos;
  ALCSTR asp;
  namelen=strlen(realname);

  /* ̃jbNȂ΂̂܂ */
  if(cnp->myself!=NULL)
    {
      if(stringCmp(realname,cnp->myself->nick))
	return alcstrCopy(Nickname);
    }

  /* `l}XN()擾 */
  {
    int i;
    for(i=namelen-1;i>0;i--)
      {
	if(realname[i]==0x1B || realname[i]==':')
	  break;
      }
    maskpos = (realname[i]==':')? i: -1;
  }

  /* ɃRlNVLqq(͌ĂƔFĂ܂m)Ȃ`
     FbNBꍇ̓CRlNVłLqqt */
  if(cnp==MainConnection)
    {
      int i;
      for(i=(maskpos>=0)?maskpos-1:namelen-1 ;i>=0;i--)
	{
	  if(realname[i]==NameSplit)
	    break;
	  /* P */
	  if(i>2 && realname[i-2]==0x1B)
	      break;
	}
      if(i<0 || realname[i]!=NameSplit)
	return alcstrCopy(realname);
    }

  /* ڑt */
  if(maskpos<0)
    asp=alcstrFormat("$NAME$SPLIT$CONNECTION",
		     "NAME",      ASFORMAT_STRING,realname,
		     "SPLIT",     ASFORMAT_CHAR  ,NameSplit,
		     "CONNECTION",ASFORMAT_STRING,cnp->name,
		     NULL);
  else
    {
      ALCSTR fname;
      fname=alcstrMiddle(realname,0,maskpos);
      asp=alcstrFormat("$NAME$SPLIT$CONNECTION$MASK",
		       "NAME",      ASFORMAT_STRING,fname,
		       "SPLIT",     ASFORMAT_CHAR  ,NameSplit,
		       "CONNECTION",ASFORMAT_STRING,cnp->name,
		       "MASK"      ,ASFORMAT_STRING,realname+maskpos,
		       NULL);
      alcstrDestroy(fname);
    }

  return asp;
}

/* -------------------------------------------------- */
/* ====================== ǉ ====================== */
/* -------------------------------------------------- */
CONNECTION *
ConnectionCreate(const char *name)
{
  CONNECTION *cnp;
  if(ConnectionGet(name)!=NULL)
    ERRORRETURN(AERROR_NAME_EXIST);
  if((cnp=malloc(sizeof(CONNECTION)))==NULL)
    ERRORRETURN(AERROR_CANT_ALLOC);

  if(plistAddItem(&Connection,cnp)==NULL)
    {
      free(cnp);
      ERRORRETURN(AERROR_CANT_ALLOC);
    }

  cnp->bufsock=NULL;
  cnp->name   =alcstrCopySet(name);
  cnp->server =NULL;
  cnp->flags  =DefaultConnectionFlags;
  cnp->stat   =CNSTAT_NONE;
  cnp->statarg=NULL;
  cnp->channel      =NULL;
  cnp->myself       =NULL;
  cnp->user         =NULL;
  cnp->kpchannel    =NULL;
  cnp->loseSightUser=NULL;
  cnp->update       =0;

  SystemMessageF(SYSMSG_CONNECTION,"Connection($CONNECTION) has created",
		 "CONNECTION",ASFORMAT_STRING,cnp->name,
		 NULL);

  if(MainConnection==NULL)
    {
      MainConnection=cnp;
      SystemMessageF(SYSMSG_CONNECTION,
		     "Connection($CONNECTION) has set as Main-Connection",
		     "CONNECTION",ASFORMAT_STRING,cnp->name,
		     NULL);
    }

  return cnp;
}

/* -------------------------------------------------- */
/* ====================== 폜 ====================== */
/* -------------------------------------------------- */
void
ConnectionDestroy(CONNECTION *cnp)
{
  if(cnp->bufsock!=NULL)
    ConnectionClose(cnp);

  SystemMessageF(SYSMSG_CONNECTION,"Connection($CONNECTION) has destroied",
		 "CONNECTION",ASFORMAT_STRING,cnp->name,
		 NULL);

  if(MainConnection==cnp)
    MainConnection=NULL;
  ConnectionClearKpchannel(cnp);
  bufsockDestroy(cnp->bufsock);
  plistDeleteItem(&Connection,cnp);
  alcstrDestroy(cnp->name);
  free(cnp);
}

/* -------------------------------------------------- */
/* ================= ێ`l ================= */
/* -------------------------------------------------- */
/* 擾 */
KPCHANNEL *
ConnectionGetKpchannel(CONNECTION *cnp,ALCSTR cname)
{
  GETPOINTERFUNC(KPCHANNEL,cnp->kpchannel,stringCmp(pointer->name,cname));
}
/* ǉ */
KPCHANNEL *
ConnectionAddKpchannel(CONNECTION *cnp,ALCSTR cname)
{
  KPCHANNEL *kp;
  kp=malloc(sizeof(KPCHANNEL));
  kp->name     =alcstrCopySet(cname);
  kp->lastTry  =0;
  kp->hasJoined=(ChannelGet(cnp,cname)!=NULL);
  plistAddItem(&cnp->kpchannel,kp);
  return kp;
}
/* NA */
int
ConnectionClearKpchannel(CONNECTION *cnp)
{
  int count=0;
  KPCHANNEL *kp;
  while((kp=plistGetItem(cnp->kpchannel,0))!=NULL)
    {
      plistDeleteItem(&cnp->kpchannel,cnp);
      alcstrDestroy(kp->name);
      free(kp);
      count++;
    }

  return count;
}

/* -------------------------------------------------- */
/* =================== T[ow =================== */
/* -------------------------------------------------- */
/* T[ow */
void
ConnectionChangeServer(CONNECTION *cnp,SERVER *sp)
{
  if(cnp->server!=NULL)
    {
      if(cnp->bufsock!=NULL)
	FATALERROR;
    }
  cnp->server=sp;
}

/* lbg[N̍ŏ̃T[o */
void
ConnectionChangeServerNetworkFirst(CONNECTION *cnp)
{
  NETWORK *np;
  SERVER *sp;
  np=cnp->server->network;
  if(np==NULL)
    FATALERROR;
  sp=plistGetItem(np->server,0);
  if(sp==NULL)
    FATALERROR;

  ConnectionChangeServer(cnp,sp);
}
/* lbg[N̎̃T[o */
void
ConnectionChangeServerNetworkNext(CONNECTION *cnp)
{
  int i;
  NETWORK *np;
  SERVER *sp;
  if((np=cnp->server->network)==NULL)
    FATALERROR;

  /* ԍ擾 */
  i=plistGetIndex(np->server,cnp->server);
  /* ̃T[oݒ */
  sp=plistGetItem(np->server,i+1);
  if(sp!=NULL)
    ConnectionChangeServer(cnp,sp);
  /* ΍ŏ̃T[o */
  else
    ConnectionChangeServerNetworkFirst(cnp);
}

/* T[ow */
void
ConnectionSetServer(CONNECTION *cnp,SERVER *sp)
{
  if(sp!=cnp->server)
    {
      if(cnp->bufsock!=NULL)
	ConnectionClose(cnp);
      ConnectionChangeServer(cnp,sp);
    }
  cnp->flags|=CNFLAG_SPECIFYSERVER;
  /* VXebZ[W */
  SystemMessageF(SYSMSG_CONNECTION,
		 "Connection($CONNECTION) has set server($SERVER)",
		 "CONNECTION",ASFORMAT_STRING,cnp->name,
		 "SERVER"    ,ASFORMAT_STRING,sp->name,
		 NULL);
}
/* lbg[Nw */
void
ConnectionSetNetwork(CONNECTION *cnp,NETWORK *np)
{
  SERVER *sp;
  sp=plistGetItem(np->server,0);
  if(sp==NULL) FATALERROR;
  /* ڑĂꍇAlbg[NςꍇڑؒfB */
  if(cnp->server!=NULL)
    {
      if(cnp->bufsock!=NULL && cnp->server->network!=np)
	ConnectionClose(cnp);
    }
  /* ڑT[o̕ύX */
  do
    {
      if(cnp->server!=NULL)
	{
	  if(cnp->server->network==np)
	    break;
	}
      ConnectionChangeServer(cnp,sp);
    }
  while(0);
  cnp->flags&=~CNFLAG_SPECIFYSERVER;

  /* VXebZ[W */
  SystemMessageF(SYSMSG_CONNECTION,
		 "Connection($CONNECTION) has set network($SERVER)",
		 "CONNECTION",ASFORMAT_STRING,cnp->name,
		 "SERVER"    ,ASFORMAT_STRING,np->name,
		 NULL);
}

/* -------------------------------------------------- */
/* ====================== M ====================== */
/* -------------------------------------------------- */
int
ConnectionSendMessage(CONNECTION *cnp,const char *msg)
{
  /* ڑĂȂRlNVȂG[ */
  if(cnp->bufsock==NULL)
    return AERROR_NOT_CONNECTED;

  ALCSTR_BEGIN
    {
      ALCSTR line;
      CPLIST *lines;

      /* sĂΏ */
      line=alcstrDeleteCRLF(msg);

      /* vOC̃tB^O */
      lines=PluginFilterFunction( cnp->name, line,
				  PLUGIN_FUNCPOS(clientWriteFilter) );

      while( (line=cplistGetItem(lines,0)) )
	{
	  /* fobOo */
	  SystemMessageF(SYSMSG_WRITE_SERVER,
			 "write($CONNECTION) $MESSAGE",
			 "CONNECTION",ASFORMAT_STRING,cnp->name,
			 "MESSAGE"   ,ASFORMAT_STRING,line,
			 NULL);
	  /* vOC̃bZ[W֐ */
	  PluginCallFunction( cnp->name, line,
			      PLUGIN_FUNCPOS(connectionWrite) );
	  /* M */
	  bufsockWriteString( cnp->bufsock,
			      alcstrConcatenate(line,"\r\n") );

	  /* ύs̍폜 */
	  cplistDeleteItem( &lines, line );
	  alcstrDestroy( line );
	}
    }
  ALCSTR_END;

  return AERROR_NONE;
}

int
ConnectionSendMessageF(CONNECTION *cnp,const char *fmt,...)
{
  int ret;
  va_list argp;

  va_start(argp,fmt);
  ALCSTR_BEGIN
    {
      ret=ConnectionSendMessage(cnp,alcstrFormatV(fmt,argp));
    }
  ALCSTR_END;
  va_end(argp);
  return ret;
}

/* -------------------------------------------------- */
/* =====================  ===================== */
/* -------------------------------------------------- */
int
ConnectionClose(CONNECTION *cnp)
{
  /* vOC̃bZ[W֐ */
  PluginCallFunction( cnp->name, NULL,
		      PLUGIN_FUNCPOS(connectionClose) );

  /* ڑĂȂ1Ԃ */
  if(cnp->bufsock==NULL)
    return AERROR_NOT_CONNECTED;

  /* [U̍폜 */
  cnp->myself=NULL;
  plistClearItem(&cnp->loseSightUser);
  PLISTLOOP_BEGIN(up,USER,cnp->user)
    while((up=plistGetItem(cnp->user,0))!=NULL) UserDestroy(up);
  PLISTLOOP_END;

  /* `l̍폜 */
  PLISTLOOP_BEGIN(chp,CHANNEL,cnp->channel)
    {
      /* NCAgPART x*/
      PLISTCLIENTLOOP_BEGIN(clp)
	{
	  if(!ClientIsJoinChannel(clp,chp))
	    continue;
	  CmdOff(clp,chp);
	  JoinreqCreateByConnection(clp,cnp,chp->name);
	}
      PLISTLOOP_END;
      /* `lf[^̍폜 */
      ChannelDestroy(chp);
    }
  PLISTLOOP_END;

  /* Xe[^X̏ */
  if(cnp->stat==CNSTAT_NAMES)
    {
      while(cnp->statarg!=NULL)
	{
	  ALCSTR tmp;
	  tmp=cplistGetItem(cnp->statarg,0);
	  cplistDeleteItem(&cnp->statarg,tmp);
	  alcstrDestroy(tmp);
	}
    }
  cnp->stat=CNSTAT_NONE;

  /* T[oƂ̊֌W폜 */
  plistDeleteItem(&cnp->server->connection,cnp);

  /* \Pbg */
  SystemMessageF(SYSMSG_CONNECTION,
		 "Connection($CONNECTION) has closed",
		 "CONNECTION",ASFORMAT_STRING,cnp->name,
		 NULL);
  bufsockDestroy(cnp->bufsock);
  cnp->bufsock=NULL;

  /* T[oŒݒłȂΎ̃T[o */
  if(!(cnp->flags&CNFLAG_SPECIFYSERVER) && cnp->server->network!=NULL)
    {
      /* ڑɐĂꍇȂlbg[N̍ŏ̃T[o */
      if(cnp->flags&CNFLAG_REGISTERED)
	ConnectionChangeServerNetworkFirst(cnp);
      /* ڑłȂĎɂꍇ */
      else
	ConnectionChangeServerNetworkNext(cnp);
    }
  cnp->flags&=~CNFLAG_REGISTERED;
  return AERROR_NONE;
}

/* -------------------------------------------------- */
/* ====================== J ====================== */
/* -------------------------------------------------- */
int
ConnectionOpen(CONNECTION *cnp)
{
  /* ڑ */
  cnp->bufsock=bufsockCreateConnect(cnp->server->address,
				    cnp->server->port    );
  cnp->update=NowTime;
  /* ڑs */
  if(cnp->bufsock==NULL)
    {
      SystemMessageF(SYSMSG_CONNECTION,
		     "Connection($CONNECTION) "
		     "couldn't connect to server($SERVER)",
		     "CONNECTION",ASFORMAT_STRING,cnp->name,
		     "SERVER"    ,ASFORMAT_STRING,cnp->server->name,
		     NULL);
      ConnectionClose(cnp);
      if(!(cnp->flags&CNFLAG_SPECIFYSERVER))
	ConnectionChangeServerNetworkNext(cnp);
      return AERROR_COULDNT_CONNECTED;
    }

  /* T[o֓o^ */
  plistAddItem(&cnp->server->connection,cnp);

  /* bZ[W */
  SystemMessageF(SYSMSG_CONNECTION,
		 "Connection($CONNECTION) has connected to server($SERVER)",
		 "CONNECTION",ASFORMAT_STRING,cnp->name,
		 "SERVER"    ,ASFORMAT_STRING,cnp->server->name,
		 NULL);

  /* FؗpbZ[WM */
  if(cnp->server->password!=NULL)
    ConnectionSendMessageF(cnp,"PASS $PASSWORD",
			   "PASSWORD",ASFORMAT_STRING,cnp->server->password,
			   NULL);

  ConnectionSendMessageF(cnp,"NICK $NICKNAME",
			 "NICKNAME",ASFORMAT_STRING,cplistGetItem(StartNick,0),
			 NULL);
  ConnectionSendMessageF(cnp,"USER $USERNAME * * :$REALNAME",
			 "USERNAME",ASFORMAT_STRING,Username,
			 "REALNAME",ASFORMAT_STRING,Realname,
			 NULL);

  cnp->myself=UserCreate(cnp,cplistGetItem(StartNick,0));

  return AERROR_NONE;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                NCAgf[^                bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ====================== 擾 ====================== */
/* -------------------------------------------------- */
CLIENT *
ClientGet(const char *name)
{
  int i;
  CLIENT *clp;
  for(i=0;(clp=plistGetItem(Client,i))!=NULL;i++)
    {
      if(clp->name!=NULL)
	{
	  if(stringCmp(clp->name,name))
	    return clp;
	}
    }
  return NULL;
}

/* -------------------------------------------------- */
/* ====================== ǉ ====================== */
/* -------------------------------------------------- */
CLIENT *
ClientCreate(BUFSOCK bufsock)
{
  CLIENT *clp;
  if(bufsock==NULL)
    return NULL;
  clp=malloc(sizeof(CLIENT));
  plistAddItem(&Client,clp);
  clp->bufsock    =bufsock;
  clp->update     =NowTime;
  clp->name       =NULL;
  clp->sysmsgMask =0x00FF;
  clp->check      =(Password==NULL)?CLIENT_CHECK_PASS:CLIENT_CHECK_NONE;
  clp->flags      =DefaultClientFlags;
  clp->channel    =NULL;
  clp->joinRequest=NULL;
  return clp;
}

/* -------------------------------------------------- */
/* ====================== 폜 ====================== */
/* -------------------------------------------------- */
void
ClientDestroy(CLIENT *clp)
{
  /* vOC̃bZ[W֐ */
  PluginCallFunction( clp->name, NULL,
		      PLUGIN_FUNCPOS(clientClose) );

  ALCSTR_BEGIN
    {
      ALCSTR name;
      clp->sysmsgMask=0;
      name=(clp->name==NULL)?
	alcstrFormat("$ADDRESS:$PORT",
		     "ADDRESS",ASFORMAT_STRING,bufsockGetAddress(clp->bufsock),
		     "PORT"   ,ASFORMAT_INT   ,bufsockGetPort   (clp->bufsock),
		     NULL):
	clp->name;
      SystemMessageF(SYSMSG_CLIENT,"Client($CLIENT) has closed",
		     "CLIENT",ASFORMAT_STRING,name,
		     NULL);
    }
  ALCSTR_END;

  plistDeleteItem(&Client,clp);
  plistClearItem(&clp->channel);
  while(clp->joinRequest!=NULL)
    JoinreqDestroy(plistGetItem(clp->joinRequest,0));
  bufsockDestroy(clp->bufsock);
  if(clp->name!=NULL)
    alcstrDestroy(clp->name);

  free(clp);
}


/* -------------------------------------------------- */
/* =================== `l =================== */
/* -------------------------------------------------- */
/* QQQQQQQQQQQQQQQQQQQQ */
/* -----------------  ----------------- */
/* PPPPPPPPPPPPPPPPPPPP */
int
ClientIsJoinChannel(CLIENT *clp,CHANNEL *chp)
{
  return (plistGetIndex(clp->channel,chp)>=0);
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ----------------- ǉ ----------------- */
/* PPPPPPPPPPPPPPPPPPPP */
int
ClientJoinChannel(CLIENT *clp,CHANNEL *chp)
{
  if(ClientIsJoinChannel(clp,chp))
    return AERROR_ALREADYJOIN_CHANNEL;
  plistAddItem(&clp->channel,chp);
  return 0;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ----------------- 폜 ----------------- */
/* PPPPPPPPPPPPPPPPPPPP */
int
ClientPartChannel(CLIENT *clp,CHANNEL *chp)
{
  if(!ClientIsJoinChannel(clp,chp))
    return AERROR_NOTJOIN_CHANNEL;

  plistDeleteItem(&clp->channel,chp);
  return 0;
}

/* -------------------------------------------------- */
/* ====================== M ====================== */
/* -------------------------------------------------- */
int
ClientSendMessage(CLIENT *clp,const char *msg)
{
  ALCSTR_BEGIN
    {
      ALCSTR line;
      CPLIST *lines;

      /* sĂΏ */
      line=alcstrDeleteCRLF(msg);

      /* vOC̃tB^O */
      if( clp->name )
	lines=PluginFilterFunction( clp->name, line,
				    PLUGIN_FUNCPOS(clientWriteFilter) );
      /* NCAĝĂȂm̓tB^OΏۊO */
      else
	{
	  lines=NULL;
	  cplistAddItem( &lines, alcstrCopySet(line) );
	}

      while( (line=cplistGetItem(lines,0)) )
	{
	  /* fobOo */
	  ALCSTR target;
	  target = ( (clp->name) ? alcstrCopy(clp->name)
		     : alcstrFormat("$ADDRESS:$PORT",
				    "ADDRESS",ASFORMAT_STRING,
				    bufsockGetAddress(clp->bufsock),
				    "PORT",ASFORMAT_INT,
				    bufsockGetPort(clp->bufsock),
				    NULL) );
	  SystemMessageF(SYSMSG_WRITE_CLIENT,
			 "write($CLIENT) $LINE",
			 "CLIENT", ASFORMAT_STRING, target,
			 "LINE",   ASFORMAT_STRING, line,
			 NULL );
	  /* vOC̃bZ[W֐ */
	  if( clp->name )
	    PluginCallFunction( clp->name, line,
				PLUGIN_FUNCPOS(clientWrite) );
	  /* M */
	  bufsockWriteString( clp->bufsock,
			      alcstrConcatenate( line, "\r\n" ) );
	  /* ύs̍폜 */
	  cplistDeleteItem( &lines, line );
	  alcstrDestroy( line );
	}
    }
  ALCSTR_END;

  return AERROR_NONE;
}

int
ClientSendMessageF(CLIENT *clp,const char *fmt,...)
{
  va_list argp;

  va_start(argp,fmt);
  ALCSTR_BEGIN
    ClientSendMessage(clp,alcstrFormatV(fmt,argp));
  ALCSTR_END;
  va_end(argp);
  return AERROR_NONE;
}

/* -------------------------------------------------- */
/* =================== bZ[W =================== */
/* -------------------------------------------------- */
int
ClientSendNotice(CLIENT *clp,const char *notice)
{
  ClientSendMessageF(clp,"NOTICE $TARGET :$MESSAGE",
		     "TARGET", ASFORMAT_STRING,Nickname,
		     "MESSAGE",ASFORMAT_STRING,notice,
		     NULL);
  return AERROR_NONE;
}

int
ClientSendNoticeF(CLIENT *clp,const char *fmt,...)
{
  va_list argp;

  va_start(argp,fmt);
  ALCSTR_BEGIN
    ClientSendNotice(clp,alcstrFormatV(fmt,argp));
  ALCSTR_END;
  va_end(argp);
  return AERROR_NONE;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                  JOINNGXg                  bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ======================  ====================== */
/* -------------------------------------------------- */
/* QQQQQQQQQQQQQQQQQQQQ */
/* -----------------  ----------------- */
/* PPPPPPPPPPPPPPPPPPPP */
JOINREQ *
JoinreqGetByConnection(CLIENT *clp, CONNECTION *cnp, const char *cname)
{
  JOINREQ *rp=NULL;
  PLISTLOOP_BEGIN(lrp,JOINREQ,clp->joinRequest)
    {
      rp=lrp;
      if(!stringCmp(rp->channelName,cname)) continue;
      if(rp->network!=NULL)
	{
	  if(rp->network==cnp->server->network)
	    break;
	}
      else
	{
	  if(rp-> server==cnp->server)
	    break;
	}
    }
  PLISTLOOP_END;

  return rp;
}

/* -------------------------------------------------- */
/* ====================== ǉ ====================== */
/* -------------------------------------------------- */
/* QQQQQQQQQQQQQQQQQQQQ */
/* ----------------- 쐬 ----------------- */
/* PPPPPPPPPPPPPPPPPPPP */
JOINREQ *
JoinreqCreate(CLIENT *clp,const char *cname)
{
  JOINREQ *rp;
  rp=malloc(sizeof(JOINREQ));
  rp->client     =clp;
  rp->channelName=alcstrCopySet(cname);
  rp->time       =NowTime;
  rp->server     =NULL;
  rp->network    =NULL;
  plistAddItem(&clp->joinRequest,rp);

  return rp;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* -------------- T[ow -------------- */
/* PPPPPPPPPPPPPPPPPPPP */
JOINREQ *
JoinreqCreateByServer(CLIENT *clp,SERVER *sp,const char *cname)
{
  JOINREQ *rp;
  if(sp==NULL) FATALERROR;
  rp=JoinreqCreate(clp,cname);
  rp->server=sp;
  plistAddItem(&sp->joinRequest,rp);
  return rp;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ----------- lbg[Nw ----------- */
/* PPPPPPPPPPPPPPPPPPPP */
JOINREQ *
JoinreqCreateByNetwork(CLIENT *clp,NETWORK *np,const char *cname)
{
  JOINREQ *rp;
  if(np==NULL)
    FATALERROR;
  rp=JoinreqCreate(clp,cname);
  rp->network=np;
  plistAddItem(&np->joinRequest,rp);
  return rp;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ----------- RlNVw ----------- */
/* PPPPPPPPPPPPPPPPPPPP */
JOINREQ *
JoinreqCreateByConnection(CLIENT *clp, CONNECTION *cnp, const char *cname)
{
  JOINREQ *rp;

  /* T[ow肷ꍇ */
  if(cnp->flags&CNFLAG_SPECIFYSERVER)
    rp=JoinreqCreateByServer(clp,cnp->server,cname);
  /* lbg[Nw肷ꍇ */
  else
    rp=JoinreqCreateByNetwork(clp,cnp->server->network,cname);

  return rp;
}

/* -------------------------------------------------- */
/* ====================== 폜 ====================== */
/* -------------------------------------------------- */
int
JoinreqDestroy(JOINREQ *rp)
{
  plistDeleteItem(&rp->client->joinRequest,rp);
  if(rp->server!=NULL)
    plistDeleteItem(&rp->server->joinRequest,rp);
  else
    plistDeleteItem(&rp->network->joinRequest,rp);

  alcstrDestroy(rp->channelName);
  free(rp);
  return AERROR_NONE;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb               vOCW[               bb */
/* bb                                                  bb */
/*  */
/*  */

#include "ui.h"

/* -------------------------------------------------- */
/* ====================== 擾 ====================== */
/* -------------------------------------------------- */
PLUGIN *
PluginGet(const char *name)
{
  GETPOINTERFUNC(PLUGIN,Plugin,stringCmp(pointer->name,name));
}

/* -------------------------------------------------- */
/* ======================  ====================== */
/* -------------------------------------------------- */
PLUGIN *
PluginCreate(const char *name)
{
  PLUGIN *pp;

  plistAddItem(&Plugin,pp=malloc(sizeof(PLUGIN)));

  pp->name       =alcstrCopySet(name);
  pp->library    =NULL;
  pp->libHandle  =NULL;
  pp->pluginCtrl =NULL;
  pp->initilize  =NULL;
  pp->timer      =NULL;
  pp->command    =NULL;
  pp->connectionRead        = NULL;
  pp->connectionWrite       = NULL;
  pp->connectionReadFilter  = NULL;
  pp->connectionWriteFilter = NULL;
  pp->clientRead        = NULL;
  pp->clientWrite       = NULL;
  pp->clientReadFilter  = NULL;
  pp->clientWriteFilter = NULL;

  SystemMessageF(SYSMSG_SYSTEM,"Plugin($PLUGIN) has created",
		 "PLUGIN",ASFORMAT_STRING,pp->name,
		 NULL);
  return pp;
}

/* -------------------------------------------------- */
/* ====================== j ====================== */
/* -------------------------------------------------- */
void
PluginDestroy(PLUGIN *pp)
{
  if(pp->libHandle!=NULL)
    PluginCloseLibrary(pp->libHandle);

  SystemMessageF(SYSMSG_SYSTEM,"Plugin($PLUGIN) has destroied",
		 "PLUGIN",ASFORMAT_STRING,pp->name,
		 NULL);

  plistDeleteItem(&Plugin,pp);
  if(pp->pluginCtrl!=NULL)
    free(pp->pluginCtrl);
  alcstrDestroy(pp->name);
  free(pp);
}

/* -------------------------------------------------- */
/* ================ CuJ ================ */
/* -------------------------------------------------- */
int
PluginOpenLibrary(PLUGIN *pp,const char *library)
{
  /* ɊJĂꍇ */
  if(pp->libHandle!=NULL)
    {
      /* OȂ炻̂܂ */
      if(strcmp(library,pp->library)==0)
	return 1;
      /* ႤOȂ */
      PluginCloseLibrary(pp);
    }

  /* CũI[v */
  pp->libHandle=UILibraryOpen(library);
  if(pp->libHandle==NULL)
    return 0;
  pp->library=alcstrCopySet(library);

  /* e֐̎擾 */
  pp->initilize = UILibraryGetSymbol( pp->libHandle, "PluginInitilize" );
  pp->timer     = UILibraryGetSymbol( pp->libHandle, "PluginTimer"     );
  pp->command   = UILibraryGetSymbol( pp->libHandle, "PluginCommand"   );

  pp->connectionClose      =UILibraryGetSymbol(pp->libHandle,
					       "PluginConnectionClose"      );
  pp->connectionRead       =UILibraryGetSymbol(pp->libHandle,
					       "PluginConnectionRead"       );
  pp->connectionWrite      =UILibraryGetSymbol(pp->libHandle,
					       "PluginConnectionWrite"      );
  pp->connectionReadFilter =UILibraryGetSymbol(pp->libHandle,
					       "PluginConnectionReadFilter" );
  pp->connectionWriteFilter=UILibraryGetSymbol(pp->libHandle,
					       "PluginConnectionWriteFilter");

  pp->clientClose      =UILibraryGetSymbol(pp->libHandle,
					   "PluginClientClose"      );
  pp->clientRead       =UILibraryGetSymbol(pp->libHandle,
					   "PluginClientRead"       );
  pp->clientWrite      =UILibraryGetSymbol(pp->libHandle,
					   "PluginClientWrite"      );
  pp->clientReadFilter =UILibraryGetSymbol(pp->libHandle,
					   "PluginClientReadFilter" );
  pp->clientWriteFilter=UILibraryGetSymbol(pp->libHandle,
					   "PluginClientWriteFilter");

  /* bZ[W */
  SystemMessageF(SYSMSG_SYSTEM,"Plugin($PLUGIN) has loaded library($LIBRARY)",
		 "PLUGIN" ,ASFORMAT_STRING,pp->name,
		 "LIBRARY",ASFORMAT_STRING,pp->library,
		 NULL);

  if(pp->pluginCtrl!=NULL)
    free(pp->pluginCtrl);

  /* ֐Ȃ΋p */
  if(pp->initilize==NULL)
    {
      SystemMessageF(SYSMSG_SYSTEM,"Plugin($PLUGIN) doesn't have initilizer",
		     "PLUGIN",ASFORMAT_STRING,pp->name,
		     NULL);
      return 0;
    }

  pp->pluginCtrl=malloc(sizeof(PluginCtrl));
  PluginSetCtrlFunc(pp->pluginCtrl);
  {
    CPLIST *msgs;
    PluginSetProcessing(pp,1);
    pp->initilize(pp->pluginCtrl);
    msgs=PluginResetProcessing();
    /* ̃bZ[W */
    while(msgs!=NULL)
      {
	ALCSTR msg;
	msg=cplistGetItem(msgs,0);
	SystemMessage(SYSMSG_SYSTEM,msg);
	cplistDeleteItem(&msgs,msg);
      }
  }
  return 1;
}

/* -------------------------------------------------- */
/* =============== Cu =============== */
/* -------------------------------------------------- */
void
PluginCloseLibrary(PLUGIN *pp)
{
  if(pp->libHandle!=NULL)
    return;

  UILibraryClose(pp->libHandle);
  SystemMessageF(SYSMSG_SYSTEM,"Plugin($PLUGIN) has closed library($LIBRARY)"
		 "PLUGIN" ,ASFORMAT_STRING,pp->name,
		 "LIBRARY",ASFORMAT_STRING,pp->library,
		 NULL);

  alcstrDestroy(pp->library);
  pp->library  =NULL;
  pp->libHandle=NULL;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                   ݒt@C                   bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* =========== ݒt@C̓eǂݍ =========== */
/* -------------------------------------------------- */
CPLIST *
RCFileRead()
{
  CPLIST *lines=NULL;
  FILE *fp;

  fp=fopen(RCFilename,"rt");
  if(fp==NULL)
    return NULL;
  /* t@Cǂݍ */
  for(;;)
    {
      ALCSTR line=NULL;
      /* s擾 */
      {
	char tmp[256];
	while(fgets(tmp,256,fp)!=NULL)
	  {
	    int i;
	    if(line==NULL)
	      line=alcstrCopy(tmp);
	    else
	      realcstrConcatenate(&line,tmp);
	    for(i=0;!ISLINEEND(tmp[i]);i++);
	    if(tmp[i]!='\0')
	      break;
	  }
      }
      if(line==NULL)
	break;
      cplistAddItem(&lines,alcstrSet(line));
    }
  return lines;
}

/* -------------------------------------------------- */
/* ============= ݒt@C̏ ============= */
/* -------------------------------------------------- */
int
RCFileWrite(CPLIST *lines)
{
  FILE *fp;

  if((fp=fopen(RCFilename,"wt"))==NULL)
    return 1;
  /* t@C */
  CPLISTLOOP_BEGIN(line,const char,lines)
    fprintf(fp,"%s\n",line);
  CPLISTLOOP_END;

  return 0;
}

/* -------------------------------------------------- */
/* ========= ݒt@C̓ǂݍݓe ========= */
/* -------------------------------------------------- */
int
RCFileClear(CPLIST *lines)
{
  FILE *fp;

  fp=fopen(RCFilename,"wt");
  if(fp==NULL)
    return 1;
  /* t@C */
  CPLISTLOOP_BEGIN(line,const char,lines)
    {
      alcstrDestroy(line);
      cplistDeleteItem(&lines,line);
    }
  CPLISTLOOP_END;
  return 0;
}
