/*
 * connection.c
 *
 * CONNECTIONf[^̎MIRCT[õbZ[W̏B
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "string.h"

#include "achat.h"

/*  */
/*  */
/* bb                                                  bb */
/* bb              bZ[Wp}N              bb */
/* bb                                                  bb */
/*  */
/*  */

#define ANALYZEERROR {\
  ALCSTR tmp;							\
  tmp=alcstrDeleteCRLF(line);					\
  SystemMessageF(SYSMSG_ANALYZE,				\
		 "*** Connection($CONNECTION) analyze error",	\
		 "CONNECTION",ASFORMAT_STRING,cnp->name,	\
		 NULL);						\
  SystemMessageF(SYSMSG_ANALYZE,"Message:$MESSAGE",		\
		 "MESSAGE",ASFORMAT_STRING,tmp,			\
		 NULL);						\
  SystemMessageF(SYSMSG_ANALYZE,"Source:$SOURCE:$LINE",		\
		 "SOURCE",ASFORMAT_STRING,__FILE__,		\
		 "LINE",  ASFORMAT_INT   ,__LINE__,		\
		 NULL);						\
}

#define GETPARAMETER(ret,wordNo) \
if((ret=alcstrWord(line+1,(wordNo)))==NULL){			\
  ANALYZEERROR;							\
  SystemMessageF(SYSMSG_ANALYZE,				\
		 "Not enough parameters(needs $NEED)",		\
		 "NEED",ASFORMAT_INT,(wordNo),			\
		 NULL);						\
  return 0;							\
}

#define GETCHANNEL(chp,wordNo) { \
  ALCSTR tmp;							\
  GETPARAMETER(tmp,(wordNo));					\
  if((chp=ChannelGet((cnp),tmp))==NULL){			\
    ANALYZEERROR;						\
    SystemMessageF(SYSMSG_ANALYZE,				\
		   "No such channnel($CHANNEL) "		\
		   "on connection($CONNECTION)",		\
		   "CHANNEL",   ASFORMAT_STRING,(tmp),		\
		   "CONNECTION",ASFORMAT_STRING,cnp->name,	\
		   NULL);					\
    return 0;							\
  }								\
}

#define GETUSER(up,wordNo) { \
  ALCSTR tmp;							\
  GETPARAMETER(tmp,(wordNo));					\
  if((up=UserGet((cnp),tmp))==NULL){				\
    ANALYZEERROR;						\
    SystemMessageF(SYSMSG_ANALYZE,				\
		   "No such user($USER) "			\
		   "on connection($CONNECTION)",		\
		   "USER",      ASFORMAT_STRING,(tmp),		\
		   "CONNECTION",ASFORMAT_STRING,cnp->name,	\
		   NULL);					\
    return 0;							\
  }								\
}

#define USER_EXIST_CHECK if(up==NULL){\
  ANALYZEERROR;							\
  SystemMessageF(SYSMSG_ANALYZE,				\
		 "No such user($REALNICK) "			\
		 "on connection($CONNECTION)",			\
		 "REALNICK",      ASFORMAT_STRING,realNick,	\
		 "CONNECTION",ASFORMAT_STRING,cnp->name,	\
		 NULL);						\
  return 0;							\
}

static void
channelUserCheck(CHANNEL *chp,USER *up,
		 int haveToExist,int revision)
{
  int exist;
  exist=ChannelHasUser(chp,up);
  if((exist && !haveToExist) || (!exist && haveToExist))
    {
      ALCSTR_BEGIN
	{
	  if(exist)
	    {
	      SystemMessageF(SYSMSG_ANALYZE,
			     "User($USER) is on channel($CHANNEL)",
			     "CHANNEL",ASFORMAT_STRING,ChannelGetName(chp),
			     "USER",   ASFORMAT_STRING,UserGetNick(up),
			     NULL);
	      ChannelDeleteUser(chp,up);
	    }
	  else
	    {
	      SystemMessageF(SYSMSG_ANALYZE,
			     "User($USER) isn't on channel($CHANNEL)",
			     "CHANNEL",ASFORMAT_STRING,ChannelGetName(chp),
			     "USER",   ASFORMAT_STRING,UserGetNick(up),
			     NULL);
	      ChannelAddUser(chp,up);
	    }
	}
      ALCSTR_END;
    }
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                 bZ[W̑M                 bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ========== SNCAgւ̃bZ[W ========== */
/* -------------------------------------------------- */
static int
sendAllMessage(const char *msg)
{
  int count=0;
  PLISTCLIENTLOOP_BEGIN(clp)
    {
      if(clp->check==CLIENT_CHECK_ALLRIGHT)
	{
	  if(ClientSendMessage(clp,msg)==AERROR_NONE)
	    count++;
	}
    }
  PLISTLOOP_END;

  return (count==0)?AERROR_NOSUCH_CLIENT:AERROR_NONE;
}

static int
sendAllMessageF(const char *fmt,...)
{
  int ret;
  ALCSTR tmp;
  va_list argp;

  va_start(argp,fmt);
  ret=sendAllMessage(tmp=alcstrFormatV(fmt,argp));
  alcstrDestroy(tmp);
  va_end(argp);

  return ret;
}

/* -------------------------------------------------- */
/* ============= `l̃bZ[W ============= */
/* -------------------------------------------------- */
static int
sendChannelMessage(CHANNEL *chp,const char *msg)
{
  int count=0;
  PLISTCLIENTLOOP_BEGIN(clp)
    {
      if(plistGetIndex(clp->channel,chp)>=0)
	{
	  if(ClientSendMessage(clp,msg)==AERROR_NONE)
	    count++;
	}
    }
  PLISTLOOP_END;

  return (count==0)?AERROR_NOSUCH_CLIENT:AERROR_NONE;
}

static int
sendChannelMessageF(CHANNEL *chp,const char *fmt,...)
{
  int ret;
  ALCSTR tmp;
  va_list argp;

  va_start(argp,fmt);
  ret=sendChannelMessage(chp,tmp=alcstrFormatV(fmt,argp));
  alcstrDestroy(tmp);
  va_end(argp);

  return ret;
}

/* -------------------------------------------------- */
/* =============== [ŨbZ[W =============== */
/* -------------------------------------------------- */
static int
sendUserMessage(USER *up,const char *msg)
{
  int count=0;
  PLISTCLIENTLOOP_BEGIN(clp)
    {
      int exist=0;
      PLISTLOOP_BEGIN(chp,CHANNEL,up->channel)
	{
	  if(plistGetIndex(clp->channel,chp)>=0)
	    exist=1;
	}
      PLISTLOOP_END;
    if(exist)
      {
	if(ClientSendMessage(clp,msg)==AERROR_NONE)
	  count++;
      }
    }
  PLISTLOOP_END;

  return (count==0)?AERROR_NOSUCH_CLIENT:AERROR_NONE;
}

static int
sendUserMessageF(USER *up,const char *fmt,...)
{
  int ret;
  ALCSTR tmp;
  va_list argp;

  va_start(argp,fmt);
  ret=sendUserMessage(up,tmp=alcstrFormatV(fmt,argp));
  alcstrDestroy(tmp);
  va_end(argp);

  return ret;
}

/* -------------------------------------------------- */
/* ============== MbZ[W̏ ============== */
/* -------------------------------------------------- */
static int
processServerMessage(CONNECTION *cnp,const char *line)
{
  int i;
  ALCSTR cmd,from,realNick=NULL,dispNick=NULL;
  USER *up=NULL;

  from=alcstrWord(line+1,0);
  if(from==NULL) return 0;

  /* M */
  for(i=0;from[i]!='\0' && from[i]!='!';i++);
  if(from[i]=='!')
    {
      realNick=alcstrMiddle(from,0,i);
      up=UserGet(cnp,realNick);
      dispNick=ConnectionAddDescriptor(cnp,realNick);
      from=alcstrFormat("$DISPNICK!$OTHER",
			"DISPNICK",ASFORMAT_STRING,dispNick,
			"OTHER"   ,ASFORMAT_STRING,from+i+1,
			NULL);
    }

  /* R}h擾 */
  cmd=alcstrWord(line+1,1);
  if(cmd==NULL)
    return 0;

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ------ ܂܂ł̃bZ[W̏ ------ */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(cnp->stat==CNSTAT_NAMES)
    do
      {
	ALCSTR chnl;
	CHANNEL *chp;
	/* `l̃[UXgĂ */
	if(stringCmp(cmd,"353"))
	  {
	    GETPARAMETER(chnl,4);
	    if(stringCmp(chnl,cplistGetItem(cnp->statarg,0)))
	      break;
	  }
	/* `l̎擾 */
	chnl=alcstrCopy(cplistGetItem(cnp->statarg,0));
	chp=ChannelGet(cnp,chnl);
	/* mĂ`l̏ꍇ */
	if(chp!=NULL)
	  {
	    /* [U̒ǉ */
	    CPLISTLOOP_BEGIN(nick,const char,cnp->statarg->next)
	      {
		USER *up;
		/* [Uf[^擾/쐬 */
		up=UserGet(cnp,nick+(nick[0]=='+' || nick[0]=='@'));
		if(up==NULL)
		  up=UserCreate(cnp,nick+(nick[0]=='+' || nick[0]=='@'));
		/* `lf[^֒ǉ */
		if(!ChannelHasUser(chp,up)) ChannelAddUser(chp,up);
	      }
	    CPLISTLOOP_END;
	    /* [Ȗ݊mF */
	    PLISTLOOP_BEGIN(cup,CHUSER,chp->chuser)
	      {
		ALCSTR nick=NULL;
		USER *up;
		up=cup->user;
		CPLISTLOOP_BEGIN(user,const char,cnp->statarg->next)
		  {
		    if(stringCmp(up->nick,user+(*user=='@' || *user=='+')))
		      nick=user;
		  }
		CPLISTLOOP_END;
		/* jbNȂ΃[U폜 */
		if(nick==NULL)
		  ChannelDeleteUser(chp,up);
		/* [h̐ݒ */
		else
		  {
		    switch((int)nick[0])
		      {
		      case '+': ChannelSetV (chp,up); break;
		      case '@': ChannelSetOp(chp,up); break;
		      default:
			ChannelResetV (chp,up);
			ChannelResetOp(chp,up);
		      }
		    i++;
		  }
	      }
	    PLISTLOOP_END;
	  }
	/* `l */
	{
	  ALCSTR tmp;
	  tmp=chnl;
	  chnl=ConnectionAddDescriptor(cnp,tmp);
	  alcstrDestroy(tmp);
	}
	/* Xg̏o */
	{
	  ALCSTR msg=NULL;
	  CPLISTLOOP_BEGIN(nick,const char,cnp->statarg->next)
	    {
	      ALCSTR user;
	      user=ConnectionAddDescriptor(cnp,
					   (nick[0]=='+' || nick[0]=='@')?
					   nick+1:nick);
	      /* ǉłeʂȂΑM */
	      if(msg!=NULL && strlen(msg)+strlen(user)>256)
		{
		  sendAllMessage(msg);
		  alcstrDestroy(msg);
		  msg=NULL;
		}
	      /* ŝ͂߂Ȃ */
	      if(msg==NULL)
		msg=alcstrFormat(":$SERVER 353 $NICKNAME = $CHANNEL :",
				 "SERVER"  ,ASFORMAT_STRING,Hostname,
				 "NICKNAME",ASFORMAT_STRING,Nickname,
				 "CHANNEL" ,ASFORMAT_STRING,chnl,
				 NULL);
	      /* łȂ΃Xy[X */
	      else
		realcstrConcatenate(&msg," ");

	      if(nick[0]=='+') realcstrConcatenate(&msg,"+");
	      if(nick[0]=='@') realcstrConcatenate(&msg,"@");
	      realcstrConcatenate(&msg,user);
	    }
	  CPLISTLOOP_END;
	  /* c𑗐M */
	  if(msg!=NULL)
	    {
	      sendAllMessage(msg);
	      alcstrDestroy(msg);
	    }
	}
	/* tÕNA */
	cnp->stat=CNSTAT_NONE;
	while(cnp->statarg!=NULL)
	  {
	    ALCSTR tmp;
	    tmp=cplistGetItem(cnp->statarg,0);
	    cplistDeleteItem(&cnp->statarg,tmp);
	    alcstrDestroy(tmp);
	  }
      }
    while(0);
  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ---------- ڑ̃bZ[W ---------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(stringCmp(cmd,"001"))
    {
      cnp->flags|=CNFLAG_REGISTERED;
      SystemMessageF(SYSMSG_CONNECTION,"Connection($CONNECTION)"
		     " has registered",
		     "CONNECTION",ASFORMAT_STRING,cnp->name,
		     NULL);
      if(cnp==MainConnection)
	do
	  {
	    /* jbNl[̔ */
	    ALCSTR nick;
	    GETPARAMETER(nick,2);
	    if(strcmp(nick,Nickname)==0)
	      break;
	    /* jbNl[̕ύX */
	    sendAllMessageF(":$NICKNAME!$USERNAME@$ADDRESS NICK :$NEWNICK",
			    "NICKNAME",ASFORMAT_STRING,Nickname,
			    "USERNAME",ASFORMAT_STRING,Username,
			    "ADDRESS" ,ASFORMAT_STRING,Hostname,
			    "NEWNICK" ,ASFORMAT_STRING,nick,
			    NULL);
	    alcstrUpdate(&Nickname,nick);
	  }
	while(0);
      return 1;
    }
  if(stringCmp(cmd,"002")
     || stringCmp(cmd,"003")
     || stringCmp(cmd,"004"))
    return 0;

  /* :server 433 * nick :Nickname is already in use.*/
  if(stringCmp(cmd,"433") && !(cnp->flags&CNFLAG_REGISTERED))
    {
      ALCSTR lastNick,nextNick;;
      /* OɎw肵jbN擾 */
      GETPARAMETER(lastNick,3);
      /* ̃jbN擾 */
      {
	int i;
	ALCSTR cp;
	for(i=0; (cp=cplistGetItem(StartNick,i))!=NULL; i++)
	  {
	    if(stringCmp(cp,lastNick))
	      break;
	  
	  }
	nextNick=cplistGetItem(StartNick,i+1);
	if(nextNick==NULL)
	  {
	    /* ׂẴjbNgĂꍇ */
	    SystemMessageF(SYSMSG_SYSTEM,
			   "Error in connection(All start-nick in use)"
			   " ($CONNECTION)",
			   "CONNECTION",ASFORMAT_STRING,cnp->name,
			   NULL);
	    ConnectionSendMessage(cnp,"QUIT");
	    return 0;
	  }
      }
      /* jbNύX */
      ConnectionSendMessageF(cnp,"NICK $NEXTNICK",
			     "NEXTNICK",ASFORMAT_STRING,nextNick,
			     NULL);
      UserNick(cnp->myself,nextNick);
      return 0;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ---------- JOIÑbZ[W ---------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  /* :nick!user@address JOIN :#channel */
  if(stringCmp(cmd,"JOIN"))
    {
      ALCSTR chnl;
      CHANNEL *chp;
      /* JOINȂ΃`lǉ */
      if(up==cnp->myself)
	{
	  GETPARAMETER(chnl,2);
	  chp=ChannelCreate(cnp,chnl);
	  chnl=ChannelGetName(chp);
	  /* JOINNGXgJOIN */
	  PLISTLOOP_BEGIN(clp,CLIENT,Client)
	    {
	      JOINREQ *rp;
	      if(clp->check!=CLIENT_CHECK_ALLRIGHT)
		continue;
	      rp=JoinreqGetByConnection(clp,cnp,chp->name);
	      if(!(clp->flags&CLFLAG_ALLCHANNEL) && rp==NULL)
		continue;	
	      if(rp!=NULL)
		JoinreqDestroy(rp);
	      ClientJoinChannel(clp,chp);
	      ClientSendMessageF(clp,":$NICKNAME!$USERNAME@$ADDRESS JOIN"
				 " :$CHANNEL",
				 "NICKNAME",ASFORMAT_STRING,Nickname,
				 "USERNAME",ASFORMAT_STRING,Username,
				 "ADDRESS" ,ASFORMAT_STRING,Hostname,
				 "CHANNEL" ,ASFORMAT_STRING,chnl,
				 NULL);
	    }
	  PLISTLOOP_END;
	}

      /* lJOINȂ烆[Uǉ */
      else
	{
	  GETCHANNEL(chp,2);
	  if(up==NULL)
	    up=UserCreate(cnp,realNick);
	  channelUserCheck(chp,up,0,1);
	  ChannelAddUser(chp,up);
	  /* bZ[W̑M */
	  chnl=ChannelGetName(chp);
	  sendChannelMessageF(chp,":$USER JOIN $CHANNEL",
			      "USER",   ASFORMAT_STRING,from,
			      "CHANNEL",ASFORMAT_STRING,chnl,
			      NULL);
	}
      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* --- gsbNݒE\̃bZ[W --- */
  /* PPPPPPPPPPPPPPPPPPPP */
  /* :server 332 nick #channel :topic */
  if(stringCmp(cmd,"332"))
    {
      ALCSTR chnl,tmp;
      CHANNEL *chp;
      /* `l */
      GETCHANNEL(chp,3);
      chnl=ChannelGetName(chp);
      /* gsbN */
      tmp=alcstrWord(line+1,4);
      if(tmp==NULL)
	tmp="";
      alcstrUpdate(&chp->topic,tmp);
    }

  /* :nick!user@address TOPIC #channel :topic */
  if(stringCmp(cmd,"TOPIC"))
    {
      ALCSTR chnl,tmp;
      CHANNEL *chp;
      /* `l */
      GETCHANNEL(chp,2);
      chnl=ChannelGetName(chp);
      /* gsbN */
      tmp=alcstrWord(line+1,3);
      if(tmp==NULL)
	tmp="";
      alcstrUpdate(&chp->topic,tmp);

      /* bZ[WM */
      sendChannelMessageF(chp,":$USER TOPIC $CHANNEL :$TOPIC",
			  "USER",   ASFORMAT_STRING,from,
			  "CHANNEL",ASFORMAT_STRING,chnl,
			  "TOPIC",  ASFORMAT_STRING,chp->topic,
			  NULL);
      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ------ jbNXg̃bZ[W ------ */
  /* PPPPPPPPPPPPPPPPPPPP */
  /* :server 353 nick = #channek :nick1 @nick2 ... */
  if(stringCmp(cmd,"353"))
    {
      int i;
      ALCSTR tmp,chnl,users;
      /* `l */
      GETPARAMETER(chnl,4);
      /* [UXg */
      GETPARAMETER(users,5);
      /* RlNVXe[^X */
      if(cnp->stat==CNSTAT_NONE)
	{
	  cnp->stat=CNSTAT_NAMES;
	  cplistAddItem(&cnp->statarg,alcstrSet(chnl));
	}

      /* 擾[ŰL */
      for(i=0; (tmp=alcstrWord(users,i))!=NULL; i++)
	cplistAddItem(&cnp->statarg,alcstrSet(tmp));

      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ---------- PART̃bZ[W ---------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  /* :nick!user@address PART #channel :message */
  if(stringCmp(cmd,"PART"))
    {
      ALCSTR chnl,msgtmp;
      CHANNEL *chp;
      USER_EXIST_CHECK;
      /* `l */
      GETCHANNEL(chp,2);
      channelUserCheck(chp,up,1,1);
      chnl=ChannelGetName(chp);
      /* bZ[WM */
      msgtmp=alcstrWord(line+1,3);
      if(msgtmp==NULL) msgtmp="";
      sendChannelMessageF(chp,":$USER PART $CHANNEL :$MESSAGE",
			  "USER",   ASFORMAT_STRING,from,
			  "CHANNEL",ASFORMAT_STRING,chnl,
			  "MESSAGE",ASFORMAT_STRING,msgtmp,
			  NULL);

      /* PARTȂ`l폜 */
      if(up==cnp->myself)
	ChannelDestroy(chp);
      /* łȂ΃[U */
      else
	ChannelDeleteUser(chp,up);

      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* --------- LbÑbZ[W --------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  /* :nick!user@address KICK #channel nick :message */
  if(stringCmp(cmd,"KICK"))
    {
      ALCSTR target,chnl,msgtmp;
      USER *tp;
      CHANNEL *chp;
      USER_EXIST_CHECK;

      /* `l */
      GETCHANNEL(chp,2);
      channelUserCheck(chp,up,1,1);
      chnl=ChannelGetName(chp);
      /* Rꂽ[U */
      GETUSER(tp,3);
      target=UserGetNick(tp);
      /* bZ[W */
      msgtmp=alcstrWord(line+1,4);
      if(msgtmp==NULL)
	msgtmp="";

      sendChannelMessageF(chp,":$USER KICK $CHANNEL $TARGET :$MESSAGE",
			  "USER",   ASFORMAT_STRING,from,
			  "CHANNEL",ASFORMAT_STRING,chnl,
			  "TARGET", ASFORMAT_STRING,target,
			  "MESSAGE",ASFORMAT_STRING,msgtmp,
			  NULL);

      if(tp==cnp->myself)
	{
	  /* JOIN[h̏ꍇ */ 
	  if(cnp->flags&CNFLAG_AUTOREJOIN)
	    {
	      /* NCAgJOINvo^ */
	      PLISTCLIENTLOOP_BEGIN(clp)
		{
		  if(ClientIsJoinChannel(clp,chp))
		    JoinreqCreateByConnection(clp,cnp,chp->name);
		}
	      PLISTLOOP_END;
	      /* JOINvbZ[WM */
	      ConnectionSendMessageF(cnp,"JOIN $CHANNEL",
				     "CHANNEL",ASFORMAT_STRING,chp->name,
				     NULL);
	    }
	  /* `lj */
	  ChannelDestroy(chp);
	}
      else
	ChannelDeleteUser(chp,tp);

      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ---------- MODẼbZ[W ---------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  /* :nick!user@address MODE channel +o user */
  if(stringCmp(cmd,"MODE"))
    {
      CHANNEL *chp;
      ALCSTR target;
      GETPARAMETER(target,2);

      /* `lւ̃bZ[W */
      chp=ChannelGet(cnp,target);
      if(chp!=NULL)
	{
	  int cmdNo,argNo;
	  ALCSTR modeLine,chnl;

	  chnl=ChannelGetName(chp);
	  modeLine=alcstrCopy("");

	  for(cmdNo=3,argNo=4; ; cmdNo=argNo++)
	    {
	      int i,plus=1;
	      ALCSTR mode,tmp;
	      mode=alcstrWord(line+1,cmdNo);
	      if(mode==NULL)
		break;
	      if(modeLine[0]!='\0')
		realcstrConcatenate(&modeLine," ");
	      realcstrConcatenate(&modeLine,mode);
	      
	      for(i=0;mode[i]!='\0';i++)
		{
		  switch(mode[i])
		    {
		      /* [Uւ̃[h */
		    case 'o': case 'v':
		      GETUSER(up,argNo++);
		      tmp=UserGetNick(up);
		      channelUserCheck(chp,up,1,1);
		      realcstrConcatenate(&modeLine," ");
		      realcstrConcatenate(&modeLine,tmp);

		      if(mode[i]=='o')
			{
			  if(plus)
			    ChannelSetOp(chp,up);
			  else
			    ChannelResetOp(chp,up);
			}
		      else
			{
			  if(plus)
			    ChannelSetV(chp,up);
			  else
			    ChannelResetV(chp,up);
			}
		      break;

		      /* ̑̈+̏ꍇ݂̂[h */
		    case 'l':
		      if(!plus)
			break;
	    
		      /* ̑̈ɂ[h */
		    case 'b':
		    case 'I':
		    case 'e':
		    case 'k':
		      GETPARAMETER(tmp,argNo++);
		      realcstrConcatenate(&modeLine," ");
		      realcstrConcatenate(&modeLine,tmp);
		      break;

		      /* Ȃ[h */
		    case '+':
		      plus=1;
		      break;
		    case '-':
		      plus=0;
		      break;
		    default:
		      break;
		    }
		}
	    }

	  sendChannelMessageF(chp,":$USER MODE $CHANNEL $MODELINE",
			      "USER",    ASFORMAT_STRING,from,
			      "CHANNEL", ASFORMAT_STRING,chnl,
			      "MODELINE",ASFORMAT_STRING,modeLine,
			      NULL);
	}
      /* ̑ւ̃[h */
      else
	{
	  int i;
	  target=ConnectionAddDescriptor(cnp,target);
	  for(i=0;line[i]!=' ' && line[i]!='\0';i++); for(;line[i]==' ';i++);
	  for(   ;line[i]!=' ' && line[i]!='\0';i++); for(;line[i]==' ';i++);
	  for(   ;line[i]!=' ' && line[i]!='\0';i++); for(;line[i]==' ';i++);

	  sendAllMessageF(":$USER MODE $TARGET $MODELINE",
			  "USER",    ASFORMAT_STRING,from,
			  "TARGET",  ASFORMAT_STRING,target,
			  "MODELINE",ASFORMAT_STRING,line+1,
			  NULL);
	}
      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ---------- ̃bZ[W ---------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  /*:nick!user@address PRIVMSG #channel :message */
  if( stringCmp(cmd,"PRIVMSG")
      || stringCmp(cmd,"NOTICE") )
    {
      ALCSTR target,msgtmp;
      CHANNEL *chp;
      /*  */
      GETPARAMETER(target,2);
      GETPARAMETER(msgtmp,3);
      chp=ChannelGet(cnp,target);
      if(chp!=NULL && up!=NULL)
	channelUserCheck(chp,up,1,0);
      /* ւ̃bZ[W */
      if(stringCmp(cnp->myself->nick,target))
	target=Nickname;
      /* ȊOւ̃bZ[W */
      else
	target=ConnectionAddDescriptor(cnp,target);
      /* bZ[W̑M */
      if(chp!=NULL)
	sendChannelMessageF(chp,":$USER $COMMAND $TARGET :$MESSAGE",
			  "USER",   ASFORMAT_STRING,from,
			  "COMMAND",ASFORMAT_STRING,cmd,
			  "TARGET", ASFORMAT_STRING,target,
			  "MESSAGE",ASFORMAT_STRING,msgtmp,
			  NULL);
      else
	{
	  PLISTCLIENTLOOP_BEGIN(clp)
	    {
	      if( clp->check==CLIENT_CHECK_ALLRIGHT
		  && !(clp->flags&CLFLAG_IGNOREPRIV) )
		{
		  ClientSendMessageF(clp,":$USER $COMMAND $TARGET :$MESSAGE",
				     "USER",   ASFORMAT_STRING,from,
				     "COMMAND",ASFORMAT_STRING,cmd,
				     "TARGET", ASFORMAT_STRING,target,
				     "MESSAGE",ASFORMAT_STRING,msgtmp,
				     NULL);
		}
	    }
	  PLISTLOOP_END;
	}

      /* CTCP̏ꍇ */
      if(msgtmp[0]==0x01 && stringCmp(cmd,"PRIVMSG"))
	{
	  ALCSTR nick,ctcpcmd,ctcpline;
	  {
	    int i;
	    /* CTCPvjbN */
	    for(i=1;line[i]!='\0' && line[i]!='!' && line[i]!=' ';i++);
	    nick=alcstrMiddle(line,1,i-1);
	    /* CTCPbZ[W */
	    for(i=1;msgtmp[i]!=0x01 && msgtmp[i]!='\0';i++);
	    ctcpline=alcstrMiddle(msgtmp,1,i-1);
	    /* CTCPR}h */
	    ctcpcmd=alcstrWord(ctcpline,0);
	  }

	  if(stringCmp(ctcpcmd,"VERSION"))
	    ConnectionSendMessageF(cnp,"NOTICE $TARGET :"
				   "\01VERSION $VERSION\01",
				   "TARGET", ASFORMAT_STRING,nick,
				   "VERSION",ASFORMAT_STRING,Version,
				   NULL);
	  if(stringCmp(ctcpcmd,"PING"))
	    ConnectionSendMessageF(cnp,"NOTICE $TARGET :\01$CTCPLINE\01",
				   "TARGET",  ASFORMAT_STRING,nick,
				   "CTCPLINE",ASFORMAT_STRING,ctcpline,
				   NULL);
	}

      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ---------- NICK̃bZ[W ---------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  /* :nick!user@address NICK :newnick */
  if(stringCmp(cmd,"NICK"))
    {
      ALCSTR newnick;
      USER_EXIST_CHECK;
      /* VjbNݒ */
      GETPARAMETER(newnick,2);
      UserNick(up,newnick);
      newnick=UserGetNick(up);
      /* bZ[WM */
      if(up==cnp->myself)
	{
	  if(cnp->flags&CNFLAG_REGISTERED)
	    {
	      if(cnp==MainConnection)
		{
		  alcstrUpdate(&Nickname,up->nick);
		  sendAllMessageF(":$USER NICK :$NEWNICK",
				  "USER",   ASFORMAT_STRING,from,
				  "NEWNICK",ASFORMAT_STRING,Nickname,
				  NULL);
		}
	    }
	}
      else
	{
	  sendUserMessageF(up,":$USER NICK :$NEWNICK",
			   "USER",   ASFORMAT_STRING,from,
			   "NEWNICK",ASFORMAT_STRING,newnick,
			   NULL);
	}

      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ---------- QUIT̃bZ[W ---------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  /* :nick!user@address QUIT :message */
  if(stringCmp(cmd,"QUIT"))
    {
      ALCSTR msgtmp;
      USER_EXIST_CHECK;
      /* bZ[WM */
      msgtmp=alcstrWord(line+1,2);
      if(msgtmp==NULL)
	msgtmp="";
      sendUserMessageF(up,":$USER QUIT :$MESSAGE",
		       "USER",   ASFORMAT_STRING,from,
		       "MESSAGE",ASFORMAT_STRING,msgtmp,
		       NULL);

      UserDestroy(up);
      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ---------- ̑̃bZ[W ---------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  {
    int i,words;
    ALCSTR tmp,msg;

    SystemMessage(SYSMSG_DEBUG,"*** Unanalyzeable message ***");
    SystemMessageF(SYSMSG_DEBUG,"Read $READLINE",
		   "READLINE",ASFORMAT_STRING,alcstrDeleteCRLF(line),
		   NULL);
    words=stringNumberOfWord(line+1);

    msg=alcstrFormat(":$USER",
		     "USER",ASFORMAT_STRING,from,
		     NULL);
    for(i=1; (tmp=alcstrWord(line+1,i))!=NULL; i++)
      {
	USER *up;
	CHANNEL *chp;
	chp=ChannelGet(cnp,tmp);
	if(chp!=NULL)
	  tmp=ChannelGetName(chp);
	else
	  {
	    up=UserGet(cnp,tmp);
	    if(up!=NULL)
	      tmp=UserGetNick(up);
	  }

	realcstrConcatenate(&msg,(i<words-1)?" ":" :");
	realcstrConcatenate(&msg,tmp);
      }
    
    SystemMessageF(SYSMSG_DEBUG,"Write $WRITELINE",
		   "WRITELINE",ASFORMAT_STRING,msg,
		   NULL);
    sendAllMessage(msg);
  }
  return 1;
}

/* -------------------------------------------------- */
/* ==================== s擾 ==================== */
/* -------------------------------------------------- */
static void
processServerCommand(CONNECTION *cnp,const char *line)
{
  ALCSTR cmd;
  cmd=alcstrWord(line,0);
  if(cmd==NULL)
    return;

  /* PINGbZ[W */
  if(stringCmp(cmd,"PING"))
    {
      ConnectionSendMessage(cnp,"PONG yourself");
      return;
    }

  /* ERRORbZ[W */
  if(stringCmp(cmd,"ERROR"))
    {
      ALCSTR errorMsg;
      {
	/* u(vƁu)vłꂽ͈͂Eo */
	int s,e;
	for(s=           0; line[s]!='(' && line[s]!='\0' ;s++);
	for(e=strlen(line); line[e]!=')' && e>0           ;e--);
	s++;
	e--;
	errorMsg=(s<e)?alcstrMiddle(line,s,e-s+1):alcstrWord(line,1);
      }
      SystemMessageF(SYSMSG_CONNECTION,
		     "Error in connection($CONNECTION) ($MESSAGE)",
		     "CONNECTION",ASFORMAT_STRING,cnp->name,
		     "MESSAGE",   ASFORMAT_STRING,errorMsg,
		     NULL);
      return;
    }

  /* ̑̃bZ[W */
  PLISTCLIENTLOOP_BEGIN(clp)
    {
      if(clp->check==CLIENT_CHECK_ALLRIGHT)
	ClientSendMessage(clp,line);
    }
  PLISTLOOP_END;
}

/* -------------------------------------------------- */
/* ==================== s擾 ==================== */
/* -------------------------------------------------- */
void
ReadConnectionMessage(CONNECTION *cnp)
{
  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ---------- ĂȂꍇ ---------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(cnp->bufsock==NULL)
    {
      if(cnp->bufsock==NULL && (cnp->flags&CNFLAG_AUTOCONNECT)){
	if(NowTime-cnp->update>RetryTime)
	  ConnectionOpen(cnp);
      }
      return;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ------ ǂݍ񂾃bZ[W̏ ------ */
  /* PPPPPPPPPPPPPPPPPPPP */
  for(;;)
    {
      ALCSTR_BEGIN
	{
	  ALCSTR line;
	  CPLIST *lines;
	  line=bufsockGetLine(cnp->bufsock);
	  if(line==NULL)
	    ALCSTR_BREAK;
	  
	  /* fobOpbZ[W */
	  ALCSTR_BEGIN
	    {
	      ALCSTR dbmsg;
	      dbmsg=alcstrDeleteCRLF(line);
	      SystemMessageF(SYSMSG_READ_SERVER,
			     "Read($CONNECTION)[$LINE]",
			     "CONNECTION",ASFORMAT_STRING,cnp->name,
			     "LINE"      ,ASFORMAT_STRING,line,
			     NULL);
	    }
	  ALCSTR_END;

	  /* vOC̃tB^O */
	  lines=PluginFilterFunction( cnp->name, line,
				      PLUGIN_FUNCPOS(connectionReadFilter) );

	  while( (line=cplistGetItem(lines,0)) )
	    {
	      /* vOC̃bZ[W */
	      PluginCallFunction( cnp->name, line,
				  PLUGIN_FUNCPOS(connectionRead) );

	      /* {̂̃bZ[W */
	      /* ʏ탁bZ[W̏ */
	      if(line[0]==':')
		{
		  processServerMessage(cnp,line);
		  /* [Uf[^̔j */
		  if( cnp->loseSightUser )
		    {
		      PLISTLOOP_BEGIN( up, USER,cnp->loseSightUser )
			{
			  if( up->channel==NULL )
			    UserDestroy(up);
			}
		      PLISTLOOP_END;
		      plistClearItem(&cnp->loseSightUser);
		    }
		}
	      /* T[obZ[W̏ */
	      else
		processServerCommand(cnp,line);

	      /* ύs̍폜 */
	      cplistDeleteItem( &lines, line );
	      alcstrDestroy( line );
	    }
	}
      ALCSTR_END;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* -------- ێ`lւJOIN -------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  if( cnp->flags & CNFLAG_REGISTERED )
    {
      PLISTLOOP_BEGIN(kp,KPCHANNEL,cnp->kpchannel)
	{
	  if(!kp->hasJoined && NowTime-kp->lastTry>RetryTime)
	    {
	      ConnectionSendMessageF(cnp,"JOIN $CHANNEL",
				     "CHANNEL",ASFORMAT_STRING,kp->name,
				     NULL);
	      kp->lastTry=NowTime;
	    }
	}
      PLISTLOOP_END;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* -------------- PING/PONG  -------------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  /* PINGMO */
  if(!(cnp->flags&CNFLAG_SENDPING))
    {
      /* 莞Ԉȏo߂PINGM */
      if(cnp->update<NowTime-TIME_PINGSEND)
	{
	  ConnectionSendMessage(cnp,"PING :yourself");
	  cnp->flags|=CNFLAG_SENDPING;
	}
    }
  /* PINGMO */
  else
    {
      if(cnp->update<NowTime-TIME_PINGSEND-TIME_PINGTIMEOUT)
	{
	  ConnectionClose(cnp);
	  return;
	}
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* -------- ݃obt@̏o -------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  bufsockFlushWrite(cnp->bufsock,1000);
}
