/*
 * command.c
 *
 * aCHU^HatR}h͓B
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#include "bufsock.h"
#include "string.h"
#include "plist.h"

#include "achat.h"
#include "ui.h"

/*  */
/*  */
/* bb                                                  bb */
/* bb                    bZ[W                    bb */
/* bb                                                  bb */
/*  */
/*  */
static CLIENT *replyTarget=NULL;
static ALCSTR messagePlus=NULL;

void
SetReplyTarget(CLIENT *clp)
{
  replyTarget=clp;
}

/* -------------------------------------------------- */
/* ================= bZ[Wo ================= */
/* -------------------------------------------------- */
static void
message(const char *msg)
{
  if(replyTarget==NULL)
    {
      ALCSTR_BEGIN
	{
	  UIPrint(SYSMSG_SYSTEM,
		  alcstrFormat("$MESSAGE$MSGPLUS",
			       "MESSAGE",ASFORMAT_STRING,msg,
			       "MSGPLUS",ASFORMAT_STRING,
			       (messagePlus!=NULL)?messagePlus:"",
			       NULL)                              );
	}
      ALCSTR_END;
    }
  else
    {
      ClientSendNoticeF(replyTarget,"$MESSAGE$MSGPLUS",
			"MESSAGE",ASFORMAT_STRING,msg,
			"MSGPLUS",ASFORMAT_STRING,
			(messagePlus!=NULL)?messagePlus:"",
			NULL);
    }
}

/* tH[}bgΉ */
static void
messageF(const char *fmt,...)
{
  va_list argp;
  va_start(argp,fmt);
  ALCSTR_BEGIN
    {
      message(alcstrFormatV(fmt,argp));
    }
  ALCSTR_END;
  va_end(argp);
}

/* -------------------------------------------------- */
/* ============== bZ[Wt ============== */
/* -------------------------------------------------- */
static void
setMessagePlus(const char *st)
{
  alcstrUpdate(&messagePlus,st);
}

static void
setMessagePlusF(const char *fmt,...)
{
  va_list argp;
  va_start(argp,fmt);
  ALCSTR_BEGIN
    {
      alcstrUpdate(&messagePlus,alcstrFormatV(fmt,argp));
    }
  ALCSTR_END;
  va_end(argp);
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                    `l                    bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ====================== n ====================== */
/* -------------------------------------------------- */
int
CmdOn(CLIENT *clp,CHANNEL *chp)
{
  ALCSTR chnl;
  chnl=ChannelGetName(chp);

  /* `lɓ */
  if(ClientJoinChannel(clp,chp)!=AERROR_NONE)
    /* ɂꍇ */
    {
      messageF("You're already on channel($CHANNEL).",
	       "CHANNEL",ASFORMAT_STRING,chnl,
	     NULL);
      return AERROR_ALREADYJOIN_CHANNEL;
    }

  /* JOINbZ[W */
  ClientSendMessageF(clp,":$NICKNAME!$USERNAME@$ADDRESS JOIN $CHANNEL",
		     "NICKNAME",ASFORMAT_STRING,Nickname,
		     "USERNAME",ASFORMAT_STRING,Username,
		     "ADDRESS" ,ASFORMAT_STRING,Hostname,
		     "CHANNEL" ,ASFORMAT_STRING,chnl,
		     NULL);
  /* gsbN */
  ClientSendMessageF(clp,":$SERVER 332 $NICKNAME $CHANNEL :$TOPIC",
		     "SERVER"  ,ASFORMAT_STRING,Hostname,
		     "NICKNAME",ASFORMAT_STRING,Nickname,
		     "CHANNEL" ,ASFORMAT_STRING,chnl,
		     "TOPIC"   ,ASFORMAT_STRING,chp->topic,
		     NULL);
  /* [UXg */
  if(chp->chuser!=NULL)
    {
      ALCSTR msg=NULL;
      PLISTCHUSERLOOP_BEGIN(up,chp)
	{
	  ALCSTR user;
	  /* [ŨjbN擾 */
	  {
	    ALCSTR nick;
	    nick=UserGetNick(up);
	    user=alcstrFormat("$MODE$NICKNAME",
			      "MODE",ASFORMAT_STRING,
			      ChannelCheckOp(chp,up)?"@":
			      ChannelCheckV (chp,up)?"+":"",
			      "NICKNAME",ASFORMAT_STRING,nick,
			      NULL);
	    alcstrDestroy(nick);
	  }
	  /* ǉłeʂȂΑM */
	  if(msg!=NULL && strlen(msg)+strlen(user)>256)
	    {
	      ClientSendMessage(clp,msg);
	      alcstrDestroy(msg);
	      msg=NULL;
	    }
	  /* ŝ͂߂Ȃ */
	  if(msg==NULL)
	    {
	      msg=alcstrFormat(":$SERVER 353 $NICKNAME = $CHANNEL :",
			       "SERVER"  ,ASFORMAT_STRING,Hostname,
			       "NICKNAME",ASFORMAT_STRING,Nickname,
			       "CHANNEL" ,ASFORMAT_STRING,chnl,
			       NULL);
	    }
	  /* łȂ΃Xy[X */
	  else
	    {
	      realcstrConcatenate(&msg," ");
	    }
	  /* sɒǉ */
	  realcstrConcatenate(&msg,user);
	  alcstrDestroy(user);
	}
      PLISTLOOP_END;
      /* c𑗐M */
      if(msg!=NULL)
	{
	  ClientSendMessage(clp,msg);
	  alcstrDestroy(msg);
	}
    }
  /* NAMES̏I */
  ClientSendMessageF(clp,":$SERVER 366 $NICKNAME $CHANNEL :End of NAMES list.",
		     "SERVER"  ,ASFORMAT_STRING,Hostname,
		     "NICKNAME",ASFORMAT_STRING,Nickname,
		     "CHANNEL" ,ASFORMAT_STRING,chnl,
		     NULL);

  alcstrDestroy(chnl);
  return AERROR_NONE;
}

/* -------------------------------------------------- */
/* ===================== n ===================== */
/* -------------------------------------------------- */
int
CmdOff(CLIENT *clp,CHANNEL *chp)
{
  ALCSTR chnl;
  chnl=ChannelGetName(chp);

  /* `l甲 */
  if(ClientPartChannel(clp,chp)!=AERROR_NONE)
    {
      messageF("You aren't on channel($CHANNEL).",
	       "CHANNEL" ,ASFORMAT_STRING,chnl,
	       NULL);
      return AERROR_NOTJOIN_CHANNEL;
    }

  /* PARTbZ[W */
  ClientSendMessageF(clp,":$NICKNAME!$USERNAME@$ADDRESS PART $CHANNEL :Off",
		     "NICKNAME",ASFORMAT_STRING,Nickname,
		     "USERNAME",ASFORMAT_STRING,Username,
		     "ADDRESS" ,ASFORMAT_STRING,Hostname,
		     "CHANNEL" ,ASFORMAT_STRING,chnl,
		     NULL);

  alcstrDestroy(chnl);
  return AERROR_NONE;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                      jbN                      bb */
/* bb                                                  bb */
/*  */
/*  */
int
CmdNick(const char *nick)
{
  int ret=AERROR_NONE;
  CONNECTION *cnp;
  ALCSTR tmp;

  /* ڑw肳Ă */
  cnp=ConnectionGetByName(&tmp,nick,CONNECTION_NOT_SPECIFIED);
  if(cnp==CONNECTION_NOT_SPECIFIED)
    {
      PLISTCONNECTIONLOOP_BEGIN(cnp)
	{
	  /* lbg[NɂȂRlNVΑMȂ */
	  if(cnp->server->network!=NULL)
	    {
	      int exist=0;
	      PLISTCONNECTIONLOOP_BEGIN(tcnp){
		if(tcnp==cnp) break;
		exist=(tcnp->server->network==cnp->server->network);
		if(exist)
		  break;
	      }PLISTLOOP_END;
	      if(exist)
		continue;
	    }
	  /* jbNbZ[WM */
	  ConnectionSendMessageF(cnp,"NICK $NICKNAME",
				 "NICKNAME",ASFORMAT_STRING,tmp,
				 NULL);
	}
      PLISTLOOP_END;
    }

  /* ڑw肳Ă */
  else
    {
      if(cnp==NULL)
	{
	  messageF("Couldn't specify connection:$STRING",
		   "STRING",ASFORMAT_STRING,nick,
		   NULL);
	  ret=AERROR_NOSUCH_CONNECTION;
	}
      else
	{
	  ConnectionSendMessageF(cnp,"NICK $NICKNAME",
				 "NICKNAME",ASFORMAT_STRING,tmp,
				 NULL);
	}
    }
  return AERROR_NONE;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                 R}ht@C                 bb */
/* bb                                                  bb */
/*  */
/*  */
int
CmdFile(const char *filename)
{
  FILE *fp;
  int lineCount;

  /* t@CJ */
  fp=fopen(filename,"rt");
  if(fp==NULL)
    {
      messageF("Couldn't open $FILENAME",
	       "FILENAME",ASFORMAT_STRING,filename,
	       NULL);
      return -1;
    }
  messageF("$FILENAME has opened.",
	     "FILENAME",ASFORMAT_STRING,filename,
	     NULL);

  /* t@Cǂݍ */
  for(lineCount=1;;lineCount++)
    {
      ALCSTR_BEGIN
	{
	  ALCSTR line=NULL;
	  /* s擾 */
	  {
	    char tmp[256];
	    while(fgets(tmp,256,fp)!=NULL)
	      {
		int i;
		if(line==NULL)
		  line=alcstrCopy(tmp);
		else
		  realcstrConcatenate(&line,tmp);
		for(i=0;!ISLINEEND(tmp[i]);i++);
		if(tmp[i]!='\0') break;
	      }
	    if(line==NULL)
	      ALCSTR_BREAK;
	  }
	  /* Rgs͋p */
	  if( (line[0]<'a' || line[0]>'z')
	      && (line[0]<'A' || line[0]>'Z') )
	    ALCSTR_CONTINUE;
	  /* bZ[Wtݒ */
	  setMessagePlusF("[$FILENAME:$LINE]",
			  "FILENAME",ASFORMAT_STRING,filename,
			  "LINE"    ,ASFORMAT_INT   ,lineCount,
			  NULL);
	  /*  */
	  CmdString(alcstrMSKanjitoJIS(alcstrDeleteCRLF(line)));
	}
      ALCSTR_END;
    }
  
  /* bZ[WtNA */
  setMessagePlus(NULL);

  /*  */
  messageF("$FILENAME has closed.",
	   "FILENAME",ASFORMAT_STRING,filename,
	   NULL);
  fclose(fp);

  return AERROR_NONE;
}


/*  */
/*  */
/* bb                                                  bb */
/* bb                R}h                bb */
/* bb                                                  bb */
/*  */
/*  */
#define NAMECHECK_NETWORK    1
#define NAMECHECK_SERVER     2
#define NAMECHECK_CONNECTION 3
static int nameCheck(ALCSTR as,int type){
  /* \`FbN */
  static ALCSTR reserved[]={
    "FILE",
    "USERNAME",
    "REALNAME",
    "NICKNAME",
    "LISTENPORT",
    "PASSWORD",
    "NETWORK",
    "SERVER",
    "CONNECTION",
    "LIST",
    "CLIENTDEFAULT",
    "CONNECTIONDEFAULT",
    "CHANNEL",
    "ALLCHANNEL",
    "CLOSE",
    "DESTROY"
  };
  {
    int i;
    for(i=0; i<sizeof(reserved)/sizeof(ALCSTR); i++)
      {
	if(stringCmp(as,reserved[i]))
	  {
	    messageF("Name($NAME) is reserved.",
		     "NAME",ASFORMAT_STRING,as,
		     NULL);
	    return 0;
	  }
      }
  }
  /* gp`FbN */
  {
    int i;
    for(i=0;as[i]!='\0';i++)
      {
	if((as[i]>='a' && as[i]<='z') ||
	   (as[i]>='A' && as[i]<='Z')    ) continue;
	if(i==0) break;
	if(as[i]>='0' && as[i]<='9') continue;
	if(as[i]=='-' && as[i]=='_') continue;
	break;
      }
    if(i==0 || as[i]!='\0')
      {
	messageF("Character($CHAR) mast not exist on name.",
		 "CHAR",ASFORMAT_CHAR,as[i],
		 NULL);
	return 0;
      }
  }
  /* gp`FbN */
  if(type!=NAMECHECK_NETWORK && NetworkGet(as)!=NULL)
    /* lbg[NƂĎgĂ */
    {
      messageF("Name($NAME) is already used as network name.",
	       "NAME",ASFORMAT_STRING,as,
	       NULL);
      return 0;
    }
  if(type!=NAMECHECK_SERVER && ServerGet(as)!=NULL)
    /* T[oƂĎgĂꍇ */
    {
      messageF("Name($NAME) is already used as server name.",
	       "NAME",ASFORMAT_STRING,as,
	       NULL);
      return 0;
    }
  if(type!=NAMECHECK_CONNECTION && ConnectionGet(as)!=NULL)
    /* RlNVƂĎgĂꍇ */
    {
      messageF("Name($NAME) is already used as connection name.",
	       "NAME",ASFORMAT_STRING,as,
	       NULL);
      return 0;
    }

  if(ClientGet(as)!=NULL)
    /* NCAgƂĎgĂꍇ */
    {
      messageF("Name($NAME) is already used as client name.",
	       "NAME",ASFORMAT_STRING,as,
	       NULL);
      return 0;
    }

  return 1;
}


#define ERR_TOOMANY {			\
  message("Too many parameters");	\
  ALCSTR_RETURN(AERROR_NONE);		\
}
#define ERR_NOTENOUGH {			\
  message("Not enough parameters");	\
  ALCSTR_RETURN(AERROR_NONE);		\
}
#define ARGSCHECK(min,max)		\
  if(words<(min)) ERR_NOTENOUGH;	\
  if(words>(max)) ERR_TOOMANY;

#define KEYCHECK(keyname,minarg,maxarg) \
if(stringCmp((keyname),key)){ 		\
  ARGSCHECK(minarg,maxarg);		\
}					\
if(stringCmp((keyname),key))

#define SPECIFYCONNECTION(cnp,ret,name) \
if(((cnp)=ConnectionGetByName(&(ret),(name),MainConnection))==NULL){	\
  messageF("Couldn't specify connection by `$STRING'",			\
	   "STRING",ASFORMAT_STRING,(name),				\
	   NULL);							\
  ALCSTR_RETURN(1);							\
}

#define GETCHANNELST(chp,chname) {\
  ALCSTR chnl;								\
  CONNECTION *cnp;							\
  SPECIFYCONNECTION(cnp,chnl,(chname));					\
  if((chp=ChannelGet(cnp,chnl))==NULL){					\
    messageF("No such channnel($CHANNEL) on connection($CONNECTION)",	\
	     "CHANNEL",   ASFORMAT_STRING,chnl,				\
	     "CONNECTION",ASFORMAT_STRING,cnp->name,			\
	     NULL);							\
    ALCSTR_RETURN(1);							\
  }									\
}

#define GETCHANNEL(chp,wordNo) { \
  ALCSTR *tmp;							\
  if(tmp=alcstrWord((line),(wordNo))==NULL) ERR_NOTENOUGH;	\
  GETCHANNELST(chp,tmp);					\
  alcstrDestroy(tmp);						\
}

/* ֐{ */
int
CmdString(const char *line)
{
  int words;
  ALCSTR key;
  ALCSTR_BEGIN;

  if( (line[0]<'a' || line[0]>'z')
      && (line[0]<'A' || line[0]>'Z') )
    ALCSTR_RETURN(AERROR_NONE);
  words=stringNumberOfWord(line);
  if(words==0)
    ALCSTR_RETURN(AERROR_NONE);
  key=alcstrWord(line,0);

  /* -------------------------------------------------- */
  /* ==================== VXe ==================== */
  /* -------------------------------------------------- */
  /* t@Cǂݍ */
  KEYCHECK("FILE",2,2)
    {
      CmdFile(alcstrWord(line,1));
      ALCSTR_RETURN(AERROR_NONE);
    }
  /* [Ul[ */
  KEYCHECK("USERNAME",2,2)
    {
      alcstrUpdate(&Username,alcstrWord(line,1));
      ALCSTR_RETURN(AERROR_NONE);
    }
 /* Al[ */
  KEYCHECK("REALNAME",2,2)
    {
      alcstrUpdate(&Realname,alcstrWord(line,1));
      ALCSTR_RETURN(AERROR_NONE);
    }
  /* jbNl[ */
  KEYCHECK("NICKNAME",2,256)
    {
      int i;
      /* ܂ł̂폜 */
      CPLISTLOOP_BEGIN(cp,const char,StartNick)
	{
	  cplistDeleteItem(&StartNick,cp);
	  alcstrDestroy(cp);
	}
      CPLISTLOOP_END;
      /* Xgɒǉ */
      for(i=1;i<words;i++)
	{
	  cplistAddItem(&StartNick,alcstrSet(alcstrWord(line,i)));
	}
      ALCSTR_RETURN(AERROR_NONE);
    }
  /* NCAgҋ@|[g */
  KEYCHECK("LISTENPORT",2,2)
    {
      int port;
      port=atoi(alcstrWord(line,1));
      if(port<0 || port>65535)
	{
	  messageF("Illegal port number:$PORT",
		   "PORT",ASFORMAT_INT,port,
		   NULL);
	  ALCSTR_RETURN(AERROR_NONE);
	}
      if(port!=ListenPort)
	{
	  ListenPort=port;
	  ListenStart();
	}
      ALCSTR_RETURN(AERROR_NONE);
    }
  /* pX[h */
  KEYCHECK("PASSWORD",2,2)
    {
      alcstrUpdate(&Password,alcstrWord(line,1));
      ALCSTR_RETURN(AERROR_NONE);
    }

  /* -------------------------------------------------- */
  /* ================== f[^Xg ================== */
  /* -------------------------------------------------- */
  KEYCHECK("LIST",2,2)
    {
      ALCSTR tmp;
      tmp=alcstrWord(line,1);

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ------------- lbg[N ------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      if(stringCmp(tmp,"NETWORK"))
	{
	  ALCSTR msg;
	  message("Network list");

	  PLISTLOOP_BEGIN(np,NETWORK,Network)
	    {
	      msg=alcstrCopy(np->name);
	      /* T[oꗗ */
	      if(np->server!=NULL)
		{
		  realcstrConcatenate(&msg," Server:");
		  PLISTLOOP_BEGIN(sp,SERVER,np->server)
		    {
		      if(sp!=np->server->item)
			realcstrConcatenate(&msg,",");
		      realcstrConcatenate(&msg,sp->name);
		    }
		  PLISTLOOP_END;
		}
	      /* M */
	      message(msg);
	    }
	  PLISTLOOP_END;

	  message("End of list");
	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ---------------- T[o ---------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      if(stringCmp(tmp,"SERVER"))
	{
	  ALCSTR msg;
	  message("Server list");

	  PLISTLOOP_BEGIN(sp,SERVER,Server)
	    {
	      msg=alcstrFormat("$SERVER $ADDRESS:$PORT",
			       "SERVER", ASFORMAT_STRING,sp->name,
			       "ADDRESS",ASFORMAT_STRING,sp->address,
			       "PORT",   ASFORMAT_INT   ,sp->port,
			       NULL);
	      /* pX[h */
	      if(sp->password!=NULL)
		{
		  realcstrConcatenate(&msg," Password:");
		  realcstrConcatenate(&msg,sp->password);
		}
	      /* lbg[N */
	      if(sp->network!=NULL)
		{
		  realcstrConcatenate(&msg," Network:");
		  realcstrConcatenate(&msg,sp->network->name);
		}
	      /* RlNV */
	      if(sp->connection!=NULL)
		{
		  realcstrConcatenate(&msg," Connection:");
		  PLISTLOOP_BEGIN(cnp,CONNECTION,sp->connection)
		    {
		      if(cnp!=sp->connection->item)
			realcstrConcatenate(&msg,",");
		      realcstrConcatenate(&msg,cnp->name);
		    }
		  PLISTLOOP_END;
		}
	      /* M */
	      message(msg);
	    }
	  PLISTLOOP_END;
	  message("End of list");
	  ALCSTR_RETURN(AERROR_NONE);
	}
    
      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ------------- RlNV ------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      if(stringCmp(tmp,"CONNECTION"))
	{
	  ALCSTR msg;
	  message("Connection list");

	  PLISTLOOP_BEGIN(cnp,CONNECTION,Connection)
	    {
	      msg=alcstrCopy(cnp->name);
	      if(cnp==MainConnection) realcstrConcatenate(&msg,"(main)");
	      /* T[o */
	      realcstrConcatenate(&msg," Server:");
	      realcstrConcatenate(&msg,cnp->server->name);
	      if(cnp->flags&CNFLAG_SPECIFYSERVER)
		realcstrConcatenate(&msg,"(Specifoed)");
	      if(cnp->bufsock!=NULL)
		{
		  /* ̃jbN */
		  if(cnp->myself!=NULL)
		    {
		      realcstrConcatenateF(&msg," Nickname:$NICKNAME",
					   "NICKNAME",ASFORMAT_STRING,
					   cnp->myself->nick,
					   NULL);
		    }
		  /* `l */
		  realcstrConcatenate(&msg," Channel:");
		  PLISTLOOP_BEGIN(chp,CHANNEL,cnp->channel)
		    {
		      if(chp!=cnp->channel->item)
			realcstrConcatenate(&msg,",");
		      realcstrConcatenate(&msg,chp->name);
		    }
		  PLISTLOOP_END;
		}
	      /* M */
	      message(msg);
	    }
	  PLISTLOOP_END;
	  message("End of list");
	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ------------- NCAg ------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      if(stringCmp(tmp,"CLIENT"))
	{
	  ALCSTR msg;
	  message("Client list");

	  PLISTLOOP_BEGIN(clp,CLIENT,Client)
	    {
	      if(clp->name!=NULL)
		  msg=alcstrCopy(clp->name);
	      else
		msg=alcstrFormat("fd:$FD",
				 "FD",ASFORMAT_INT,bufsockGetFD(clp->bufsock),
				 NULL);
	      if(clp==replyTarget)
		realcstrConcatenate(&msg,"(you)");
	      /* ڑ */
	      realcstrConcatenateF(&msg," from:$ADDRESS:$PORT",
				   "ADDRESS",ASFORMAT_STRING,
				   bufsockGetAddress(clp->bufsock),
				   "PORT",ASFORMAT_INT,
				   bufsockGetPort(clp->bufsock),
				   NULL);
	      /* `l */
	      if(clp->channel!=NULL)
		{
		  realcstrConcatenate(&msg," Channel:");
		  PLISTLOOP_BEGIN(chp,CHANNEL,clp->channel)
		    {
		      if(chp!=clp->channel->item)
			realcstrConcatenate(&msg,",");
		      realcstrConcatenate(&msg,ChannelGetName(chp));
		    }
		  PLISTLOOP_END;
		}
	      /* NGXg`l */
	      if(clp->joinRequest!=NULL)
		{
		  realcstrConcatenate(&msg," JoinRequest:");
		  PLISTLOOP_BEGIN(rp,JOINREQ,clp->joinRequest)
		    {
		      if(rp!=clp->joinRequest->item)
			realcstrConcatenate(&msg,",");
		      realcstrConcatenateF(&msg,"$CHANNEL($SERVER)",
					   "CHANNEL",ASFORMAT_STRING,
					   rp->channelName,
					   "SERVER", ASFORMAT_STRING,
					   (rp->network!=NULL)
					   ?rp->network->name:rp->server->name,
					   NULL);
		    }
		  PLISTLOOP_END;
		}
	      /* M */
	      message(msg);
	    }
	  PLISTLOOP_END;
	  message("End of list");
	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* -------------- vOC -------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      if(stringCmp(tmp,"PLUGIN"))
	{
	  message("Plugin list");

	  PLISTLOOP_BEGIN(pp,PLUGIN,Plugin)
	    {
	      messageF("$NAME library:$LIBRARY",
		       "NAME"   ,ASFORMAT_STRING,pp->name,
		       "LIBRARY",ASFORMAT_STRING,pp->library,
		       NULL);
	    }
	  PLISTLOOP_END;
	  message("End of list");
	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* --------------- ȊO --------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      messageF("Unknown keyword $STRING",
	       "STRING",ASFORMAT_STRING,tmp,
	       NULL);
      ALCSTR_RETURN(AERROR_NONE);
    }

  /* -------------------------------------------------- */
  /* ============ NCAg̃ftHg ============ */
  /* -------------------------------------------------- */
  KEYCHECK("CLIENTDEFAULT",2,256)
    {
      int i;
      for(i=1;i<words;i++)
	{
	  ALCSTR key;
	  int plus;
	  key=alcstrWord(line,i);
	  /* vX}CiX */
	  plus=(key[0]!='-');
	  if(key[0]=='-' || key[0]=='+')
	    realcstrMiddle(&key,1,-1);
	  /* S`l[h */
	  if(stringCmp(key,"ALLCHANNEL"))
	    {
	      if(plus)
		DefaultClientFlags|= CLFLAG_ALLCHANNEL;
	      else
		DefaultClientFlags&=~CLFLAG_ALLCHANNEL;
	      continue;
	    }
	  /* ՂԖ */
	  if(stringCmp(key,"IGNOREPRIV"))
	    {
	      if(plus)
		DefaultClientFlags|= CLFLAG_IGNOREPRIV;
	      else
		DefaultClientFlags&=~CLFLAG_IGNOREPRIV;
	      continue;
	    }
	  /* ̑ */
	  messageF("Unknown keyword $STRING",
		   "STRING",ASFORMAT_STRING,key,
		   NULL);
	}
      ALCSTR_RETURN(AERROR_NONE);
    }

  /* -------------------------------------------------- */
  /* ============ RlNṼftHg ============ */
  /* -------------------------------------------------- */
  KEYCHECK("CONNECTIONDEFAULT",2,256)
    {
      int i;
      for(i=1; i<words; i++)
	{
	  ALCSTR key;
	  int plus;
	  key=alcstrWord(line,i);
	  /* vX}CiX */
	  plus=(key[0]!='-');
	  if(key[0]=='-' || key[0]=='+')
	    realcstrMiddle(&key,1,-1);
	  /* ڑ */
	  if(stringCmp(key,"AUTOCONNECT"))
	    {
	      if(plus)
		DefaultConnectionFlags|= CNFLAG_AUTOCONNECT;
	      else
		DefaultConnectionFlags&=~CNFLAG_AUTOCONNECT;
	      continue;
	    }
	  /* JOIN(LbN) */
	  if(stringCmp(key,"AUTOREJOIN"))
	    {
	      if(plus)
		DefaultConnectionFlags|= CNFLAG_AUTOREJOIN;
	      else
		DefaultConnectionFlags&=~CNFLAG_AUTOREJOIN;
	      continue;
	    }
	  /* ̑ */
	  messageF("Unknown keyword $STRING",
		   "STRING",ASFORMAT_STRING,key,
		   NULL);
	}
      ALCSTR_RETURN(AERROR_NONE);
    }

  /* ------------------------------------------------------------ */
  /* ============================================================ */
  /* ####################### lbg[N ####################### */
  /* ============================================================ */
  /* ------------------------------------------------------------ */

  /* -------------------------------------------------- */
  /* ============= lbg[NXV ============= */
  /* -------------------------------------------------- */
  KEYCHECK("NETWORK",2,256)
    {
      NETWORK *np;
      SERVER *sp;
      ALCSTR tmp;
      int i,j;

      /* lbg[N쐬 */
      if(!nameCheck(tmp=alcstrWord(line,1),NAMECHECK_NETWORK))
	{
	  ALCSTR_RETURN(AERROR_NONE);
	}
      if((np=NetworkGet(tmp))==NULL)
	{
	  if((np=NetworkCreate(tmp))==NULL)
	    {
	      messageF("Couldn't create network `$STRING'",
		       "STRING",ASFORMAT_STRING,tmp,
		       NULL);
	      ALCSTR_RETURN(AERROR_NONE);
	    }
	}

      /* XgɎw肳ꂽT[oǉ */
      for(i=2; (tmp=alcstrWord(line,i))!=NULL; i++)
	{
	  if((sp=ServerGet(tmp))==NULL)
	    {
	      messageF("No such server `$STRING'",
		       "STRING",ASFORMAT_STRING,tmp,
		       NULL);
	      continue;
	    }
	  /* ύXȂ */
	  if(sp->network==np)
	    ALCSTR_RETURN(AERROR_NONE);
	  /* ʂ̃lbg[NɏĂꍇ */
	  if(sp->network!=NULL)
	    ServerResetNetwork(sp);
	  /* ǂ̃lbg[NɂĂȂꍇ */
	  ServerSetNetwork(sp,np);

	  alcstrDestroy(tmp);
	}

      /* XgɎw肳ĂȂT[o폜 */
      PLISTLOOP_BEGIN(sp,SERVER,np->server)
	{
	  /* T[o */
	  for(j=2; (tmp=alcstrWord(line,j))!=NULL; j++)
	    {
	      if(stringCmp(tmp,sp->name)) break;
	      alcstrDestroy(tmp);
	    }
	  /* Ȃc */
	  if(j==words)
	    ServerResetNetwork(sp);
	}
      PLISTLOOP_END;
      ALCSTR_RETURN(AERROR_NONE);
    }

  /* -------------------------------------------------- */
  /* ================ lbg[N ================ */
  /* -------------------------------------------------- */
  do
    {
      NETWORK *np;
      if((np=NetworkGet(key))==NULL)
	break;
      if(words==1)
	ERR_NOTENOUGH;
      key=alcstrWord(line,1);

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ----------------- j ----------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      KEYCHECK("DESTROY",2,2)
	{
	  NetworkDestroy(np);
	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* --------------- ȊO --------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      messageF("Unknown keyword $STRING",
	       "STRING",ASFORMAT_STRING,key,
	       NULL);
      ALCSTR_RETURN(AERROR_NONE);
    }
  while(0);

  /* ------------------------------------------------------------ */
  /* ============================================================ */
  /* ########################## T[o ########################## */
  /* ============================================================ */
  /* ------------------------------------------------------------ */

  /* -------------------------------------------------- */
  /* ================ T[oXV ================ */
  /* -------------------------------------------------- */
  KEYCHECK("SERVER",3,5)
    {
      SERVER *sp;
      ALCSTR name,addr,tmp,pass;
      int port;

      if(!nameCheck(name=alcstrWord(line,1),NAMECHECK_SERVER))
	ALCSTR_RETURN(AERROR_NONE);
      addr=alcstrWord(line,2);
      port=((tmp=alcstrWord(line,3))==NULL)?6667:atoi(tmp);
      pass=alcstrWord(line,4);

      /* T[oȂꍇ͐VK쐬 */
      sp=ServerGet(name);
      if(sp==NULL)
	{
	  sp=ServerCreate(name);
	  if(sp==NULL)
	    {
	      messageF("Couldn't create server `$STRING'",
		       "STRING",ASFORMAT_STRING,name,
		       NULL);
	      ALCSTR_RETURN(AERROR_NONE);
	    }
	}
      /* T[o̐ݒύX */
      ServerSet(sp,addr,port,pass);

      ALCSTR_RETURN(AERROR_NONE);
    }

  /* -------------------------------------------------- */
  /* =================== T[o =================== */
  /* -------------------------------------------------- */
  do
    {
      SERVER *sp;
      if((sp=ServerGet(key))==NULL)
	break;
      if(words==1)
	ERR_NOTENOUGH;
      key=alcstrWord(line,1);

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ----------------- j ----------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      KEYCHECK("DESTROY",2,2)
	{
	  ServerDestroy(sp);
	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* --------------- ȊO --------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      messageF("Unknown keyword $STRING",
	       "STRING",ASFORMAT_STRING,key,
	       NULL);
      ALCSTR_RETURN(AERROR_NONE);
    }
  while(0);

  /* ------------------------------------------------------------ */
  /* ============================================================ */
  /* ####################### RlNV ####################### */
  /* ============================================================ */
  /* ------------------------------------------------------------ */

  /* -------------------------------------------------- */
  /* ============ RlNV̐XV ============ */
  /* -------------------------------------------------- */
  KEYCHECK("CONNECTION",3,256)
    {
      ALCSTR name,tmp;
      NETWORK *np;
      SERVER  *sp;
      CONNECTION *cnp;

      if(!nameCheck(name=alcstrWord(line,1),NAMECHECK_CONNECTION))
	{
	  ALCSTR_RETURN(AERROR_NONE);
	}
      tmp =alcstrWord(line,2);
      cnp=ConnectionGet(name);
      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ---------- lbg[NŎw ---------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      np=NetworkGet(tmp);
      if(np!=NULL)
	{
	  /* ŏ̃T[o擾 */
	  if((sp=plistGetItem(np->server,0))==NULL)
	    {
	      messageF("Network($NETWORK) has no server",
		       "NETWORK",ASFORMAT_STRING,np->name,
		       NULL);
	      ALCSTR_RETURN(AERROR_NONE);
	    }
	  /* ڑf[^ǉ */
	  if(cnp==NULL)
	    cnp=ConnectionCreate(name);
	  ConnectionSetNetwork(cnp,np);
	}
      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ------------- T[oŎw ------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      else
	{
	  sp=ServerGet(tmp);
	  if(sp!=NULL)
	    {
	      if(cnp==NULL)
		cnp=ConnectionCreate(name);
	      ConnectionSetServer(cnp,sp);
	    }
	  /* tȂꍇ */
	  else
	    {
	      messageF("No such network or server `$STRING'",
		       "STRING",ASFORMAT_STRING,tmp,
		       NULL);
	      ALCSTR_RETURN(AERROR_NONE);
	    }
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ------------ ێ`l ------------ */
      /* PPPPPPPPPPPPPPPPPPPP */
      {
	int i;
	ConnectionClearKpchannel(cnp);
	for(i=3;i<words;i++)
	  ConnectionAddKpchannel(cnp,alcstrWord(line,i));
      }
      ALCSTR_RETURN(AERROR_NONE);
    }

  /* -------------------------------------------------- */
  /* ================ RlNV ================ */
  /* -------------------------------------------------- */
  do
    {
      CONNECTION *cnp;
      cnp=ConnectionGet(key);
      if(cnp==NULL)
	break;
      if(words==1)
	ERR_NOTENOUGH;
      key=alcstrWord(line,1);

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ----------------- ڑ ----------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      KEYCHECK("OPEN",2,2)
	{
	  if(cnp->bufsock!=NULL)
	    {
	      messageF("Connection($CONNECTION) has already opened.",
		       "CONNECTION",ASFORMAT_STRING,cnp->name,
		       NULL);
	    }
	  else
	    ConnectionOpen(cnp);

	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ----------------- ؒf ----------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      KEYCHECK("CLOSE",2,2)
	{
	  if(cnp->bufsock==NULL)
	    {
	      messageF("Connection($CONNECTION) has already closed.",
		       "CONNECTION",ASFORMAT_STRING,cnp->name,
		       NULL);
	    }
	  else
	    ConnectionClose(cnp);

	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ----------------- PART ----------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      KEYCHECK("PART",3,4)
	{
	  ALCSTR cname,msg;
	  cname=alcstrWord(line,2);

	  msg=alcstrWord(line,3);
	  if(msg!=NULL)
	    /* PARTbZ[Wt̏ꍇ */
	    ConnectionSendMessageF(cnp,"PART $CHANNEL :$MESSAGE",
				   "CHANNEL",ASFORMAT_STRING,cname,
				   "MESSAGE",ASFORMAT_STRING,msg,
				   NULL);
	  else
	    /* PARTbZ[WȂ̏ꍇ */
	    ConnectionSendMessageF(cnp,"PART $CHANNEL",
				   "CHANNEL",ASFORMAT_STRING,cname,
				   NULL);

	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* --------------- R}h --------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      if(stringCmp(key,"CMD" ))	alcstrUpdate(&key,"COMMAND");
      if(stringCmp(key,"SEND")) alcstrUpdate(&key,"COMMAND");
      KEYCHECK("COMMAND",3,3)
	{
	  ALCSTR cmd;
	  cmd=alcstrWord(line,2);
	  ConnectionSendMessage(cnp,cmd);
	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ----------------- j ----------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      KEYCHECK("DESTROY",2,3)
	{
	  if(cnp->bufsock!=NULL)
	    {
	      ALCSTR msg;
	      msg=alcstrWord(line,2);
	      if(msg!=NULL)
		/* QUITbZ[Wt */
		ConnectionSendMessageF(cnp,"QUIT :MESSAGE",
				       "MESSAGE",ASFORMAT_STRING,msg,
				       NULL);
	      else
		/* QUITbZ[WȂ */
		ConnectionSendMessage(cnp,"QUIT");
	    }
	  ConnectionDestroy(cnp);
	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* --------------- ȊO --------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      messageF("Unknown keyword $STRING",
	       "STRING",ASFORMAT_STRING,key,
	       NULL);
      ALCSTR_RETURN(AERROR_NONE);
    }
  while(0);

  /* ------------------------------------------------------------ */
  /* ============================================================ */
  /* ######################## vOC ######################## */
  /* ============================================================ */
  /* ------------------------------------------------------------ */

  /* -------------------------------------------------- */
  /* ============= vOC̐Ɣj ============= */
  /* -------------------------------------------------- */
  KEYCHECK("PLUGIN",3,3)
    {
      PLUGIN *pp;
      ALCSTR name,lib;
      name=alcstrWord(line,1);
      lib =alcstrWord(line,2);

      /*  */
      pp=PluginGet(name);
      if(pp==NULL)
	pp=PluginCreate(name);
      /* CuJ */
      if(!PluginOpenLibrary(pp,lib))
	/* s */
	{
	  messageF("Plugin-Module($MODULE) couldn't opened.",
		   "MODULE", ASFORMAT_STRING, lib,
		   NULL);
	  PluginDestroy(pp);
	}

      ALCSTR_RETURN(AERROR_NONE);
    }

  /* -------------------------------------------------- */
  /* ================= vOC ================= */
  /* -------------------------------------------------- */
  do
    {
      PLUGIN *pp;
      pp=PluginGet(key);
      if(pp==NULL) break;
      if(words==1)
	ERR_NOTENOUGH;
      key=alcstrWord(line,1);

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ---------- vOCł̏ ---------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      if(pp->command!=NULL)
	/* R}h͊֐ĂΓKp */
	{
	  int result;
	  CPLIST *msgs;

	  /* 2߂̒P̐擪ʒu擾 */
	  int i;
	  for(i=0; ISSPACE   (line[i]); i++);
	  for(   ; ISWORDCHAR(line[i]); i++);
	  for(   ; ISSPACE   (line[i]); i++);

	  /* R}hs */
	  PluginSetProcessing(pp,1);
	  result=pp->command(line+i);
	  msgs=PluginResetProcessing();

	  /* bZ[Wo */
	  while(msgs!=NULL)
	    {
	      ALCSTR msg;
	      msg=cplistGetItem(msgs,0);
	      messageF("$PLUGIN: $MESSAGE",
		       "PLUGIN", ASFORMAT_STRING, pp->name,
		       "MESSAGE",ASFORMAT_STRING, msg,
		       NULL);
	      cplistDeleteItem(&msgs,msg);
	      alcstrDestroy(msg);
	    }

	  /* ͐ */
	  if(result) ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ----------------- j ----------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      KEYCHECK("DESTROY",2,2)
	{
	  PluginDestroy(pp);
	  ALCSTR_RETURN(AERROR_NONE);
	}

      messageF("Unknown keyword $STRING",
	       "STRING",ASFORMAT_STRING,key,
	       NULL);
      ALCSTR_RETURN(AERROR_NONE);
    }
  while(0);

  /* ------------------------------------------------------------ */
  /* ============================================================ */
  /* ####################### NCAg ####################### */
  /* ============================================================ */
  /* ------------------------------------------------------------ */

  /* -------------------------------------------------- */
  /* ================ NCAg ================ */
  /* -------------------------------------------------- */
  do
    {
      CLIENT *clp;
      clp=ClientGet(key);
      if(clp!=NULL)
	/* NCAgȗ^Ɠ\ɂׂ2߂̒Pꂩ̕
	   ɂB */
	{
	  for(;ISSPACE   (*line);line++);
	  for(;ISWORDCHAR(*line);line++);
	  for(;ISSPACE   (*line);line++);
	  words--;
	}
      else
	/* ܂܂ł̃L[[hɓĂ͂܂炸ɃNCAgłȂ΁A
	   NCAgȗ^ƔfB */
	{
	  clp=replyTarget;
	  if(clp==NULL) break;
	}

      if(words==1)
	ERR_NOTENOUGH;
      key=alcstrWord(line,0);

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ---------- `lON/OFF ---------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      KEYCHECK("CHANNEL",2,256)
	{
	  int i;
	  ALCSTR arg;

	  /* `lON/OFF */
	  for(i=1; i<words; i++)
	    {
	      int chon,offset;
	      CHANNEL *chp;

	      arg=alcstrWord(line,i);
	      chon=(arg[0]!='-');
	      offset=(arg[0]=='+' || arg[0]=='-');

	      /* S`l */
	      if(stringCmp(arg+offset,"ALL"))
		{
		  int i;
		  for(i=0;(chp=plistGetItem(Channel,i))!=NULL;i++)
		    {
		      if(chon)
			{
			  if(!ClientIsJoinChannel(clp,chp))
			    CmdOn(clp,chp);
			}
		      else
			{
			  if(ClientIsJoinChannel(clp,chp))
			    CmdOff(clp,chp);
			}
		    }
		}
	      /* `lw */
	      else
		{
		  GETCHANNELST(chp,arg+offset);
		  if(chon)
		    CmdOn(clp,chp);
		  else
		    CmdOff(clp,chp);
		}
	    }
	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ---------- `lON/OFF ---------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      KEYCHECK("ALLCHANNEL",1,2)
	{
	  /* \ */
	  if(words==1)
	    {
	      messageF("Client($CLIENT) allchannel-mode $STATUS",
		       "CLIENT",ASFORMAT_STRING,clp->name,
		       "STATUS",ASFORMAT_STRING,
		       (clp->flags&CLFLAG_ALLCHANNEL)?"On":"Off",
		       NULL);
	      ALCSTR_RETURN(AERROR_NONE);
	    }
	  /* ݒ */
	  else
	    {
	      ALCSTR mode;
	      mode=alcstrWord(line,1);
	      /* S`l[hݒ */
	      if(stringCmp(mode,"ON"))
		{
		  clp->flags|=CLFLAG_ALLCHANNEL;
		  PLISTCHANNELLOOP_BEGIN(chp)
		    {
		      if(!ClientIsJoinChannel(clp,chp))
			CmdOn(clp,chp);
		    }
		  PLISTLOOP_END;
		  ALCSTR_RETURN(AERROR_NONE);
		}
	      /* S`l[hݒ */
	      if(stringCmp(mode,"OFF"))
		{
		  clp->flags&=~CLFLAG_ALLCHANNEL;
		  ALCSTR_RETURN(AERROR_NONE);
		}
	      /* G[ */
	      messageF("Unknown keyword $STRING",
		       "STRING",ASFORMAT_STRING,mode,
		       NULL);
	    }
	  ALCSTR_RETURN(AERROR_NONE);
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* ----------------- j ----------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      if(stringCmp(key,"CLOSE"))
	key=alcstrCopy("DESTROY");

      KEYCHECK("DESTROY",1,1)
	{
	  if(clp==replyTarget)
	    {
	      ClientDestroy(clp);
	      replyTarget=NULL;
	      ALCSTR_RETURN(AERROR_CLOSED);
	    }
	  else
	    {
	      ClientDestroy(clp);
	      ALCSTR_RETURN(AERROR_NONE);
	    }
	}

      /* QQQQQQQQQQQQQQQQQQQQ */
      /* --------------- ȊO --------------- */
      /* PPPPPPPPPPPPPPPPPPPP */
      messageF("Unknown keyword $STRING",
	       "STRING",ASFORMAT_STRING,key,
	       NULL);
      ALCSTR_RETURN(AERROR_NONE);
    }
  while(0);

  messageF("Unknown keyword $STRING",
	   "STRING",ASFORMAT_STRING,key,
	   NULL);
  ALCSTR_END;
  return AERROR_NONE;
}
