/*
 * client.c
 *
 * CLIENTf[^̎MNCAg̃bZ[W̏B
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#include "bufsock.h"
#include "string.h"
#include "plist.h"

#include "achat.h"

#define MARG_END      0x000
#define MARG_CHANNEL  0x001
#define MARG_NICK     0x002
#define MARG_OTHER    0x003
#define MARG_OMITABLE 0x100


/*  */
/*  */
/* bb                                                  bb */
/* bb              bZ[Wp}N              bb */
/* bb                                                  bb */
/*  */
/*  */

#define SPECIFYCONNECTION(cnp,ret,name) \
if(((cnp)=ConnectionGetByName(&(ret),(name),				\
			      MainConnection))==NULL){			\
  ClientSendNoticeF((clp),"Couldn't specify connection by `$STRING'",	\
		    "STRING",ASFORMAT_STRING,(name),			\
		    NULL);						\
  return 1;								\
}

#define GETPARAMETER(cmd,ret,wordNo) \
if((ret=alcstrWord((line),(wordNo)))==NULL){				\
  ClientSendNoticeF((clp),"Not enough parameters ($COMMAND)",		\
		    "COMMAND",ASFORMAT_STRING,(cmd),			\
		    NULL);						\
  return 1;								\
}

#define GETCHANNEL(cmd,chp,wordNo) { \
  ALCSTR tmp,chnl;							\
  CONNECTION *cnp;							\
  GETPARAMETER((cmd),tmp,(wordNo));					\
  SPECIFYCONNECTION(cnp,chnl,tmp);					\
  if((chp=ChannelGet(cnp,chnl))==NULL){					\
    ClientSendNoticeF((clp),"No such channnel($CHANNEL) on"		\
		      " connection($CONNECTION)",			\
	              "CHANNEL",   ASFORMAT_STRING,chnl,		\
		      "CONNECTION",ASFORMAT_STRING,cnp->name,		\
		      NULL);						\
    return 1;								\
  }									\
}

/*  */
/*  */
/* bb                                                  bb */
/* bb        o^NCAg̃bZ[W        bb */
/* bb                                                  bb */
/*  */
/*  */
static int
unregisteredClientProcessLine(CLIENT *clp,const char *line)
{
  int checkUpdate=0;
  ALCSTR cmd;

  /* R}h擾 */
  cmd=alcstrWord(line,0);
  if( cmd == NULL )
    return 1;

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ------------ PASSbZ[W ------------ */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(stringCmp(cmd,"PASS"))
    {
      ALCSTR pass;
      if(Password==NULL)
	return 1;
      /* pX[h`FbN */
      if((pass=alcstrWord(line,1))==NULL)
	return 1;
      if(strcmp(pass,Password)!=0)
	return 1;
      /* Ok */
      clp->check|=CLIENT_CHECK_PASS;
      checkUpdate=1;
    }
  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ------------ NICKbZ[W ------------ */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(stringCmp(cmd,"NICK"))
    {
      ALCSTR nick;
      nick=alcstrWord(line,1);
      if(nick==NULL) return 1;
      /* ɎgĂNCAgH */
      {
	CLIENT *nclp;
	nclp=ClientGet(nick);
	if(nclp!=NULL && nclp!=clp)
	  {
	    ClientSendMessageF(clp,":$SERVER 433 * $NICKNAME "
			       ":Nickname is already in use.",
			       "SERVER",  ASFORMAT_STRING,Hostname,
			       "NICKNAME",ASFORMAT_STRING,nclp->name,
			       NULL);
	    return 1;
	  }
      }
      /* Ok */
      if(clp->name!=NULL)
	alcstrDestroy(clp->name);
      alcstrUpdate(&clp->name,nick);
      clp->check|=CLIENT_CHECK_NICK;
      checkUpdate=1;
    }
  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ------------ USERbZ[W ------------ */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(stringCmp(cmd,"USER"))
    {
      clp->check|=CLIENT_CHECK_USER;
      checkUpdate=1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* --------- ȊÕbZ[W --------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(!checkUpdate)
    {
      ClientSendMessageF(clp,":$SERVER 451 * :You have not registered",
			 "SERVER",ASFORMAT_STRING,Hostname,
			 NULL);
      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ----------- pX[hG[ ----------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(clp->check==(CLIENT_CHECK_NICK+CLIENT_CHECK_USER))
    {
      /* G[bZ[W */
      ClientSendMessageF(clp,":$SERVER 464 * :Password Incorrect",
			 "SERVER",ASFORMAT_STRING,Hostname,
			 NULL);
      ClientSendMessage(clp,"ERROR :Closing Link: * (Bad Password)");
      /* j */
      ClientDestroy(clp);
      return 0;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ----------------- o^ ----------------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(clp->check==CLIENT_CHECK_ALLRIGHT)
    {
      /* ڑo^bZ[W */
      ClientSendMessageF(clp,":$SERVER 001 $NICKNAME "
			 ":Welcome to the Internet Relay Network "
			 "$NICKNAME!$USERNAME@$ADDRESS",
			 "SERVER"  ,ASFORMAT_STRING,Hostname,
			 "NICKNAME",ASFORMAT_STRING,clp->name,
			 "USERNAME",ASFORMAT_STRING,Username,
			 "Address" ,ASFORMAT_STRING,Hostname,
			 NULL);
      ClientSendMessageF(clp,":$SERVER 002 $NICKNAME :Your host is $SERVER, "
			 "running version $VERSION",
			 "SERVER"  ,ASFORMAT_STRING,Hostname,
			 "NICKNAME",ASFORMAT_STRING,clp->name,
			 "VERSION" ,ASFORMAT_STRING,Version,
			 NULL);
      ClientSendMessageF(clp,":$SERVER 003 $NICKNAME :"
			 "This server was created $STARTTIME",
			 "SERVER",   ASFORMAT_STRING,Hostname,
			 "NICKNAME", ASFORMAT_STRING,clp->name,
			 "STARTTIME",ASFORMAT_STRING,stringTime(&StartTime),
			 NULL);
      ClientSendMessageF(clp,":$SERVER 004 $NICKNAME $SERVER,$VERSION",
			 "SERVER"  ,ASFORMAT_STRING,Hostname,
			 "NICKNAME",ASFORMAT_STRING,clp->name,
			 "VERSION" ,ASFORMAT_STRING,Version,
			 NULL);

      /* jbNݒ */
      ClientSendMessageF(clp,":$CLIENT!$USERNAME@$ADDRESS NICK :$NICKNAME",
			 "CLIENT",  ASFORMAT_STRING,clp->name,
			 "USERNAME",ASFORMAT_STRING,Username,
			 "ADDRESS", ASFORMAT_STRING,Hostname,
			 "NICKNAME",ASFORMAT_STRING,Nickname,
			 NULL);

      /* NCAgo^bZ[W */
      ALCSTR_BEGIN
	{
	  SystemMessageF(SYSMSG_CLIENT,"Client($ADDRESS:$PORT) "
			 "registered(name:$CLIENT)",
			 "ADDRESS",ASFORMAT_STRING,
			 ( bufsockGetAddress(clp->bufsock) ),
			 "PORT",   ASFORMAT_INT,
			 ( bufsockGetPort(clp->bufsock) ),
			 "CLIENT", ASFORMAT_STRING,clp->name,
			 NULL);
	}
      ALCSTR_END;

      /* S`l[hȂS`lL */
      if(clp->flags&CLFLAG_ALLCHANNEL)
	PLISTCHANNELLOOP_BEGIN(chp)
	{
	  CmdOn(clp,chp);
	}
      PLISTLOOP_END;
    }

  return 1;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb              ʏ̃bZ[W̏              bb */
/* bb                                                  bb */
/*  */
/*  */
static int
processIRCCommand(CLIENT *clp,const char *line)
{
  ALCSTR cmd;
  cmd=alcstrWord(line,0);
  if(cmd==NULL)
    return 1;

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* -------------- PING/PONG  -------------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  /* PINGւ̉ */
  if(stringCmp(cmd,"PING"))
    {
      ClientSendMessageF(clp,":$SERVER PONG $SERVER :$NICKNAME",
			 "SERVER",  ASFORMAT_STRING,Hostname,
			 "NICKNAME",ASFORMAT_STRING,Nickname,
			 NULL);
      return 1;
    }

  /* PONG͓ǂݎ̂(bZ[W󂯎_ŁA݊mFĂ邩) */
  if(stringCmp(cmd,"PONG"))
    return 1;

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ----------------- JOIN ----------------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(stringCmp(cmd,"JOIN"))
    {
      ALCSTR chnl,tmp;
      CHANNEL *chp;
      CONNECTION *cnp;
      GETPARAMETER("JOIN",tmp,1);
      SPECIFYCONNECTION(cnp,chnl,tmp);
      /* JOINĂ`lȗLɂ */
      chp=ChannelGet(cnp,chnl);
      if(chp!=NULL)
	CmdOn(clp,chp);
      /* łȂJOINbZ[W𑗂 */
      else
	{
	  ALCSTR keyword;
	  /* L[[ht */
	  keyword=alcstrWord(line,2);
	  if( keyword != NULL )
	    {
	      ConnectionSendMessageF(cnp,"JOIN $CHANNEL :$KEYWORD",
				     "CHANNEL",ASFORMAT_STRING,chnl,
				     "KEYWORD",ASFORMAT_STRING,keyword,
				     NULL);
	    }
	  /* L[[hȂ */
	  else
	    {
	      ConnectionSendMessageF(cnp,"JOIN $CHANNEL",
				     "CHANNEL",ASFORMAT_STRING,chnl,
				     NULL);
	    }
	  /* S`l[hȂ΁AJOINNGXgݒ肷 */
	  if(!(clp->flags&CLFLAG_ALLCHANNEL))
	    {
	      JoinreqCreateByConnection(clp,cnp,chnl);
	    }
	}
      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ----------------- PART ----------------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(stringCmp(cmd,"PART"))
    {
      ALCSTR chnl,tmp,msgtmp;
      CHANNEL *chp;
      CONNECTION *cnp;
      GETPARAMETER("PART",tmp,1);
      SPECIFYCONNECTION(cnp,chnl,tmp);

      /* JOINĂ`lőS`l[hłȂΖ */
      if(!(clp->flags&CLFLAG_ALLCHANNEL) && (chp=ChannelGet(cnp,chnl))!=NULL)
	CmdOff(clp,chp);
      /* łȂPARTbZ[W𑗂 */
      else
	{
	  /* bZ[Wt */
	  msgtmp=alcstrWord(line,2);
	  if(msgtmp!=NULL)
	    {
	    ConnectionSendMessageF(cnp,"PART $CHANNEL :$MESSAGE",
				   "CHANNEL",ASFORMAT_STRING,chnl,
				   "MESSAGE",ASFORMAT_STRING,msgtmp,
				   NULL);
	    }
	  /* bZ[WȂ */
	  else
	    {
	      ConnectionSendMessageF(cnp,"PART $CHANNEL",
				     "CHANNEL",ASFORMAT_STRING,chnl,
				     NULL);
	    }
	}
      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ----------------- NICK ----------------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(stringCmp(cmd,"NICK"))
    {
      ALCSTR nick;
      GETPARAMETER("NICK",nick,1);
      if(CmdNick(nick)!=AERROR_NONE)
	{
	  ClientSendNoticeF(clp,"Couldn't specify connection by `$STRING'",
			    "STRING",ASFORMAT_STRING,nick,
			    NULL);
	}
      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ------------ bZ[WM ------------ */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(stringCmp(cmd,"PRIVMSG") || stringCmp(cmd,"NOTICE"))
    {
      CONNECTION *cnp;
      ALCSTR servTarget,clntTarget,msgTmp;
      clntTarget=alcstrWord(line,1);
      if(clntTarget==NULL)
	return 1;
      SPECIFYCONNECTION(cnp,servTarget,clntTarget);
      /* T[o֑M */
      if((msgTmp=alcstrWord(line,2))==NULL) msgTmp="";
      ConnectionSendMessageF(cnp,"$COMMAND $TARGET :$MESSAGE\r\n",
			     "COMMAND",ASFORMAT_STRING,cmd,
			     "TARGET", ASFORMAT_STRING,servTarget,
			     "MESSAGE",ASFORMAT_STRING,msgTmp,
			     NULL);
      /* NCAg֑M */
      if(msgTmp[0]!=0x01 && !stringCmp(servTarget,Nickname))
	{
	  ALCSTR msg;
	  msg=alcstrFormat(":$NICKNAME!$USERNAME@$ADDRESS "
			   "$COMMAND $TARGET :$MESSAGE",
			   "NICKNAME",ASFORMAT_STRING,Nickname,
			   "USERNAME",ASFORMAT_STRING,Username,
			   "ADDRESS", ASFORMAT_STRING,Hostname,
			   "COMMAND", ASFORMAT_STRING,cmd,
			   "TARGET",  ASFORMAT_STRING,clntTarget,
			   "MESSAGE", ASFORMAT_STRING,msgTmp,
			   NULL);
	  PLISTCLIENTLOOP_BEGIN(tclp)
	    {
	      if(tclp==clp)
		continue;
	      ClientSendMessage(tclp,msg);
	    }
	  PLISTLOOP_END;
	}
      
      return 1;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ----------------- QUIT ----------------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  if(stringCmp(cmd,"QUIT"))
    {
      ClientSendMessageF(clp,":$NICKNAME!$USERNAME@$ADDRESS NICK :$CLIENTNAME",
			 "NICKNAME",  ASFORMAT_STRING,Nickname,
			 "USERNAME",  ASFORMAT_STRING,Username,
			 "ADDRESS",   ASFORMAT_STRING,Hostname,
			 "CLIENTNAME",ASFORMAT_STRING,clp->name,
			 NULL);
      ClientSendMessageF(clp,"ERROR :Closing Link: (close $CLIENTNAME)",
			 "CLIENTNAME",ASFORMAT_STRING,clp->name,
			 NULL);
      ClientDestroy(clp);
      return 0;
    }
  
  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ---------- ̑̃bZ[W ---------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  {
    int i,words;
    CONNECTION *cnp,*sendTo=NULL;
    ALCSTR msg,tmp,tmp2;

    msg=alcstrWord(line,0);
    words=stringNumberOfWord(line);
    for( i=1; (tmp=alcstrWord(line,i))!=NULL; i++ )
      {
	realcstrConcatenate(&msg," ");
	if(i==words-1)
	  realcstrConcatenate(&msg,":");

	/* RlNVʎq̂ */
	cnp=ConnectionGetByName(&tmp2,tmp,NULL);
	if(cnp!=NULL)
	  {
	    /* ̃RlNVw肳Ă */
	    if(sendTo!=NULL && sendTo!=cnp)
	      {
		ClientSendNoticeF(clp,"Which connection?"
				  "($CONNECTION or $CONNECTION)",
				  "CONNECTION1",ASFORMAT_STRING,sendTo->name,
				  "CONNECTION1",ASFORMAT_STRING,cnp->name,
				  NULL);
		return 1;
	      }
	    sendTo=cnp;
	    realcstrConcatenate(&msg,tmp2);
	    alcstrDestroy(tmp2);
	  }
	/* RlNVʎq̂ĂȂ */
	else
	  realcstrConcatenate(&msg,tmp);
	alcstrDestroy(tmp);
      }

    /* ]RlNVłȂꍇ */
    if(sendTo==NULL)
      {
	/* CRlNV]\łΎw肷 */
	if(MainConnection!=NULL)
	  {
	    if(MainConnection->bufsock!=NULL)
	      sendTo=MainConnection;
	  }
	/* ]s\ł΁AG[ */
	if(sendTo==NULL)
	  {
	    ClientSendNotice(clp,"Couldn't specify connection");
	    return 1;
	  }
      }

    ConnectionSendMessage(sendTo,msg);
  }

  return 1;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                 bZ[W̎擾                 bb */
/* bb                                                  bb */
/*  */
/*  */

int
ReadClientMessage(CLIENT *clp)
{
  /* QQQQQQQQQQQQQQQQQQQQ */
  /* ------ ǂݍ񂾃bZ[W̏ ------ */
  /* PPPPPPPPPPPPPPPPPPPP */
  for(;;)
    {
      ALCSTR_BEGIN
	{
	  ALCSTR line;
	  CPLIST *lines;

	  line=bufsockGetLine(clp->bufsock);
	  if(line==NULL)
	    ALCSTR_BREAK;

	  /* s폜ăfobOpo͂ɉ */
	  ALCSTR_BEGIN
	    {
	      ALCSTR dbmsg,target;
	      dbmsg=alcstrDeleteCRLF(line);
	      target=( (clp->name) ? alcstrCopy(clp->name)
		       : alcstrFormat("$ADDRESS:$PORT",
				      "ADDRESS",ASFORMAT_STRING,
				      ( bufsockGetAddress(clp->bufsock) ),
				      "PORT",   ASFORMAT_INT,
				      ( bufsockGetPort(clp->bufsock) ),
				      NULL) );
	      SystemMessageF(SYSMSG_READ_CLIENT,"Read($CLIENT):[$LINE]",
			     "CLIENT",ASFORMAT_STRING,target,
			     "LINE"  ,ASFORMAT_STRING,line,
			     NULL);
	    }
	  ALCSTR_END;

	  /* vOC̃tB^O */
	  if( clp->name )
	    lines=PluginFilterFunction( clp->name, line,
					PLUGIN_FUNCPOS(clientReadFilter) );
	  /* NCAĝĂȂm̓tB^OΏۊO */
	  else
	    {
	      lines=NULL;
	      cplistAddItem( &lines, alcstrCopySet(line) );
	    }

	  while( (line=cplistGetItem(lines,0)) )
	    {
	      /* vOC̃bZ[W */
	      if( clp->name )
		PluginCallFunction( clp->name, line,
				    PLUGIN_FUNCPOS(clientRead) );

	      /* o^σNCAg */
	      if(clp->check==CLIENT_CHECK_ALLRIGHT)
		{
		  /* R}h */
		  if(line[0]=='!')
		    {
		      if(CmdString(line+1)==AERROR_CLOSED)
			ALCSTR_RETURN(0);
		    }
		  /* IRCR}h */
		  else
		    {
		      if(!processIRCCommand(clp,line))
			ALCSTR_RETURN(0);
		    }
		}
	      /* o^NCAg */
	      else
		{
		  if(!unregisteredClientProcessLine(clp,line))
		    ALCSTR_RETURN(0);
		}

	      /* ύs̍폜 */
	      cplistDeleteItem( &lines, line );
	      alcstrDestroy( line );
	    }
	}
      ALCSTR_END;
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* -------------- PING/PONG  -------------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  /* PINGMO */
  if(!(clp->flags&CLFLAG_SENDPING))
    {
      /* 莞Ԉȏo߂PINGM */
      if(clp->update<NowTime-TIME_PINGSEND)
	{
	  ClientSendMessageF(clp,"PING :$NICKNAME",
			     "NICKNAME",ASFORMAT_STRING,Nickname,
			     NULL);
	  clp->flags|=CLFLAG_SENDPING;
	}
    }
  /* PINGMO */
  else
    {
      if(clp->update<NowTime-TIME_PINGSEND-TIME_PINGTIMEOUT)
	{
	  ClientSendMessageF(clp,"ERROR :Closing Link:"
			     " $NICKNAME[$USERNAME@$ADDRESS] (Ping timeout)",
			     "NICKNAME", ASFORMAT_STRING, Nickname,
			     "USERNAME", ASFORMAT_STRING, Username,
			     "ADDRESS",  ASFORMAT_STRING, Hostname,
			     NULL );
	  bufsockFlushWrite(clp->bufsock,0);
	  ClientDestroy(clp);
	  return 0;
	}
    }

  /* QQQQQQQQQQQQQQQQQQQQ */
  /* -------- ݃obt@̏o -------- */
  /* PPPPPPPPPPPPPPPPPPPP */
  bufsockFlushWrite(clp->bufsock,0);

  return 1;
}
