/*
 * smtp.c
 *
 * aCHU^Hat $B$N(B smtp $B%W%i%0%$%s!#(B
 * $BB>%W%i%0%$%s!"%/%i%$%"%s%H$+$i07$($k%a!<%kAw?.5!G=!#(B
 */

#ifdef WIN32
#  include <windows.h>
#else
#  ifdef HAVE_CONFIG_H
#    include "config.h"
#  endif
#  include <stdio.h>
#  include <sys/time.h>
#endif

#include <plist.h>
#include <string.h>
#include <bufsock.h>

#include <plugin.h>

static const PluginCtrl *Ctrl;

/* $B@_Dj9`L\(B */
static ALCSTR ServerAddress=NULL;
static int    ServerPort=  25;
static int    MaxLength=-1;
static ALCSTR SendFrom=NULL;
static ALCSTR SendTo  =NULL;

static PLIST  *SendingData=NULL;	/* $BAw?.Cf%G!<%?(B */
static int     NumSendedDatas=0;
static PLIST  *WaitingData=NULL;	/* $BAw?.BT$A%G!<%?(B */
static CPLIST *AddingData=NULL;		/* $BDI2CCf$N%G!<%?(B */

static ALCSTR Hostname;

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                      $B%G!<%?(B                      $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

/* -------------------------------------------------- */
/* =================== $B%a!<%k(BSMTP =================== */
/* -------------------------------------------------- */
/* $B%a!<%k(BSMTP */
static BUFSOCK Bufsock=NULL;
enum {
  STAT_NOT_CONNECTED,
  STAT_OPEN,	/* 220$BBT$A(B */
  STAT_SEND_HELO,	/* 250$BBT$A(B:HELO hostname */
  STAT_SEND_MAIL,	/* 250$BBT$A(B:MAIL FROM from-address */
  STAT_SEND_RCPT,	/* 250$BBT$A(B:RCPT TO to-address */
  STAT_SEND_DATA,	/* 354$BBT$A(B:DATA */
  STAT_SEND_LINES,	/* 250$BBT$A(B:. */
  STAT_SEND_OK
} Status;
PLIST *SMTPQue;

PLUGINFUNC void
PluginInitilize(const PluginCtrl *pluginCtrl)
{
  Ctrl=pluginCtrl;
  {
    char st[1024];
    gethostname(st,1024);
    Hostname=alcstrCopySet(st);
  }
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                     $B%3%^%s%I(B                     $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

/* -------------------------------------------------- */
/* =============== $B%-!<%A%'%C%/%^%/%m(B =============== */
/* -------------------------------------------------- */
#define KEYCHECK(keyname,minarg,maxarg) \
if(stringCmp((keyname),key))				\
  {			 				\
    if(words<(minarg))					\
      {							\
	Ctrl->returnFunc("Not enough parameters");	\
	ALCSTR_RETURN(1);				\
      }							\
    if(words>(maxarg))					\
      {							\
	Ctrl->returnFunc("Too many parameters");	\
	ALCSTR_RETURN(1);				\
      }							\
  }							\
if(stringCmp((keyname),key))

/* -------------------------------------------------- */
/* ================== $B%3%^%s%I2r@O(B ================== */
/* -------------------------------------------------- */
PLUGINFUNC int
PluginCommand(const char *line)
{
  ALCSTR_BEGIN
    {
      int words;
      ALCSTR key;
      /* $B%3%^%s%I<hF@(B */
      key=alcstrWord(line,0);
      words=stringNumberOfWord(line);
      if(key==NULL)
	ALCSTR_RETURN(0);

      /* SMTP$B%5!<%P(B */
      KEYCHECK("SERVER",2,3)
	{
	  alcstrUpdate(&ServerAddress,alcstrWord(line,1));
	  ServerPort=( (words==3)
		       ? atoi(alcstrWord(line,2))
		       : 25 );
	  Ctrl->returnFunc(alcstrFormat("SMTP Server: $ADDRESS:$PORT",
					"ADDRESS", ASFORMAT_STRING,
					( ServerAddress ),
					"PORT", ASFORMAT_INT,
					( ServerPort ),
					NULL) );
	  ALCSTR_RETURN(1);
	}

      /* $B%a!<%kD9$5(B */
      KEYCHECK("MAXLENGTH",1,2)
	{
	  MaxLength=( (words==2)
		      ? atoi(alcstrWord(line,1))
		      : -1 );
	  if(MaxLength>0)
	    Ctrl->returnFunc("Mail max length: unlimit");
	  else
	    Ctrl->returnFunc(alcstrFormat("Mail max length: $MAXLENGTH",
					  "MAXLENGTH", ASFORMAT_INT,
					  ( ServerPort ),
					  NULL) );
	  ALCSTR_RETURN(1);
	}

      /* $B%a!<%k%"%I%l%9(B */
      KEYCHECK("SENDFROM",2,2)
	{
	  alcstrUpdate(&SendFrom,alcstrWord(line,1));
	  Ctrl->returnFunc(alcstrFormat("From: $ADDRESS",
					"ADDRESS", ASFORMAT_STRING, SendFrom,
					NULL) );
	  ALCSTR_RETURN(1);
	}
      KEYCHECK("SENDTO",2,2)
	{
	  alcstrUpdate(&SendTo,alcstrWord(line,1));
	  Ctrl->returnFunc(alcstrFormat("To: $ADDRESS",
					"ADDRESS", ASFORMAT_STRING, SendTo,
					NULL) );
	  ALCSTR_RETURN(1);
	}

      /* $B%a!<%k(B */
      KEYCHECK("BEGIN",1,1)
	{
	  /* $BDI2CCf$N%G!<%?$r:o=|(B */
	  if(AddingData!=NULL)
	    {
	      int deleted=0;
	      while(AddingData!=NULL)
		{
		  ALCSTR as;
		  as=cplistGetItem(AddingData,0);
		  cplistDeleteItem(&AddingData,as);
		  alcstrDestroy(as);
		  deleted++;
		}
	      Ctrl->returnFunc(alcstrFormat("$DELETED lines has deleted.",
					    "DELETED", ASFORMAT_INT, deleted,
					    NULL) );
	    }
	  /* $B%a%C%;!<%8(B */
	  /* Ctrl->returnFunc("Begin to data adding."); */
	  ALCSTR_RETURN(1);
	}
      KEYCHECK("ADD",2,2)
	{
	  ALCSTR as;
	  as=alcstrSet(alcstrWord(line,1));
	  cplistAddItem(&AddingData,as);
	  /* Ctrl->returnFunc(alcstrFormat("add :$STRING",
	     "STRING", ASFORMAT_STRING, as,
	     NULL) ); */
	  ALCSTR_RETURN(1);
	}
      KEYCHECK("END",1,1)
	{
	  /* MAX$B%5%$%:Fb$K<}$^$k$h$&$KJ,2r(B */
	  PLIST *dataList=NULL;
	  CPLIST *data=NULL;
	  int dataSize=0;
	  int numLines=0,numMails=0;
	  while(AddingData!=NULL)
	    {
	      ALCSTR as;
	      as=cplistGetItem(AddingData,0);
	      /* $B:GBg%5%$%:$r%*!<%P!<$9$k>l9g(B */
	      if( dataSize + strlen(as) + 2/*$B2~9T(B+$BI|5"(B*/ + 9/*$B%Z!<%8I=5-(B*/
		  >= MaxLength )
		{
		  /* $B0l9T0J>e$"$l$P!"$=$l$^$G$NJ,$r0l$D$N%a!<%k$H$9$k(B */
		  if(dataSize>0)
		    {
		      numMails++;
		      plistAddItem(&dataList,data);
		      dataSize=0;
		      data=NULL;
		    }
		  /* $B0l9T$b$J$1$l$P(B($BB($A0l9T$G(BMAX$B%5%$%:$r1[$($k$J$i!"$=$N0l9T$r(B
		     $B$J$+$C$?$3$H$K$9$k!#(B */
		  else
		    {
		      cplistDeleteItem(&AddingData,as);
		      alcstrDestroy(as);
		    }
		}
	      /* $B$=$N9T$rDI2C$7$F$b%5%$%:Fb$K<}$^$k>l9g(B */
	      else
		{
		  numLines++;
		  cplistAddItem(&data,as);
		  cplistDeleteItem(&AddingData,as);
		  dataSize+=strlen(as)+2/* $B2~9TI|5"(B */;
		}
	    }
	  /* $B$N$3$j$r0l$D$N%a!<%k$H$7$FDI2C(B */
	  if(dataSize>0)
	    {
	      numMails++;
	      plistAddItem(&dataList,data);
	    }
	  Ctrl->returnFunc(alcstrFormat("Set waiting data"
					"($MAILS mails/$LINES lines)",
					"MAILS", ASFORMAT_INT, numMails,
					"LINES", ASFORMAT_INT, numLines,
					NULL) );
	  plistAddItem( &WaitingData, dataList );
	  ALCSTR_RETURN(1);
	  
	}

    }
  ALCSTR_END;
  return 0;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                    $BDj4|E*=hM}(B                    $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

PLUGINFUNC void
PluginTimer(void)
{
  time_t now;
  time(&now);

  /* $BAw?.Cf%G!<%?$,$J$1$l$P!"Aw?.BT$A%G!<%?$rAw?.Cf%G!<%?$H$9$k!#(B */
  if( SendingData==NULL && WaitingData!=NULL )
    {
      SendingData = plistGetItem( WaitingData, 0 );
      NumSendedDatas=0;
      plistDeleteItem( &WaitingData, SendingData );
    }

  /* $BL$@\B3$N>l9g(B */
  if(Bufsock==NULL)
    {
      if(SendingData==NULL)
	return;

      if(ServerAddress==NULL || SendFrom==NULL || SendTo==NULL)
	{
	  /* $BAw?.Cf%G!<%?$rGK4~(B */
	  while( SendingData!=NULL)
	    {
	      CPLIST *stlist;
	      stlist=plistGetItem( SendingData, 0 );
	      plistDeleteItem( &SendingData, stlist );
	      while( stlist!=NULL )
		{
		  ALCSTR as;
		  as=cplistGetItem( stlist, 0 );
		  cplistDeleteItem( &stlist, as );
		  alcstrDestroy( as );
		}
	    }
	  /* $B%a%C%;!<%8(B */
	  if(ServerAddress==NULL)
	    Ctrl->systemMessage("SMTP Server address has not specified.");
	  if(SendFrom==NULL)
	    Ctrl->systemMessage("Mail from address has not specified.");
	  if(SendTo==NULL)
	    Ctrl->systemMessage("Mail to address has not specified.");
	  Ctrl->systemMessage("Mail data has destroyed.");

	  return;
	}
      Bufsock=bufsockCreateConnect( ServerAddress, ServerPort );

      /* $B@\B3<:GT(B */
      if(Bufsock==NULL)
	{
	  ALCSTR as;
	  as=alcstrFormat("Couldn't connect to $SERVER:$PORT",
			  "SERVER",ASFORMAT_STRING,ServerAddress,
			  "PORT"  ,ASFORMAT_INT,   ServerPort,
			  NULL);
	  Ctrl->systemMessage(as);
	  return;
	}
      Status=STAT_OPEN;
    }

  /* $BAw?.$9$Y$-%G!<%?$,$J$1$l$P@\B3$r2r=|(B */
  else
    {
      if(SendingData==NULL)
	{
	  bufsockWriteString(Bufsock,"QUIT\r\n");
	  bufsockDestroy(Bufsock);
	  Bufsock=NULL;
	  return;
	}
    }

  /* $B@\B3Cf(B($B$b$7$/$O@\B3$7$?(B)$B$N>l9g(B */
  if(Bufsock!=NULL)
    /* $BFI$_9~$_%k!<%W(B */
    for(;;)
      {
	int maxfd;
	fd_set fds;
	struct timeval timeout;
	/* $B%U%!%$%k5-=R;R(B */
	FD_ZERO(&fds);
	maxfd=bufsockSetFdset(Bufsock,&fds,0)+1;
	/* $B%?%$%`%"%&%H(B */
	timeout.tv_sec =      0;
	timeout.tv_usec=10*1000;
	
	/* $BFI$_9~$_(B */
	if(select(maxfd+1,&fds,NULL,NULL,&timeout)==0)
	  break;
	if(bufsockRead(Bufsock)==0)
	  {
	    /* printf("Closed\n"); */
	    bufsockDestroy(Bufsock);
	    Bufsock=NULL;
	    break;
	  }
      }

  /* $B@\B3Cf(B($B$b$7$/$O(Bm$B$@@\B3$,@Z$i$l$F$$$J$$(B)$B$N>l9g(B */
  if(Bufsock!=NULL)
    for(;;)
      {
	ALCSTR_BEGIN
	  {
	    ALCSTR readLine,writeLine=NULL;
	    /* $B0l9T<hF@(B */
	    readLine=bufsockGetLine(Bufsock);
	    if(readLine==NULL)
	      ALCSTR_BREAK;
	    /* printf("Read:[%s]\n",readLine); */

	    switch(Status)
	      {
	      case STAT_OPEN:
		if( stringCmp("220",alcstrWord(readLine,0)) )
		  {
		    writeLine=alcstrFormat("HELO $HOST\r\n",
					   "HOST",ASFORMAT_STRING,Hostname,
					   NULL);
		    Status=STAT_SEND_HELO;
		  }
		break;
		
	      case STAT_SEND_HELO:
		if( stringCmp("250",alcstrWord(readLine,0)) )
		  {
		    writeLine=alcstrFormat("MAIL FROM: $FROM\r\n",
					   "FROM",ASFORMAT_STRING,SendFrom,
					   NULL);
		    Status=STAT_SEND_MAIL;
		  }
		break;
		
	      case STAT_SEND_MAIL:
		if( stringCmp("250",alcstrWord(readLine,0)) )
		  {
		    writeLine=alcstrFormat("RCPT TO: $TO\r\n",
					   "TO",ASFORMAT_STRING,SendTo,
					   NULL);
		    Status=STAT_SEND_RCPT;
		  }
		break;
		
	      case STAT_SEND_RCPT:
		if( stringCmp("250",alcstrWord(readLine,0)) )
		  {
		    writeLine="DATA\r\n";
		    Status=STAT_SEND_DATA;
		  }
		break;
		
	      case STAT_SEND_DATA:
		if( stringCmp("354",alcstrWord(readLine,0)) )
		  {
		    CPLIST *lineList;
		    ALCSTR line;
		    lineList=plistGetItem( SendingData, 0 );
		    plistDeleteItem( &SendingData, lineList );
		    NumSendedDatas++;
		    /* $BAw?.(B */
		    ALCSTR_BEGIN
		      {
			/* $B%X%C%@(B */
			ALCSTR as;
			int total;
			total=plistNumberOfItem(SendingData)+NumSendedDatas;
			as=alcstrFormat("($COUNT/$TOTAL)\r\n",
					"COUNT",ASFORMAT_INT,NumSendedDatas,
					"TOTAL",ASFORMAT_INT,total,
					NULL);
			bufsockWriteString( Bufsock, as );
			/* $BK\J8(B */
			while( (line=cplistGetItem(lineList,0)) != NULL )
			  {
			    as=alcstrConcatenate(line,"\r\n");
			    bufsockWriteString( Bufsock, as );
			    cplistDeleteItem( &lineList, line );
			    alcstrDestroy(line);
			  }
		      }
		    ALCSTR_END;
		    /* $B=*N;(B */
		    writeLine=".\r\n";
		    Status=STAT_SEND_HELO;
		  }
		break;

	      default:
		break;
	      }
	    
	    /* $B%a%C%;!<%8Aw?.(B */
	    if(writeLine!=NULL)
	      {
		bufsockWriteString(Bufsock,writeLine);
		bufsockFlushWrite(Bufsock,0);
		/* printf("Write:%s",writeLine); */
	      }
	  }
	ALCSTR_END;
      }
}
