/*
 * pop3.c
 *
 * aCHU^Hat $B$N(B pop3 $B%W%i%0%$%s!#(B
 * $B%a!<%k$K$h$k1s3VA`:n$r2DG=$K$9$k!#(B
 */

#ifdef WIN32
#  include <windows.h>
#else
#  ifdef HAVE_CONFIG_H
#    include "config.h"
#  endif
#  include <stdio.h>
#  include <sys/time.h>
#endif

#include <plist.h>
#include <string.h>
#include <bufsock.h>

#include <plugin.h>

static const PluginCtrl *Ctrl;
PLUGINFUNC void
PluginInitilize(const PluginCtrl *pluginCtrl)
{
  Ctrl=pluginCtrl;
}

/* $B@_Dj9`L\(B */
static ALCSTR POP3Addr=NULL;
static int    POP3Port= 110;
static ALCSTR POP3User=NULL;
static ALCSTR POP3Pass=NULL;
static int    POP3CheckInterval=60;
static ALCSTR POP3RecvFrom=NULL;

static ALCSTR LogPlugin;

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                      $B%G!<%?(B                      $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

/* -------------------------------------------------- */
/* =================== $B%a!<%k(BPOP3 =================== */
/* -------------------------------------------------- */

/* $B%a!<%k(BPOP3 */
static BUFSOCK POP3Bufsock=NULL;
static enum {
  POP3STAT_NOT_CONNECTED,
  POP3STAT_OPEN,	/* +OK $BBT$A(B */
  POP3STAT_SEND_USER,	/* +OK $BBT$A(B:USER username */
  POP3STAT_SEND_PASS,	/* +OK $BBT$A(B:PASS password */
  POP3STAT_SEND_LIST,	/* +OK $BBT$A(B:LIST */
  POP3STAT_SEND_RETR,	/* +OK $BBT$A(B:RETR number */
  POP3STAT_RECV_HEAD,	/* $B6u9TBT$A(B:DATA */
  POP3STAT_RECV_BODY,	/* . $BBT$A(B:DATA */
  POP3STAT_RECV_CHANNEL,/* $B6u9TBT$A$N<!$N9T(B */
  POP3STAT_RECV_MESSAGE,/* . $BBT$A(B:$B$=$l0\9T$N9T(B */
  POP3STAT_SEND_DELE,	/* +OK $BBT$A(B:DELE number */
  POP3STAT_OK,		/* OK$B<u?.!#$J$K$+(B($B$H$$$&$+(BRETR)$BAw?.$9$k(B */
  POP3STAT_SEND_QUIT	/* $B$J$K$b$7$J$$!#@\B3$,@Z$l$k$N$rBT$D$N$_(B */
} POP3Status;

static time_t  POP3LastChecked;
static int     POP3FromCheck;
static PLIST  *POP3ReadableMailNoList=NULL;
static int     POP3ReadingNo;
static ALCSTR  POP3SendChannel=NULL;
static ALCSTR  POP3SendConnection=NULL;

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                     $B%3%^%s%I(B                     $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

/* -------------------------------------------------- */
/* ========== $B0z?t$r%"%I%l%9$H%]!<%H$KJ,2r(B ========== */
/* -------------------------------------------------- */
static void
setServer(ALCSTR *address, int *port, ALCSTR arg, int defaultPort,
	  ALCSTR serverName)
{
  int addrEnd;
  for(addrEnd=0; arg[addrEnd]!=':' && arg[addrEnd]!='\0'; addrEnd++);

  if(arg[addrEnd]==':')
    /* $B%]!<%HHV9f;XDj$"$j(B */
    {
      int portTmp=0;
      {
	/* $B%]!<%HHV9f<hF@(B */
	int i;
	for(i=++addrEnd; arg[i]!='\0'; i++)
	  {
	    /* $B%]!<%H$N;XDj$,?t;zJ8;z$G$"$k$+$I$&$+%A%'%C%/(B */
	    if(arg[i]<'0' || arg[i]>'9')
	      {
		portTmp=-1;
		return;
	      }
	    /* $B2C;;(B */
	    portTmp = portTmp*10 + arg[i]-'0';
	  }
	/* $B%]!<%HHV9f%A%'%C%/(B */
	if( portTmp<=0 || portTmp>=65536 )
	  {
	    Ctrl->returnFunc("Illegal port number");
	    return;
	  }
      }
      /* $BCM@_Dj(B */
      alcstrUpdate(address, alcstrMiddle(arg, 0, addrEnd));
      *port=portTmp;
    }
  else
    /* $B%]!<%HHV9f;XDjL5$7(B */
    {
      alcstrUpdate(address, arg);
      *port=defaultPort;
    }

  /* $B@_Dj40N;%a%C%;!<%8(B */
  {
    ALCSTR msg;
    msg=alcstrFormat("Server has set $ADDRESS:$PORT",
		     "ADDRESS", ASFORMAT_STRING, *address,
		     "PORT",    ASFORMAT_INT,    *port,
		     NULL);
    Ctrl->returnFunc(msg);
  }
}


/* -------------------------------------------------- */
/* =============== $B%-!<%A%'%C%/%^%/%m(B =============== */
/* -------------------------------------------------- */
#define KEYCHECK(keyname,minarg,maxarg) \
if(stringCmp((keyname),key))				\
  {			 				\
    if(words<(minarg))					\
      {							\
	Ctrl->returnFunc("Not enough parameters");	\
	ALCSTR_RETURN(1);				\
      }							\
    if(words>(maxarg))					\
      {							\
	Ctrl->returnFunc("Too many parameters");	\
	ALCSTR_RETURN(1);				\
      }							\
  }							\
if(stringCmp((keyname),key))

/* -------------------------------------------------- */
/* ================== $B%3%^%s%I2r@O(B ================== */
/* -------------------------------------------------- */
PLUGINFUNC int
PluginCommand(const char *line)
{
  ALCSTR_BEGIN
    {
      int words;
      ALCSTR key;
      /* $B%3%^%s%I<hF@(B */
      key=alcstrWord(line,0);
      words=stringNumberOfWord(line);
      if(key==NULL)
	ALCSTR_RETURN(0);

      /* $B%5!<%P(B */
      KEYCHECK("SERVER",2,2)
	{
	  setServer(&POP3Addr,&POP3Port, alcstrWord(line,1), 110, "POP3");
	  ALCSTR_RETURN(1);
	}
      /* $B%f!<%6L>(B */
      KEYCHECK("USER",1,2)
	{
	  alcstrUpdate(&POP3User,alcstrWord(line,1));
	  ALCSTR_RETURN(1);
	}
      /* $B%Q%9%o!<%I(B */
      KEYCHECK("PASS",1,2)
	{
	  alcstrUpdate(&POP3Pass,alcstrWord(line,1));
	  ALCSTR_RETURN(1);
	}
      /* $B5v2D$9$kAw?.85(B */
      KEYCHECK("FROM",1,2)
	{
	  alcstrUpdate(&POP3RecvFrom,alcstrWord(line,1));
	  ALCSTR_RETURN(1);
	}

      /* $B%m%0Aw?.$9$k%W%i%0%$%s$NL>A0(B */
      KEYCHECK("LOGPLUGIN",1,2)
	{
	  alcstrUpdate(&LogPlugin,alcstrWord(line,1));
	  ALCSTR_RETURN(1);
	}
    }
  ALCSTR_END;
  return 0;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                    $BDj4|E*=hM}(B                    $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
PLUGINFUNC void
PluginTimer(void)
{
  time_t now;
  time(&now);

  /* -------------------------------------------------- */
  /* ============== $B%a!<%k$N<u?.%A%'%C%/(B ============== */
  /* -------------------------------------------------- */
  /* $BL$@\B3$N>l9g(B */
  if(POP3Bufsock==NULL)
    {
      if(POP3Addr!=NULL
	 && POP3User!=NULL && POP3Pass!=NULL && POP3RecvFrom!=NULL)
	{
	  if(now>POP3LastChecked+POP3CheckInterval)
	    {
	      POP3LastChecked=now;
	      POP3Status=POP3STAT_OPEN;
	      POP3Bufsock=bufsockCreateConnect(POP3Addr,POP3Port);
	      plistClearItem(&POP3ReadableMailNoList);
	    }
	}
    }

  /* $B@\B3Cf(B($B$b$7$/$O@\B3$7$?(B)$B$N>l9g(B */
  if(POP3Bufsock!=NULL)
    /* $BFI$_9~$_%k!<%W(B */
    for(;;)
      {
	int maxfd;
	fd_set fds;
	struct timeval timeout;
	/* $B%U%!%$%k5-=R;R(B */
	FD_ZERO(&fds);
	maxfd=bufsockSetFdset(POP3Bufsock,&fds,0)+1;
	/* $B%?%$%`%"%&%H(B */
	timeout.tv_sec =      0;
	timeout.tv_usec=10*1000;
	
	/* $BFI$_9~$_(B */
	if(select(maxfd+1,&fds,NULL,NULL,&timeout)==0)
	  break;
	if(bufsockRead(POP3Bufsock)==0)
	  {
	    /* printf("Closed\n"); */
	    bufsockDestroy(POP3Bufsock);
	    POP3Bufsock=NULL;
	    break;
	  }
      }

  /* $B@\B3Cf(B($B$b$7$/$O(Bm$B$@@\B3$,@Z$i$l$F$$$J$$(B)$B$N>l9g(B */
  if(POP3Bufsock!=NULL)
    for(;;)
      {
	ALCSTR_BEGIN
	  {
	    ALCSTR readLine,writeLine=NULL;
	    /* $B0l9T<hF@(B */
	    readLine=bufsockGetLine(POP3Bufsock);
	    if(readLine==NULL)
	      ALCSTR_BREAK;
	    /* printf("Read:[%s]%d\n",readLine,POP3Status); */

	    switch(POP3Status)
	      {
	      case POP3STAT_OPEN:
		if( stringCmp("+OK",alcstrWord(readLine,0)) )
		  {
		    writeLine=alcstrFormat("USER $USER\r\n",
					   "USER",ASFORMAT_STRING,
					   POP3User,
					   NULL);
		    POP3Status=POP3STAT_SEND_USER;
		  }
		break;
		
	      case POP3STAT_SEND_USER:
		if( stringCmp("+OK",alcstrWord(readLine,0)) )
		  {
		    writeLine=alcstrFormat("PASS $PASS\r\n",
					   "PASS",ASFORMAT_STRING,
					   POP3Pass,
					   NULL);
		    POP3Status=POP3STAT_SEND_PASS;
		  }
		break;
		
	      case POP3STAT_SEND_PASS:
		if( stringCmp("+OK",alcstrWord(readLine,0)) )
		  {
		    writeLine="LIST\r\n";
		    POP3Status=POP3STAT_SEND_LIST;
		  }
		break;
		
	      case POP3STAT_SEND_LIST:
		if( stringCmp(".",readLine) )
		  {
		    POP3Status=POP3STAT_OK;
		    POP3ReadingNo=0;
		  }
		else if(readLine[0]>='0' && readLine[0]<='9')
		  {
		    ALCSTR size;
		    size=alcstrWord(readLine,1);
		    if(size!=NULL && atoi(size)>0 && atoi(size)<1000)
		      {
			plistAddItem(&POP3ReadableMailNoList,
				     (void*)(atoi(readLine)));
		      }
		  }
		break;
		
	      case POP3STAT_SEND_RETR:
		if( stringCmp("+OK",alcstrWord(readLine,0)) )
		  POP3Status=POP3STAT_RECV_HEAD;
		break;
		
	      case POP3STAT_RECV_HEAD:
		if( stringCmp(".",readLine) )
		  POP3Status=POP3STAT_OK;
		else if( readLine[0]=='\0' )
		  POP3Status=POP3FromCheck
		    ? POP3STAT_RECV_CHANNEL
		    : POP3STAT_RECV_BODY;
		else if( stringCmp("From:",alcstrWord(readLine,0)) )
		  {
		    int i;
		    for(i=0; ISSPACE   (readLine[i]); i++);
		    for(   ; ISWORDCHAR(readLine[i]); i++);
		    for(   ; ISSPACE   (readLine[i]); i++);
		    if(stringCmp(readLine+i,POP3RecvFrom))
		      POP3FromCheck=1;
		    }
		break;

	      case POP3STAT_RECV_BODY:
		if( stringCmp(".",readLine) )
		  POP3Status=POP3STAT_OK;
		break;

	      case POP3STAT_RECV_CHANNEL:
		{
		  int numWords;
		  numWords=stringNumberOfWord(readLine);
		  if(numWords!=1 && numWords!=2)
		    POP3Status=POP3STAT_RECV_BODY;
		  else
		    {
		      /* $B%A%c%s%M%k(B */
		      alcstrUpdate(&POP3SendChannel,
				   alcstrWord(readLine,0) );
		      /* $B%3%M%/%7%g%s(B */
		      if(numWords==1)
			alcstrUpdate(&POP3SendConnection,
				     Ctrl->getMainConnection());
		      else
			alcstrUpdate(&POP3SendConnection,
				     alcstrWord(readLine,1) );
		      POP3Status
			= ( (Ctrl->getChannelInfo(POP3SendConnection,
						  POP3SendChannel)!=NULL)
			    ? POP3STAT_RECV_MESSAGE
			    : POP3STAT_RECV_BODY    );
		    }
		  break;
		}

	      case POP3STAT_RECV_MESSAGE:
		/* $B%a!<%k$N=*C<(B */
		if( stringCmp(".",readLine) )
		  {
		    /* $B%a!<%k$N:o=|(B */
		    writeLine=alcstrFormat("DELE $NO\r\n",
					   "NO", ASFORMAT_INT,
					   POP3ReadingNo,
					   NULL);
		    POP3Status=POP3STAT_SEND_DELE;
		    /* $BH/8@A08e$N%m%0$N%a!<%kAw?.(B */
		    {
		      ALCSTR cmd;
		      cmd=alcstrFormat( "$LOGPLUGIN SENDMAIL"
					" $CONNECTION $CHANNEL",
					"LOGPLUGIN", ASFORMAT_STRING,
					( LogPlugin ),
					"CONNECTION", ASFORMAT_STRING, 
					( POP3SendConnection ),
					"CHANNEL", ASFORMAT_STRING, 
					( POP3SendChannel ),
					NULL );
		      Ctrl->command(cmd);
		    }
		  }
		/* $B%a!<%k$N%a!<%k$NK\J8Cf(B */
		else if(readLine[0]!='\0')
		  {
		    /* $B%a%C%;!<%8H/8@(B */
		    {
		      ALCSTR msg;
		      msg=alcstrFormat("$MESSAGE(E-mail remote)",
				       "MESSAGE", ASFORMAT_STRING, readLine,
				       NULL);
		      Ctrl->writeMessage(POP3SendConnection,PLUGIN_CMD_PRIVMSG,
					 POP3SendChannel, msg);
		    }
		    /* $B%7%9%F%`%a%C%;!<%8(B */
		    {
		      ALCSTR msg;
		      msg=alcstrFormat("Remote message to $CONNECTION:$CHANNEL"
				       "($MESSAGE)",
				       "CONNECTION", ASFORMAT_STRING,
				       POP3SendConnection,
				       "CHANNEL",ASFORMAT_STRING,
				       POP3SendChannel, 
				       "MESSAGE", ASFORMAT_STRING,readLine,
				       NULL);
		      Ctrl->systemMessage(msg);
		    }
		  }
		break;

	      case POP3STAT_SEND_DELE:
		if( stringCmp("+OK",alcstrWord(readLine,0)) )
		  POP3Status=POP3STAT_OK;
		break;
		
	      default:
		break;
	      }

	    /* RETR$B%j%/%(%9%H(B */
	    if(POP3Status==POP3STAT_OK)
	      {
		/* $B:G8e$^$G8+=*$C$?>l9g(B */
		if(POP3ReadableMailNoList==NULL)
		  {
		    writeLine="QUIT\r\n";
		    POP3Status=POP3STAT_SEND_QUIT;
		  }
		/* $B$=$&$G$J$1$l$P<!$r8+$k(B */
		else
		  {
		    POP3ReadingNo=
		      (int)plistGetItem(POP3ReadableMailNoList, 0);
		    plistDeleteItem(&POP3ReadableMailNoList,
				    (void*)POP3ReadingNo);
		    POP3FromCheck=0;
		    writeLine=alcstrFormat("RETR $NO\r\n",
					   "NO", ASFORMAT_INT,
					   POP3ReadingNo,
					   NULL);
		    POP3Status=POP3STAT_SEND_RETR;
		  }
	      }
	    
	    /* $B%a%C%;!<%8Aw?.(B */
	    if(writeLine!=NULL)
	      {
		bufsockWriteString(POP3Bufsock,writeLine);
		bufsockFlushWrite(POP3Bufsock,0);
		/* printf("Write:%s",writeLine); */
	      }
	  }
	ALCSTR_END;
      }
}
