/*
 * log.c
 *
 * aCHU^Hat $B$N(B log $B%W%i%0%$%s!#(B
 * $B%m%0$H$j!"(BJOIN$B;~$N2a5n%m%0$NAw?.!"%a!<%k$K$h$k%m%0$NAw?.Ey!#(B
 */

#ifdef WIN32
#  include <windows.h>
#  include <stdio.h>
#else
#  ifdef HAVE_CONFIG_H
#    include "config.h"
#  endif
#  include <stdio.h>
#  include <time.h>
#  include <stdarg.h>
#endif

#include <plist.h>
#include <string.h>
#include <bufsock.h>

#include <plugin.h>

static const PluginCtrl *Ctrl;
PLUGINFUNC void
PluginInitilize(const PluginCtrl *pluginCtrl)
{
  Ctrl=pluginCtrl;
}

/* $B@_Dj9`L\(B */
static ALCSTR SendPlugin=NULL;
static CPLIST *Keywords=NULL;
static ALCSTR LogFilename=NULL;
static ALCSTR LogLineHead=NULL;

static int JoinBacklogLines=10;
static int SendBacklogLines=5;
static int SendWait=200;

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                      $B%G!<%?(B                      $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

/* -------------------------------------------------- */
/* ================= $B%A%c%s%M%k%m%0(B ================= */
/* -------------------------------------------------- */
/* $B%m%0(B */
typedef struct{
  time_t time;	/* $B;~4V(B */
  ALCSTR line;	/* $B9T(B */
}LOGLINE;

typedef struct{
  ALCSTR   channelName;	/* $B%A%c%s%M%kL>(B */
  PLIST   *logLines;	/* LOGLINE$B%j%9%H(B */
  LOGLINE *sendStart;	/* $BAw?.3+;O0LCV(B($BAw?.=`HwCf$G$J$1$l$P(BNULL) */
  time_t   called;	/* $B:G8e$K8F$S=P$5$l$?;~4V(B($B$3$N;~4V$+$i0lDj;~4V0J>e7P$D(B
			   $B$HAw?.$9$k!#ESCf$G:FEY8F$S=P$5$l$?>l9g$O!"$=$N;~$N;~(B
			   $B4V$K99?7$9$k(B) */
  int      cancelable;	/* $B%-%c%s%;%k2DG=$+$I$&$+(B($BL>A0$,8F$S=P$5$l$?>l9g$N%m%0(B
			   $BAw?.$O!"<+J,$NH/8@$K$h$C$F%-%c%s%;%k2DG=$@$,!"$=$l0J(B
			   $B30$N30E*MW0x$K$h$k$b$N$O%-%c%s%;%kIT2D$H$9$k(B) */
}LOGCHANNEL;

static PLIST *LogChannel;
/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ---------------- $B%m%09T(B ---------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
/* $BDI2C(B */
static LOGLINE*
LogLineCreate(LOGCHANNEL *cp,ALCSTR line)
{
  LOGLINE *lp;
  /* $B%m%09T%G!<%?@8@.(B */
  lp=malloc(sizeof(LOGLINE));
  lp->line=alcstrCopySet(line);
  time(&lp->time);
  /* $B%A%c%s%M%k%G!<%?$KDI2C(B */
  plistAddItem(&cp->logLines,lp);

  /* $B%m%0%U%!%$%k=PNO(B */
  if( LogFilename && LogLineHead )
    {
      time_t now;
      struct tm *ltime;
      char sec[3], min[3], hour[3], mday[3], mon[3], year[5], wday[2];
      /* 
	 static char *mon_list[] = {
	 "Jan", "Feb", "Mar", "Apr", "May", "Jun",
	 "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	 };
	 static char *wday_list[] = {
	 "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
	 };
	 */
      time(&now);
      ltime=localtime(&now);
      sprintf( sec,  "%02d", ltime->tm_sec   );
      sprintf( min,  "%02d", ltime->tm_min   );
      sprintf( hour, "%02d", ltime->tm_hour  );
      sprintf( mday, "%02d", ltime->tm_mday  );
      sprintf( mon,  "%02d", ltime->tm_mon+1 );
      sprintf( year, "%04d", ltime->tm_year  );
      sprintf( wday, "%01d", ltime->tm_wday  );

      ALCSTR_BEGIN
	{
	  ALCSTR filename, filehead;
	  FILE *fp;
  
	  filename = alcstrFormat( LogFilename,
				   "SEC",     ASFORMAT_STRING, sec,
				   "MIN",     ASFORMAT_STRING, min,
				   "HOUR",    ASFORMAT_STRING, hour,
				   "MDAY",    ASFORMAT_STRING, mday,
				   "MON",     ASFORMAT_STRING, mon,
				   "YEAR",    ASFORMAT_STRING, year,
				   "WDAY",    ASFORMAT_STRING, wday,
				   "CHANNEL", ASFORMAT_STRING,
				   ( alcstrJIStoMSKanji(cp->channelName) ),
				   NULL );
	  filehead = alcstrFormat( LogLineHead,
				   "SEC",  ASFORMAT_STRING, sec,
				   "MIN",  ASFORMAT_STRING, min,
				   "HOUR", ASFORMAT_STRING, hour,
				   "MDAY", ASFORMAT_STRING, mday,
				   "MON",  ASFORMAT_STRING, mon,
				   "YEAR", ASFORMAT_STRING, year,
				   "WDAY", ASFORMAT_STRING, wday,
				   "CHANNEL", ASFORMAT_STRING, cp->channelName,
				   NULL );
	  fp=fopen( filename, "at" );
	  if( fp )
	    {
	      fprintf( fp, "%s%s\n", filehead, line );
	      fclose(fp);
	    }
	}
      ALCSTR_END;
    }

  return lp;
}

/* $B:o=|(B */
static void
LogLineDestroy(LOGCHANNEL *cp,LOGLINE *lp)
{
  plistDeleteItem(&cp->logLines,lp);
  alcstrDestroy(lp->line);
  free(lp);
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* -------------- $B%A%c%s%M%k(B -------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
/* $B<hF@(B */
static LOGCHANNEL* 
LogChannelGet(ALCSTR channelName)
{
  PLISTLOOP_BEGIN(cp,LOGCHANNEL,LogChannel)
    {
      if(stringCmp(cp->channelName,channelName))
	return cp;
    }
  PLISTLOOP_END;

  return NULL;
}

/* $BDI2C(B */
static LOGCHANNEL* 
LogChannelCreate(ALCSTR channelName)
{
  LOGCHANNEL *cp;

  cp=malloc(sizeof(LOGCHANNEL));
  cp->channelName=alcstrCopySet(channelName);
  cp->logLines=NULL;
  cp->sendStart=NULL;

  /* $B%j%9%H$KDI2C(B */
  plistAddItem(&LogChannel,cp);

  return cp;
}

/* $B:o=|(B */
static void
LogChannelDestroy(LOGCHANNEL *cp)
{
  /* $B%j%9%H$+$i:o=|(B */
  plistDeleteItem(&LogChannel,cp);
  /* $B%A%c%s%M%kL>J8;zNsGK4~(B */
  alcstrDestroy(cp->channelName);
  /* $B%m%0GK4~(B */
  while(cp->logLines!=NULL)
    {
      LOGLINE *lp;
      lp=plistGetItem(cp->logLines,0);
      LogLineDestroy(cp,lp);
    }

  free(cp);
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* --------------- $B%m%0DI2C(B --------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
/* $B%A%c%s%M%k$N%m%0(B($B$=$N%A%c%s%M%k$N%G!<%?$KIU2C(B) */
static void
setChannelLog(ALCSTR connection,ALCSTR channel, ALCSTR format, ...)
{
  ALCSTR_BEGIN
    {
      LOGCHANNEL *cp;
      ALCSTR message;
      va_list args;

      /* $B%m%0%A%c%s%M%k%G!<%?<hF@(B */
      {
	ALCSTR chname;
	chname=Ctrl->getLocalName(connection,channel);
	cp=LogChannelGet(chname);
	if(cp==NULL)
	  cp=LogChannelCreate(chname);
      }

      /* $B%U%)!<%^%C%H9=@.(B */
      va_start(args,format);
      message=alcstrFormatV(format,args);
      va_end(args);

      /* $B%G!<%?DI2C(B */
      LogLineCreate(cp,message);
    }
  ALCSTR_END;
}

/* $B$=$N%f!<%6$,5o$k%A%c%s%M%k$K%G!<%?IU2C(B */
static void
setUserLog(ALCSTR connection,ALCSTR nick, ALCSTR format, ...)
{
  ALCSTR_BEGIN
    {
      ALCSTR message;
      const UserInfo *uinfo;
      /* $B%f!<%6$N>pJs$r<hF@(B */
      uinfo=Ctrl->getUserInfo(connection,nick);
      if(uinfo==NULL)
	ALCSTR_RETURNNOARG;

      /* $B%U%)!<%^%C%H9=@.(B */
      {
	va_list args;
	va_start(args,format);
	message=alcstrFormatV(format,args);
	va_end(args);
      }

      /* $B%f!<%6$N(BJOIN$B$7$F$k%A%c%s%M%k$K%G!<%?$rDI2C(B */
      {
	int i;
	for(i=0; i<uinfo->numChannels; i++)
	  {
	    LOGCHANNEL *cp;
	    ALCSTR chname;
	    chname=Ctrl->getLocalName(connection,uinfo->channels[i]);
	    cp=LogChannelGet(chname);
	    if(cp==NULL)
	      cp=LogChannelCreate(chname);
	    LogLineCreate(cp,message);
	  }
      }
    }
  ALCSTR_END;
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* --------------- $B%m%0Aw?.(B --------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
/* $B=`Hw(B */
static void
setLogSending(const char *connection, const char *channel, int cancelable)
{
  time_t now;
  LOGCHANNEL *cp;
  time(&now);

  /* $B%m%0%A%c%s%M%k<hF@(B */
  cp=LogChannelGet(Ctrl->getLocalName(connection,channel));
  if(cp==NULL)
    abort();

  /* $BE>Aw$N:G=i$N9T@_Dj(B */
  if(cp->sendStart==NULL)
    {
      int numLogLines;
      int sendStartPos;
      int i;

      /* $B8=:_$N9T?t<hF@(B */
      numLogLines=plistNumberOfItem(cp->logLines);

      /* $B%P%C%/%m%09T?t$@$1La$k(B */
      sendStartPos=numLogLines-SendBacklogLines;
      if(sendStartPos<0)
	sendStartPos=0;

      /* $B$=$l0J9_$N<+J,$NH/8@$,$J$$$+(B */
      if(cancelable)
	{
	  for(i=sendStartPos; i<numLogLines; i++)
	    {
	      LOGLINE *lp;
	      lp=plistGetItem(cp->logLines, i);
	      /* if(lp->time>now-SendWait)
		 printf("[%s]\n",lp->line); */
	      if(lp->time>now-SendWait && lp->line[0]=='>')
		return;
	    }
	}

      /* $BLa$C$?0LCV$N9T$r<hF@(B */
      cp->sendStart=plistGetItem(cp->logLines, sendStartPos);
      /* $B%-%c%s%;%k2DH](B */
      cp->cancelable=cancelable;

      Ctrl->systemMessage("Ready to send log...");
    }
  /* $B4{$KE>Aw=`HwCf$N>l9g(B */
  else
    {
      /* $B%-%c%s%;%k2DH](B */
      if(!cancelable)
	cp->cancelable=0;
    }

  /* $B8F$P$l$?;~4V(B */
  time(&cp->called);
}

/* $B%-%c%s%;%k(B */
static void
resetLogSending()
{
  PLISTLOOP_BEGIN(cp,LOGCHANNEL,LogChannel)
    {
      /* $BE>Aw=`HwCf$J$i5Q2<(B */
      if(cp->sendStart!=NULL && cp->cancelable)
	{
	  Ctrl->systemMessage("Log sending has canceled...");
	  cp->sendStart=NULL;
	}
    }
  PLISTLOOP_END;
}

/* -------------------------------------------------- */
/* =================== $B$=$NB>;(MQ(B =================== */
/* -------------------------------------------------- */
static const char *
timeString(time_t *tim)
{
  static char returnBuffer[6];
  struct tm *localtim;

  localtim=localtime(tim);
  returnBuffer[0]=(localtim->tm_hour/10)+'0';
  returnBuffer[1]=(localtim->tm_hour%10)+'0';
  returnBuffer[2]=':';
  returnBuffer[3]=(localtim->tm_min/10)+'0';
  returnBuffer[4]=(localtim->tm_min%10)+'0';
  returnBuffer[5]='\0';
  
  return returnBuffer;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                     $B%3%^%s%I(B                     $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

/* -------------------------------------------------- */
/* =============== $B%-!<%A%'%C%/%^%/%m(B =============== */
/* -------------------------------------------------- */
#define KEYCHECK(keyname,minarg,maxarg) \
if(stringCmp((keyname),key))				\
  {			 				\
    if(words<(minarg))					\
      {							\
	Ctrl->returnFunc("Not enough parameters");	\
	ALCSTR_RETURN(1);				\
      }							\
    if(words>(maxarg))					\
      {							\
	Ctrl->returnFunc("Too many parameters");	\
	ALCSTR_RETURN(1);				\
      }							\
  }							\
if(stringCmp((keyname),key))

/* -------------------------------------------------- */
/* ================== $B%3%^%s%I2r@O(B ================== */
/* -------------------------------------------------- */
PLUGINFUNC int
PluginCommand(const char *line)
{
  ALCSTR_BEGIN
    {
      int words;
      ALCSTR key;
      /* $B%3%^%s%I<hF@(B */
      key=alcstrWord(line,0);
      words=stringNumberOfWord(line);
      if(key==NULL)
	ALCSTR_RETURN(0);

      /* $B%m%0%U%!%$%kL>(B */
      KEYCHECK("LOGFILENAME",1,2)
	{
	  alcstrUpdate( &LogFilename, alcstrWord(line,1) );
	  ALCSTR_RETURN(1);
	}
      /* $B%m%09T$N@hF,(B */
      KEYCHECK("LOGLINEHEAD",1,2)
	{
	  alcstrUpdate( &LogLineHead, alcstrWord(line,1) );
	  ALCSTR_RETURN(1);
	}

      /* $B%a!<%kAw?.%W%i%0%$%sL>(B */
      KEYCHECK("MAILSENDPLUGIN",2,2)
	{
	  alcstrUpdate( &SendPlugin, alcstrWord(line,1) );
	  ALCSTR_RETURN(1);
	}

      /* $B%-!<%o!<%I(B */
      KEYCHECK("MAILSENDKEY",1,256)
	{
	  int i;
	  ALCSTR keyword;
	  /* $B$$$^$^$G$N%-!<%o!<%I$r:o=|(B */
	  while(Keywords!=NULL)
	    {
	      keyword=cplistGetItem(Keywords,0);
	      cplistDeleteItem(&Keywords,keyword);
	      alcstrDestroy(keyword);
	    }
	  /* $B@_Dj$5$l$?%-!<%o!<%I$rEPO?(B */
	  for(i=1; i<words; i++)
	    {
	      cplistAddItem( &Keywords, alcstrSet(alcstrWord(line,i)) );
	    }
	  ALCSTR_RETURN(1);
	}

      /* $B%a!<%kAw?.(B */
      KEYCHECK("SENDMAIL",3,3)
	{
	  ALCSTR connection, channel;
	  connection=alcstrWord(line,1);
	  channel   =alcstrWord(line,2);
	  setLogSending( connection, channel, 0 /* $B%-%c%s%;%kIT2D(B */ );
	  ALCSTR_RETURN(1);
	}

      /* $B%m%0%F%9%H(B */
      KEYCHECK("TEST",1,1)
	{
	  PLISTLOOP_BEGIN(cp,LOGCHANNEL,LogChannel)
	    {
	      ALCSTR msg;
	      msg=alcstrFormat("Channel: $CHANNEL",
			       "CHANNEL", ASFORMAT_STRING, cp->channelName,
			       NULL);
	      Ctrl->returnFunc(msg);

	      PLISTLOOP_BEGIN(lp,LOGLINE,cp->logLines)
		{
		  msg=alcstrFormat("$TIME $MESSAGE",
				   "TIME", ASFORMAT_STRING,
				   timeString(&lp->time),
				   "MESSAGE", ASFORMAT_STRING, lp->line,
				   NULL);
		  Ctrl->returnFunc(msg);
		}
	      PLISTLOOP_END;
	    }
	  PLISTLOOP_END;
	  ALCSTR_RETURN(1);
	}
    }
  ALCSTR_END;
  return 0;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                 $B%a%C%;!<%8Aw<u?.(B                 $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

/* $B%a%C%;!<%8Aw?.(B */
PLUGINFUNC void
PluginConnectionWrite(const char *connection, const char *line)
{
  ALCSTR_BEGIN
    {
      ALCSTR cmd;
      /* $B%3%^%s%I(B */
      cmd=alcstrWord(line,0);
      if(cmd==NULL)
	ALCSTR_RETURNNOARG;

      /* $BH/8@(B */
      if(stringCmp(cmd, "PRIVMSG") || stringCmp(cmd, "NOTICE"))
	{
	  ALCSTR channel,message;
	  channel=alcstrWord(line,1);
	  message=alcstrWord(line,2);
	  /* $B%m%0$NDI2C(B($B<+J,$NH/8@$O%j%W%i%$$,$J$$$N$GH/8@$rAw?.;~$K5-O?$7$J$1(B
	     $B$l$P$J$i$J$$(B) */
	  if(message!=NULL)
	    {
	      ALCSTR nick;
	      nick=Ctrl->getConnectionInfo(connection)->nickname;
	      setChannelLog(connection,channel,">$NICK< $MESSAGE",
			    "NICK",    ASFORMAT_STRING, nick,
			    "MESSAGE", ASFORMAT_STRING, message,
			    NULL);
	    }
	  /* PRIVMSG$B$N>l9g$O%m%0$NAw?.$rCf;_$9$k(B */
	  if(stringCmp(cmd, "PRIVMSG"))
	    resetLogSending();

	  ALCSTR_RETURNNOARG;
	}
    }
  ALCSTR_END;
}

/* $B%a%C%;!<%8<u?.(B */
PLUGINFUNC void
PluginConnectionRead(const char *connection, const char *line)
{
  ALCSTR_BEGIN
    {
      int numWords;
      ALCSTR nick,cmd;
      if(line[0]!=':')
	ALCSTR_RETURNNOARG;
      line++;
      /* $BC18l?t<hF@(B */
      numWords=stringNumberOfWord(line);
      /* $B%3%^%s%I(B */
      if((cmd=alcstrWord(line,1))==NULL)
	ALCSTR_RETURNNOARG;

      /* $B%K%C%/<hF@(B */
      {
	int i;
	for(i=0;line[i]!='!' && ISWORDCHAR(line[i]);i++);
	nick=alcstrMiddle(line,0,i);
      }

      /* $BH/8@(B */
      if((stringCmp(cmd,"PRIVMSG") || stringCmp(cmd,"NOTICE")) && numWords==4)
	{
	  ALCSTR channel,message;
	  int myself=0;
	  channel=alcstrWord(line,2);
	  message=alcstrWord(line,3);
	  /* $B<+J,$NH/8@$+$I$&$+(B */
	  {
	    const ConnectionInfo *cninfo;
	    cninfo=Ctrl->getConnectionInfo(connection);
	    myself=(cninfo!=NULL && stringCmp(cninfo->nickname,nick));
	  }

	  /* $B%m%0@_Dj(B */
	  setChannelLog(connection, channel, 
			myself?">$NICK< $MESSAGE":"<$NICK> $MESSAGE",
			"NICK",   ASFORMAT_STRING,
			Ctrl->getLocalName(connection,nick),
			"MESSAGE",ASFORMAT_STRING,message,
			NULL);

	  /* PRIVMSG$B$N>l9g$O!"8F$S=P$7%A%'%C%/(B */
	  if(stringCmp(cmd,"PRIVMSG") && nick[0]!='*')
	    {
	      if(myself)
		/* $B<+J,$,H/8@$7$?>l9g$O!"$I$N%A%c%s%M%k$G$"$k$+$K$+$+$o$i$:!"Aw(B
		   $B?.$rCf;_(B */
		resetLogSending();

	      else
		/* $BB>?M$NH/8@$GL>A0$r8F$P$l$?>l9g$OAw?.=`Hw(B */
		{
		  int i;
		  ALCSTR key=NULL;

		  if(SendPlugin!=NULL)
		    {
		      /* $B8F$P$l$?$+$I$&$+%A%'%C%/(B */
		      for(i=0; (key=cplistGetItem(Keywords,i))!=NULL; i++)
			{
			  if(stringMatch(message,key))
			    break;
			}
		    }

		  if(key!=NULL)
		    setLogSending(connection, channel,
				  1 /* $B%-%c%s%;%k$r5v2D(B */);
		}
	    }

	  ALCSTR_RETURNNOARG;
	}

      /* JOIN$B%a%C%;!<%8(B */
      if(stringCmp(cmd,"JOIN") && numWords==3)
	{
	  setChannelLog(connection, alcstrWord(line,2), "$NICK has joind",
			"NICK",ASFORMAT_STRING,
			Ctrl->getLocalName(connection,nick),
			NULL);
	  ALCSTR_RETURNNOARG;
	}

      /* PART$B%a%C%;!<%8(B */
      if(stringCmp(cmd,"PART") && ( numWords==3 || numWords==4) )
	{
	  if(numWords==3)
	    setChannelLog(connection,alcstrWord(line,2), "$NICK has parted",
			  "NICK",ASFORMAT_STRING,
			  Ctrl->getLocalName(connection,nick),
			  NULL);
	  else
	    setChannelLog(connection,alcstrWord(line,2),
			  "$NICK has parted($MESSAGE)",
			  "NICK",ASFORMAT_STRING,
			  Ctrl->getLocalName(connection,nick),
			  "MESSAGE",ASFORMAT_STRING,alcstrWord(line,3),
			  NULL);
	  ALCSTR_RETURNNOARG;
	}

      /* QUIT$B%a%C%;!<%8(B */
      if(stringCmp(cmd,"QUIT") && ( numWords==2 || numWords==3) )
	{
	  if(numWords==2)
	    setUserLog(connection, nick, "$NICK has quited",
		       "NICK",ASFORMAT_STRING,
		       Ctrl->getLocalName(connection,nick),
		       NULL);
	  else
	    setUserLog(connection, nick, "$NICK has quited($MESSAGE)",
		       "NICK",ASFORMAT_STRING,
		       Ctrl->getLocalName(connection,nick),
		       "MESSAGE",ASFORMAT_STRING,alcstrWord(line,2),
		       NULL);
	  
	  ALCSTR_RETURNNOARG;
	}

      /* NICK$B%a%C%;!<%8(B */
      if(stringCmp(cmd,"NICK") && numWords==3 )
	{
	  ALCSTR realNick,oldNick,newNick;

	  realNick=alcstrWord(line,2);
	  oldNick=Ctrl->getLocalName(connection,nick    );
	  newNick=Ctrl->getLocalName(connection,realNick);

	  setUserLog(connection, realNick, "$OLDNICK -> $NEWNICK",
		     "OLDNICK",ASFORMAT_STRING,oldNick,
		     "NEWNICK",ASFORMAT_STRING,newNick,
		     NULL);

	  ALCSTR_RETURNNOARG;
	}

    }
  ALCSTR_END;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                    $BDj4|E*=hM}(B                    $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
PLUGINFUNC void
PluginTimer(void)
{
  time_t now;
  time(&now);

  PLISTLOOP_BEGIN(cp,LOGCHANNEL,LogChannel)
    {
      /* $B%m%0Aw?.%W%i%0%$%s$N;XDj$,$J$1$l$P!"%m%0Aw?.MW5a$O6/@)5Q2<(B */
      if(SendPlugin==NULL && cp->sendStart!=NULL)
	{
	  Ctrl->systemMessage("MAILSENDPLUGIN is not specified.");
	  Ctrl->systemMessage("Log sending is canceled.");
	  cp->sendStart=NULL;
	}

      /* $B==J,$K;~4V$,7P$C$?$iE>Aw(B */
      if(cp->sendStart!=NULL && cp->called+SendWait<now)
	{
	  ALCSTR_BEGIN
	    {
	      int sendPos;
	      LOGLINE *lp;
	      /* $BAw?.%G!<%?3+;O(B */
	      Ctrl->command( alcstrConcatenate(SendPlugin," BEGIN") );
	      /* $B%A%c%s%M%kL>(B */
	      {
		ALCSTR cmd;
		cmd=alcstrFormat("$PLUGIN ADD :$TIME $CHANNEL",
				 "PLUGIN", ASFORMAT_STRING,SendPlugin,
				 "CHANNEL",ASFORMAT_STRING,cp->channelName,
				 "TIME",   ASFORMAT_STRING,
				 ( timeString(&cp->called) ),
				 NULL);
		Ctrl->command(cmd);
		alcstrDestroy(cmd);
	      }
	      /* $BAw?.%G!<%?(B */
	      for( sendPos=plistGetIndex(cp->logLines, cp->sendStart);
		   (lp=plistGetItem(cp->logLines,sendPos))!=NULL;
		   sendPos++ )
		{
		  ALCSTR cmd;
		  cmd=alcstrFormat("$PLUGIN ADD :$LINE",
				   "PLUGIN",ASFORMAT_STRING,SendPlugin,
				   "LINE",  ASFORMAT_STRING,lp->line,
				   NULL);
		  Ctrl->command(cmd);
		  alcstrDestroy(cmd);
		}
	      /* $BAw?.%G!<%?=*N;(B */
	      Ctrl->command( alcstrConcatenate(SendPlugin," END") );
	    }
	  ALCSTR_END;
	  /* $BAw?.Js9p(B */
	  Ctrl->systemMessage("Called log has sended.");
	  /* $BAw?.%G!<%?$J$7(B */
	  cp->sendStart=NULL;
	}

      /* $BITMW$J%m%0$r:o=|(B */
      while(cp->logLines!=NULL)
	{
	  LOGLINE *lp;
	  /* $BE>Aw$9$k:G=i$N9T$J$i5Q2<(B */
	  lp=plistGetItem(cp->logLines,0);
	  if(lp==cp->sendStart)
	    break;
	  /* 12$B;~4V0J>e$O;~8z(B */
	  if((now-lp->time)<12*60*60)
	    {
	      /* JOIN$B;~!"$b$7$/$OE>Aw;~$N%P%C%/%m%0$N9T?t0J2<$J$i5Q2<(B */
	      if(plistNumberOfItem(cp->logLines)
		 <= ( (JoinBacklogLines > SendBacklogLines )
		      ? JoinBacklogLines : SendBacklogLines  ) )
		break;
	    }
	  /* $B%m%09T:o=|(B */
	  LogLineDestroy(cp,lp);
	}

      /* $B0l9T$b$J$/$J$C$?%m%0%A%c%s%M%k$O:o=|(B */
      if(cp->logLines==NULL)
	LogChannelDestroy(cp);
    }
  PLISTLOOP_END;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                 $B%/%i%$%"%s%HA`:n(B                 $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/*
 * $B%/%i%$%"%s%H(BJOIN$B;~$KN.$9>pJs$O!"(B
 * :$NICKNAME!$USERNAME@$ADDRESS JOIN $CHANNEL
 * :$SERVER 332 $NICKNAME $CHANNEL :$TOPIC
 * :$SERVER 353 $NICKNAME = $CHANNEL :$B!&!&!&(B
 *      :
 * :$SERVER 366 $NICKNAME $CHANNEL :End of NAMES list.
 * $B$3$l$i$N8e$K!"$=$N%/%i%$%"%s%H$,(BJOIN$B$9$k$^$G$N%m%0$r$rAw?.$9$k!#(B
 */

#define RESETRETURN \
{\
  alcstrUpdate( &client_tmp,  NULL );\
  alcstrUpdate( &channel_tmp, NULL );\
  ALCSTR_RETURNNOARG;\
}

PLUGINFUNC void
PluginClientWrite( const char *client, const char *line )
{
  static ALCSTR channel_tmp = NULL;
  static ALCSTR client_tmp  = NULL;

  if(line[0]!=':')
    return;
  line++;

  ALCSTR_BEGIN
    {
      ALCSTR cmd;
      cmd=alcstrWord( line, 1 );

      /* $B4X78$N$J$$%a%C%;!<%8(B */
      if( !stringCmp( cmd, "JOIN" )
	  && strcmp( cmd, "332" )!=0
	  && strcmp( cmd, "353" )!=0
	  && strcmp( cmd, "366" )!=0 )
	RESETRETURN;

      /* JOIN$B%a%C%;!<%8!"A4$F$N;O$^$j(B */
      if( stringCmp( cmd, "JOIN" ) )
	{
	  ALCSTR nick;
	  /* JOIN$B$7$??M$N%K%C%/E&=P(B */
	  {
	    int i;
	    for( i=0; line[i]!='!' && line[i]!=' ' && line[i]!='\0'; i++ );
	    if( line[i] != '!' )
	      RESETRETURN;
	    nick = alcstrMiddle( line, 0, i );
	  }
	  /* nick$B$,<+J,$+$I$&$+(B */
	  if( !stringCmp( nick, Ctrl->getNickname() ) )
	    RESETRETURN;
	  /* $B5-O?(B */
	  alcstrUpdate( &client_tmp,  client );
	  alcstrUpdate( &channel_tmp, alcstrWord(line,2) );
	  ALCSTR_RETURNNOARG;
	}
      /* JOIN$B$+$iB3$$$F$J$$>l9g$O$3$l9T$3$&L58z(B */
      else
	{
	  if( client_tmp==NULL
	      || channel_tmp==NULL )
	    RESETRETURN;
	}

      /* :$SERVER 332 $NICKNAME $CHANNEL :$TOPIC */
      if( strcmp( cmd, "332" )==0 )
	{
	  /* $B%A%'%C%/(B */
	  if( !stringCmp( client_tmp, client )
	      || !stringCmp( channel_tmp, alcstrWord(line,3) ) )
	    RESETRETURN;
	  ALCSTR_RETURNNOARG;
	}

      /* :$SERVER 353 $NICKNAME = $CHANNEL :$B!&!&!&(B */
      if( strcmp( cmd, "353" )==0 )
	{
	  /* $B%A%'%C%/(B */
	  if( !stringCmp( client_tmp, client )
	      || !stringCmp( channel_tmp, alcstrWord(line,4) ) )
	    RESETRETURN;
	  ALCSTR_RETURNNOARG;
	}

      /* :$SERVER 366 $NICKNAME $CHANNEL :End of NAMES list. */
      if( strcmp( cmd, "366" )==0 )
	{
	  /* $B%A%'%C%/(B */
	  if( !stringCmp( client_tmp, client )
	      || !stringCmp( channel_tmp, alcstrWord(line,3) ) )
	    RESETRETURN;
	  /* $B%m%0Aw?.(B */
	  {
	    LOGCHANNEL *chp;
	    LOGLINE *lp;
	    int i;
	    /* $B%A%c%s%M%k%m%0<hF@(B */
	    chp=LogChannelGet( channel_tmp );
	    if( !chp )
	      RESETRETURN;
	    /* $BAw?.(B */
	    for( i=0; (lp=plistGetItem(chp->logLines,i)); i++ )
	      {
		ALCSTR msg;
		msg=alcstrFormat(":log PRIVMSG $CHANNEL :$TIME $LOGLINE",
				 "CHANNEL", ASFORMAT_STRING, channel_tmp,
				 "TIME",    ASFORMAT_STRING,
				 ( timeString(&lp->time) ),
				 "LOGLINE", ASFORMAT_STRING, lp->line,
				 NULL);
		Ctrl->writeToClient(client,msg);
		alcstrDestroy(msg);
	      }
	  }
	  RESETRETURN;
	}

    }
  ALCSTR_END;
}
