/*
 * ctcp.c
 *
 * aCHU^Hat $B$N(B CTCP $B%W%i%0%$%s!#(B
 * $B2a>j(BCTCP$B$N%U%#%k%?%j%s%0!"(BCTCP$B$X$N1~Ez$r$9$k!#(B
 */

#ifdef WIN32
#  include <windows.h>
#else
#  ifdef HAVE_CONFIG_H
#    include "config.h"
#  endif
#  include <stdio.h>
#  include <time.h>
#endif

#include <plist.h>
#include <string.h>
#include <bufsock.h>

#include <plugin.h>

static const PluginCtrl *ctrl;
PLUGINFUNC void
PluginInitilize(const PluginCtrl *plugin_control)
{
  ctrl=plugin_control;
}

/* $B@_Dj9`L\(B */
static int    ping_reply = 0;		/* CTCP PING $B$K1~Ez$9$k$+H]$+(B */
static ALCSTR userinfo_message = NULL;	/* USER INFO $B$K1~Ez$9$k$+H]$+(B */
static int    filter_time = 2;		/* CTCP$B%j%W%i%$0l$D$K$D$-%U%#%k%?%j%s%0(B
					   $B$9$k;~4V(B */
static int    filter_tolerance = 1;	/* CTCP$B$rMFG'$9$k5vMF;~4V(B */

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                     $B%3%^%s%I(B                     $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

static time_t filter_term = 0;

/* -------------------------------------------------- */
/* =============== $B%-!<%A%'%C%/%^%/%m(B =============== */
/* -------------------------------------------------- */
#define KEYCHECK(keyname,minarg,maxarg) \
if(stringCmp((keyname),key))				\
  {			 				\
    if(words<(minarg))					\
      {							\
	ctrl->returnFunc("Not enough parameters");	\
	ALCSTR_RETURN(1);				\
      }							\
    if(words>(maxarg))					\
      {							\
	ctrl->returnFunc("Too many parameters");	\
	ALCSTR_RETURN(1);				\
      }							\
  }							\
if(stringCmp((keyname),key))

/* -------------------------------------------------- */
/* ================== $B%3%^%s%I2r@O(B ================== */
/* -------------------------------------------------- */
PLUGINFUNC int
PluginCommand(const char *line)
{
  ALCSTR_BEGIN
    {
      int words;
      ALCSTR key;

      /* $B%3%^%s%I<hF@(B */
      key=alcstrWord(line,0);
      words=stringNumberOfWord(line);
      if(key==NULL)
	ALCSTR_RETURN(0);

      /* CTCP PING $B$K1~$8$k$+H]$+(B */
      KEYCHECK("PING",2,2)
	{
	  key=alcstrWord(line,1);
	  if( stringCheckInteger( key ) )
	    ping_reply = atoi(key);
	  else
	    ctrl->systemMessage( "Illegal character(Please input number)." );
	  ALCSTR_RETURN(1);
	}

      /* CTCP USERINFO $B$X$N1~Ez%a%C%;!<%8(B */
      KEYCHECK("USERINFO",1,2)
	{
	  alcstrUpdate( &userinfo_message, alcstrWord(line,1) );
	  ALCSTR_RETURN(1);
	}

      /* CTCP$B%j%W%i%$0l$D$K$D$-%U%#%k%?%j%s%0$9$k;~4V(B */
      KEYCHECK("FILTERTIME",2,2)
	{
	  key=alcstrWord(line,1);
	  if( stringCheckInteger( key ) )
	    filter_time=atoi(key);
	  else
	    ctrl->systemMessage( "Illegal character(Please input number)." );
	  ALCSTR_RETURN(1);
	}

      /* CTCP$B$rMFG'$9$k5vMF;~4V(B */
      KEYCHECK("FILTERTOLERANCE",2,2)
	{
	  key=alcstrWord(line,1);
	  if( stringCheckInteger( key ) )
	    filter_tolerance = atoi(key);
	  else
	    ctrl->systemMessage( "Illegal character(Please input number)." );
	  ALCSTR_RETURN(1);
	}

    }
  ALCSTR_END;
  return 0;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                  $BF~NO%U%#%k%?!<(B                  $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
PLUGINFUNC void
PluginConnectionReadFilter( const char *connection, const char *line )
{
  int through=1, ctcp_filter=0;

  /* CTCP$B$r%U%#%k%?%j%s%0$9$k$+$I$&$+(B */
  ctcp_filter = ( filter_term - time(NULL) ) > filter_tolerance;

  /* $BFI$_9~$_9T$NDL2aH=Dj$*$h$S(BCTCP$B1~Ez(B */
  ALCSTR_BEGIN
    {
      do
	{
	  int start_pos, end_pos;
	  ALCSTR nick, msg, ctcp, ctcp_cmd;

	  /* PRIVMSG$B0J30$ODL2a(B */
	  if(line[0]!=':')
	    break;
	  if( !stringCmp( alcstrWord( line+1, 1 ), "PRIVMSG") )
	    break;
 
	  /* $BH/?.<T<hF@(B */
	  {
	    int i;
	    for( i=1; line[i]!='!' && line[i]!=' ' && line[i]!='\0'; i++ );
	    nick = alcstrMiddle( line, 1, i-1 );
	  }

	  /* $B%a%C%;!<%8<hF@(B */
	  msg=alcstrWord( line+1, 3 );
	  if( !msg )
	    break;

	  /* CTCP$B8!:w%k!<%W(B */
	  for( start_pos=0;
	       msg[start_pos]!='\0';
	       start_pos++ )
	    {
	      if( msg[start_pos]!=0x01 )
		continue;

	      /* $B2a>j(BCTCP$B$O$+$-$9$F$k(B */
	      if( ctcp_filter )
		{
		  through=0;
		  break;
		}

	      /* CTCP$B$N=*C<H=Dj(B */
	      for( end_pos=start_pos+1;
		   msg[end_pos]!='\0' && msg[end_pos]!=0x01;
		   end_pos++ );
	      if( msg[end_pos]=='\0' )
		break;

	      /* CTCP$B$NFbMF<hF@(B*/
	      ctcp = alcstrMiddle( msg, start_pos+1, end_pos-start_pos-1 );
	      ctcp_cmd = alcstrWord( ctcp, 1 );

	      /* CTCP PING $B1~Ez(B */
	      if( ping_reply && stringCmp( ctcp_cmd, "PING" ) )
		{
		  ALCSTR reply_msg;
		  reply_msg = alcstrFormat( "NOTICE $NICK :\001$CTCP\001",
					    "NICK", ASFORMAT_STRING, nick,
					    "CTCP", ASFORMAT_STRING, ctcp,
					    NULL );
		  ctrl->writeToConnection( connection, reply_msg );
		  through=0;
		}
	      else if( userinfo_message && stringCmp( ctcp_cmd, "USERINFO" ) )
		{
		  ALCSTR reply_msg;
		  reply_msg = alcstrFormat( ( "NOTICE $NICK :"
					      "\001USERINFO $INFO\001" ),
					    "NICK", ASFORMAT_STRING, nick,
					    "INFO", ASFORMAT_STRING,
					    ( userinfo_message ),
					    NULL );
		  ctrl->writeToConnection( connection, reply_msg );
		  through=0;
		}

	      /* $B3+;O0LCVJd@5(B */
	      start_pos = end_pos;
	    }
	}
      while( 0 );
    }
  ALCSTR_END;

  /* $BDL2a(B */
  if( through )
    ctrl->returnFunc( line );
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                $B%a%C%;!<%8=q$-9~$_(B                $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
PLUGINFUNC void
PluginConnectionWrite( const char *connection, const char *line )
{
  ALCSTR_BEGIN
    {
      ALCSTR msg;
      int i;

      /* NOTICE$B0J30$ODL2a(B */
      if( !stringCmp( alcstrWord( line, 0 ), "NOTICE") )
	ALCSTR_RETURNNOARG;

      /* $B%a%C%;!<%8<hF@(B */
      msg=alcstrWord( line+1, 2 );
      if( !msg )
	ALCSTR_RETURNNOARG;
 
      /* CTCP$B$J$i$P%+%&%s%H(B */
      for( i=0; msg[i]!='\0' && msg[i]!=0x01; i++ );
      if( msg[i]==0x01 )
	{
	  time_t now;
	  time(&now);
	  if( filter_term < now )
	    filter_term = now + filter_time;
	  else
	    filter_term += filter_time;
	}
    }
  ALCSTR_END;
}
