/*
 * chcare.c
 *
 * aCHU^Hat $B$N(B channel_care $B%W%i%0%$%s!#(B
 * $B%A%c%s%M%k$N4IM}!#EPO?%f!<%6$X$N(B +o, $B;XDj%A%c%s%M%k$X$N3F<o%b!<%I!#(B
 */

#ifdef WIN32
#  include <windows.h>
#else
#  ifdef HAVE_CONFIG_H
#    include "config.h"
#  endif
#  include <stdio.h>
#  include <stdarg.h>
#endif

#include <plist.h>
#include <string.h>
#include <bufsock.h>

#include <plugin.h>

static const PluginCtrl *Ctrl;
PLUGINFUNC void
PluginInitilize(const PluginCtrl *pluginCtrl)
{
  Ctrl=pluginCtrl;
}

#define CAREMODE_i 0x000001
#define CAREMODE_k 0x000002
#define CAREMODE_l 0x000004
#define CAREMODE_m 0x000008
#define CAREMODE_n 0x000010
#define CAREMODE_p 0x000020
#define CAREMODE_s 0x000040
#define CAREMODE_t 0x000080

#define CAREMODE_b 0x010000
#define CAREMODE_e 0x020000
#define CAREMODE_o 0x040000
#define CAREMODE_v 0x080000
#define CAREMODE_I 0x100000

static int ActionDelay=10;
static int ActionRetry=30;

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                 $B%A%c%s%M%k%G!<%?(B                 $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */


/* -------------------------------------------------- */
/* ================= $B%A%c%s%M%k>pJs(B ================= */
/* -------------------------------------------------- */
typedef struct {
  ALCSTR connection;	/* $B%3%M%/%7%g%sL>(B */
  ALCSTR server;	/* $B%5!<%PL>(B */
  ALCSTR network;	/* $B%M%C%H%o!<%/L>(B */
  ALCSTR name;		/* $B%A%c%s%M%kL>(B */
  int    modes;		/* $B@_Dj$5$l$F$$$k%b!<%I(B */
  ALCSTR key;		/* $B%-!<%o!<%I(B(+k$B;XDj;~$N$_(B) */
  int    limit;		/* $B%f!<%6@)8B(B */
  int    modeKnown;	/* $B%b!<%I>pJs$r<hF@$7$?$+H]$+(B */	
  time_t lastAction;	/* $B:G8e$K%"%/%7%g%s$r5/$3$7$?;~4V(B
			   ($B%b!<%I$N@_Dj!"B8:_$N3NG'(B) */
} ChannelData;

PLIST *Channels;

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B<hF@(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static ChannelData*
ChannelData_Get( const char *connection, const char *channel )
{
  PLISTLOOP_BEGIN( chp, ChannelData, Channels )
    {
      if( stringCmp( chp->name, channel )
	  && ( stringCmp( chp->connection, connection )
	       || stringCmp( chp->server, connection )
	       || ( chp->network && stringCmp( chp->network, connection ) ) ) )
	return chp;
    }
  PLISTLOOP_END;

  return NULL;
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $BGK4~(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static void
ChannelData_Destroy( const char *connection, const char *channel )
{
  /* $B%A%c%s%M%k%G!<%?<hF@(B */
  ChannelData *chp;
  chp=ChannelData_Get( connection, channel );
  if(!chp)
    return;

  /* $B%j%9%H$+$i:o=|(B */
  plistDeleteItem( &Channels, chp );

  /* $BCM@_Dj(B */
  if(chp->network) alcstrDestroy(chp->network);
  alcstrDestroy(chp->server);
  alcstrDestroy(chp->connection);
  alcstrDestroy(chp->name);
  if(chp->key) alcstrDestroy(chp->key);

  /* $BNN0h3NJ](B */
  free(chp);
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B@8@.(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static ChannelData*
ChannelData_Create(const char *connection, const char *channel)
{
  const ConnectionInfo *cninfo;
  const ServerInfo *sinfo;
  ChannelData *chp;

  /* $B$9$G$KF1L>$N%G!<%?$,B8:_$9$k>l9g$K$O:o=|(B */
  if( ChannelData_Get( connection, channel ) )
    ChannelData_Destroy( connection, channel );

  /* $B%3%M%/%7%g%s>pJs$*$h$S!"%5!<%P>pJs<hF@(B
     ($B%3%M%/%7%g%sL>!"%5!<%PL>!"%M%C%H%o!<%/L>$rCN$k$?$a(B) */
  cninfo=Ctrl->getConnectionInfo(connection);
  if(!cninfo)
    return NULL;
  sinfo=Ctrl->getServerInfo(cninfo->server);
  if(!sinfo)
    return NULL;

  /* $BNN0h3NJ](B */
  chp=malloc(sizeof(ChannelData));

  /* $BCM@_Dj(B */
  chp->network    = sinfo->network ? alcstrCopySet(sinfo->network) : NULL;
  chp->server     = alcstrCopySet(cninfo->server);
  chp->connection = alcstrCopySet(connection);
  chp->name       = alcstrCopySet(channel);
  chp->modes      = 0;
  chp->key        = NULL;
  chp->limit      = 0;
  chp->modeKnown  = 0;
  time(&chp->lastAction);

  /* $B%j%9%H$KDI2C(B */
  plistAddItem( &Channels, chp );

  return chp;
}

/* -------------------------------------------------- */
/* =================== $B%f!<%6>pJs(B =================== */
/* -------------------------------------------------- */
typedef struct {
  ALCSTR connection;	/* $B%3%M%/%7%g%sL>(B */
  ALCSTR server;	/* $B%5!<%PL>(B */
  ALCSTR network;	/* $B%M%C%H%o!<%/L>(B */
  ALCSTR nickname;	/* $B%K%C%/(B */
  ALCSTR user;		/* $B%f!<%6(B( <$B%f!<%6L>(B>@<$B%"%I%l%9(B ) */
  time_t lastAction;	/* $B:G8e$K%"%/%7%g%s$r5/$3$7$?;~4V(B
			   ($B%b!<%I$N@_Dj!"B8:_$N3NG'(B) */
} UserData;

PLIST *Users;

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B<hF@(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static UserData *
UserData_Get( const char *connection, const char *nickname )
{
  PLISTLOOP_BEGIN( up, UserData, Users )
    {
      if( stringCmp( up->nickname, nickname )
	  && ( stringCmp( up->connection, connection )
	       || stringCmp( up->server, connection )
	       || ( up->network && stringCmp( up->network, connection ) ) ) )
	return up;
    }
  PLISTLOOP_END;

  return NULL;
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $BGK4~(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static void
UserData_Destroy( UserData *up )
{
  /* printf("Destroy %s/%s\n", up->nickname, up->connection ); */
  /* $B%j%9%H$+$i:o=|(B */
  plistDeleteItem( &Users, up );

  /* $BCM@_Dj(B */
  if(up->network) alcstrDestroy(up->network);
  alcstrDestroy(up->server);
  alcstrDestroy(up->connection);
  alcstrDestroy(up->nickname);
  alcstrDestroy(up->user);

  /* $BNN0h3NJ](B */
  free(up);
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B@8@.(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static UserData *
UserData_Create( const char *connection, const char *nickname,
		 const char *user)
{
  const ConnectionInfo *cninfo;
  const ServerInfo *sinfo;
  UserData *up;

  /* $B$9$G$KF1L>$N%G!<%?$,B8:_$9$k>l9g$K$O:o=|(B */
  up=UserData_Get( connection, nickname );
  if( up )
    UserData_Destroy( up );

  /* $B%3%M%/%7%g%s>pJs$*$h$S!"%5!<%P>pJs<hF@(B
     ($B%3%M%/%7%g%sL>!"%5!<%PL>!"%M%C%H%o!<%/L>$rCN$k$?$a(B) */
  cninfo=Ctrl->getConnectionInfo(connection);
  if(!cninfo)
    return NULL;
  sinfo=Ctrl->getServerInfo(cninfo->server);
  if(!sinfo)
    return NULL;

  /* $BNN0h3NJ](B */
  up=malloc(sizeof(UserData));

  /* $BCM@_Dj(B */
  up->network    = sinfo->network ? alcstrCopySet(sinfo->network) : NULL;
  up->server     = alcstrCopySet(cninfo->server);
  up->connection = alcstrCopySet(connection);
  up->nickname   = alcstrCopySet(nickname);
  up->user       = alcstrCopySet(user);
  time(&up->lastAction);

  /* $B%j%9%H$KDI2C(B */
  plistAddItem( &Users, up );

  /* printf("Create %s/%s\n", nickname, connection ); */
  return up;
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B@8@.(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static int
UserData_Nick( UserData *up, const char *new_nickname )
{
  /* printf("Nick %s/%s -> %s\n",
     up->nickname, up->connection, new_nickname ); */
  /* $B$9$G$KF1L>$N%G!<%?$,B8:_$9$k>l9g$K$O:o=|(B */
  {
    UserData *up2;
    up2=UserData_Get( up->connection, new_nickname );
    if( up2 && up2!=up )
      {
	/* printf("!!! Nick collision %s/%s !!!\n",
	   up->connection, new_nickname ); */
	UserData_Destroy( up2 );
      }
  }

  /* $B%K%C%/99?7(B */
  alcstrUpdate( &up->nickname, new_nickname );

  return 1;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                    $B4IM}%G!<%?(B                    $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

/* -------------------------------------------------- */
/* =========== $B%A%c%s%M%k4IM}(B($B%b!<%I@_Dj(B) =========== */
/* -------------------------------------------------- */
typedef struct{
  ALCSTR connection;	/* $B%3%M%/%7%g%s<1JL;R(B
			   ($B%3%M%/%7%g%sL>(Bor$B%5!<%PL>(Bor$B%M%C%H%o!<%/L>(B) */
  ALCSTR name;		/* $B%A%c%s%M%kL>(B */
  int    addModes;	/* $B@_Dj$7$F$*$-$$%b!<%I(B */
  int    removeModes;	/* $B2r=|$7$F$*$-$?$$%b!<%I(B */ 
  ALCSTR key;		/* $B%-!<%o!<%I(B(+k$B;XDj;~$N$_(B) */
  int    limit;		/* $B%f!<%6@)8B(B */
} CareChannel;

static PLIST *CareChannels=NULL;

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B<hF@(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static CareChannel *
CareChannel_Get( const char *connection, const char *name )
{
  PLISTLOOP_BEGIN( cchp, CareChannel, CareChannels )
    {
      if( stringCmp( connection, cchp->connection )
	  && stringCmp( name, cchp->name ) )
	return cchp;
    }
  PLISTLOOP_END;

  return NULL;
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $BGK4~(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static void
CareChannel_Destroy(CareChannel *cchp)
{
  /* $B%j%9%H$+$i:o=|(B */
  plistDeleteItem( &CareChannels, cchp );

  /* $BCM3+J|(B */
  alcstrDestroy(cchp->connection);
  alcstrDestroy(cchp->name);
  alcstrDestroy(cchp->key);

  /* $BNN0h3+J|(B */
  free(cchp);
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B@8@.(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static CareChannel *
CareChannel_Create( const char *connection, const char *name,
		    int addModes, int removeModes, const char *key, int limit )
{
  CareChannel *cchp;

  /* $B$9$G$K@_Dj$5$l$F$$$l$P:o=|(B */
  cchp=CareChannel_Get( connection, name );
  if( cchp )
    CareChannel_Destroy( cchp );

  /* $BNN0h3NJ](B */
  cchp=malloc(sizeof(CareChannel));

  /* $BCM@_Dj(B */
  cchp->connection  = alcstrCopySet(connection);
  cchp->name        = alcstrCopySet(name);
  cchp->addModes    = addModes;
  cchp->removeModes = removeModes;
  cchp->key         = key?alcstrCopySet(key):NULL;
  cchp->limit       = limit;

  /* $B%j%9%H$KDI2C(B */
  plistAddItem( &CareChannels, cchp );

  return cchp;
}

/* -------------------------------------------------- */
/* =============== $B%f!<%64IM}(B($B$J$k$H(B) =============== */
/* -------------------------------------------------- */
typedef struct{
  ALCSTR connection;
  ALCSTR user;
  CPLIST *channels;
} CareUser;

static PLIST *CareUsers=NULL;

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B<hF@(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static CareUser *
CareUser_Get( const char *connection, const char *user )
{
  /* $B$9$G$K@_Dj$5$l$F$$$l$P:o=|(B */
  PLISTLOOP_BEGIN( cup, CareUser, CareUsers )
    {
      if( stringCmp( cup->connection, connection )
	  && stringCmp( cup->user, user ) )
	return cup;
    }
  PLISTLOOP_END;

  return NULL;
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B8!:w(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static CareUser *
CareUser_Search( UserData *up )
{
  ALCSTR_BEGIN
    {
      ALCSTR user;
      user=alcstrFormat( "$NICKNAME!$USER",
			 "NICKNAME", ASFORMAT_STRING, up->nickname,
			 "USER",     ASFORMAT_STRING, up->user,
			 NULL );

      /* $B$9$G$K@_Dj$5$l$F$$$l$P:o=|(B */
      PLISTLOOP_BEGIN( cup, CareUser, CareUsers )
	{
	  if( stringCmp( up->connection, cup->connection ) )
	    {
	      if( stringMatch( user, cup->user ) )
		ALCSTR_RETURN( cup );
	    }
	}
      PLISTLOOP_END;
    }
  ALCSTR_END;

  return NULL;
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $BGK4~(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static void
CareUser_Destroy(CareUser *cup)
{
  /* $B%j%9%H$+$i:o=|(B */
  plistDeleteItem( &CareUsers, cup );

  /* $BCM3+J|(B */
  alcstrDestroy(cup->connection);
  alcstrDestroy(cup->user);
  while( cup->channels!=NULL )
    {
      ALCSTR as;
      as=cplistGetItem( cup->channels, 0 );
      cplistDeleteItem( &cup->channels, as );
      alcstrDestroy( as );
    }

  /* $BNN0h3+J|(B */
  free(cup);
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B@8@.(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static CareUser *
CareUser_Create( const char *connection, const char *user )
{
  CareUser *cup;

  /* $B$9$G$K@_Dj$5$l$F$$$l$P:o=|(B */
  cup=CareUser_Get( connection, user );
  if( cup )
    CareUser_Destroy( cup );

  /* $BNN0h3NJ](B */
  cup=malloc(sizeof(CareUser));

  /* $BCM@_Dj(B */
  cup->connection = alcstrCopySet(connection);
  cup->user       = alcstrCopySet(user);
  cup->channels   = NULL;

  /* $B%j%9%H$KDI2C(B */
  plistAddItem( &CareUsers, cup );

  return cup;
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ---------- $B%A%c%s%M%k%A%'%C%/(B ---------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static int
CareUser_CheckChannel( CareUser *cup, const char *channel )
{
  /* $B%A%c%s%M%k;XDj$,$J$1$l$P>o$K(Btrue */
  if( !cup->channels )
    return 1;

  /* $BBP>]%A%c%s%M%k%j%9%H$r=g$K%A%'%C%/(B */
  {
    int i;
    ALCSTR listChannel;
    for( i=0; (listChannel=cplistGetItem(cup->channels,i)); i++ )
      {
	if( stringCmp( listChannel, channel ) )
	  return 1;
      }
  }

  /* $B3:Ev$9$k$b$N$,$J$1$l$P(Bfalse */
  return 0;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                  $B%b!<%I@_DjBT$A(B                  $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

typedef struct{
  ALCSTR connection;
  ALCSTR channel;
  PLIST  *addO,*removeO;
  PLIST  *addV,*removeV;
  time_t setTime;	/* $B%b!<%I$r@_Dj$9$k;~4V(B */
  int addModes;		/* $B@_Dj$9$k%b!<%I(B */
  int removeModes;	/* $B2r=|$9$k%b!<%I(B */
} WaitingMode;

PLIST *WaitingModes=NULL;

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B<hF@(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static WaitingMode *
WaitingMode_Get( const char *connection, const char *channel )
{
  PLISTLOOP_BEGIN( mp, WaitingMode, WaitingModes )
    {
      if( stringCmp( mp->connection, connection )
	  && stringCmp( mp->channel, channel ) )
	return mp;
    }
  PLISTLOOP_END;

  return NULL;
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $BGK4~(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static void
WaitingMode_Destroy(WaitingMode *mp)
{
  /* $B%j%9%H$+$i:o=|(B */
  plistDeleteItem( &WaitingModes, mp );

  /* $BCM3+J|(B */
  alcstrDestroy(mp->connection);
  alcstrDestroy(mp->channel);
  plistClearItem(&mp->addO);
  plistClearItem(&mp->addV);
  plistClearItem(&mp->removeO);
  plistClearItem(&mp->removeV);

  /* $BNN0h3+J|(B */
  free(mp);
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------------- $B@8@.(B ----------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static WaitingMode *
WaitingMode_Create( const char *connection, const char *channel )
{
  WaitingMode *mp;

  /* $BNN0h3NJ](B */
  mp=malloc(sizeof(WaitingMode));

  /* $BCM@_Dj(B */
  mp->connection = alcstrCopySet(connection);
  mp->channel    = alcstrCopySet(channel);
  time(&mp->setTime);
  mp->setTime+=ActionDelay;
  mp->addModes    = 0;
  mp->removeModes = 0;
  mp->addO    = NULL;
  mp->addV    = NULL;
  mp->removeO = NULL;
  mp->removeV = NULL;

  /* $B%j%9%H$KDI2C(B */
  plistAddItem( &WaitingModes, mp );

  return mp;
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* ----------- $B<hF@$b$7$/$O@8@.(B ----------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
static WaitingMode *
WaitingMode_GetOrCreate( const char *connection, const char *channel )
{
  WaitingMode *mp;

  mp=WaitingMode_Get( connection, channel );
  if( mp )
    return mp;

  return WaitingMode_Create( connection, channel );
}

/* $B!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2!2(B */
/* -------------- $B%f!<%6:o=|(B -------------- */
/* $B!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1!1(B */
/* WaitingMode$B$NA4$F$N%G!<%?$+$i!";XDj$7$?%f!<%6$X$N%b!<%I$r:o=|$9$k(B */ 
static void
WaitingMode_RemoveUser( const char *connection, const char *channel,
			UserData *up )
{
  PLISTLOOP_BEGIN( mp, WaitingMode, WaitingModes )
    {
      int deleted;
      /* $B%3%M%/%7%g%s$*$h$S%A%c%s%M%k%A%'%C%/(B */
      if( !stringCmp( connection, mp->connection )
	  || ( channel && !stringCmp( channel, mp->channel ) ) )
	continue;

      /* $B%b!<%I@_DjBT$A%j%9%H$+$i:o=|(B */
      deleted = ( plistDeleteItem   ( &mp->addO,    up )
		  || plistDeleteItem( &mp->addV,    up )
		  || plistDeleteItem( &mp->removeO, up )
		  || plistDeleteItem( &mp->removeV, up ) );
      /* $B@_Dj$9$k%b!<%I$,$J$/$J$C$?$i=*$j(B */
      if( deleted
	  && !mp->addO && !mp->addV
	  && !mp->removeO && !mp->removeV
	  && !mp->addModes && !mp->removeModes )
	WaitingMode_Destroy(mp);
    }
  PLISTLOOP_END;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                    $B%b!<%I2r<a(B                    $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
#define MAERROR_REPLACE 0x01
#define MAERROR_UNKNOWN 0x02
#define MAERROR_NOARG   0x04
#define MAERROR_INVARG  0x08

static int
analyzeModes( const char *line, int startWord,
	      int *addModes, int *removeModes,
	      ALCSTR *key, int *limit,
	      void (*extendmodeCallback)( int mode, int sign,
					  const char *arg ) )
{
  static struct{
    int modeChar;
    int modeBit;
  } modelist[]={
    { 'i', CAREMODE_i },
    { 'k', CAREMODE_k },
    { 'l', CAREMODE_l },
    { 'm', CAREMODE_m },
    { 'n', CAREMODE_n },
    { 'p', CAREMODE_p },
    { 's', CAREMODE_s },
    { 't', CAREMODE_t },
    { 'b', CAREMODE_b },
    { 'e', CAREMODE_e },
    { 'o', CAREMODE_o },
    { 'v', CAREMODE_v },
    { 'I', CAREMODE_I }
  };
  int error=0;
  int cmdPos, argPos;
  cmdPos=startWord;
  argPos=cmdPos+1;

  ALCSTR_BEGIN
    {
      for(;;)
	{
	  int charNo,sign;
	  ALCSTR cmd;
	  cmd=alcstrWord(line,cmdPos);
	  if(cmd==NULL)
	    break;
	  sign=1;

	  for( charNo=0; cmd[charNo]!='\0'; charNo++ )
	    {
	      int modeNo;
	      /* $BId9f(B */
	      if( cmd[charNo]=='+' || cmd[charNo]=='-' )
		{
		  sign=(cmd[charNo]=='+');
		  continue;
		}
	      /* $B%b!<%I$NJ8;z(B */
	      for( modeNo=0;
		   modeNo<sizeof(modelist)/sizeof(modelist[0]);
		   modeNo++ )
		{
		  /* $BJ8;z$N%A%'%C%/(B */
		  if( cmd[charNo] != modelist[modeNo].modeChar )
		    continue;
		  /* $B3HD%%b!<%I(B($BJ#?t@_Dj2DG=$J%b!<%I(B) */
		  if( modelist[modeNo].modeBit&0x7FFF0000 )
		    {
		      ALCSTR arg;
		      /* $B0z?t$N%A%'%C%/(B */
		      arg=alcstrWord( line, argPos++ );
		      if(arg==NULL)
			{
			  error|=MAERROR_NOARG;
			  continue;
			}
		      /* $B$=$b$=$b%3!<%k%P%C%/$N;XDj$,$J$1$l$P%(%i!<(B */
		      if( extendmodeCallback==NULL )
			{
			  error|=MAERROR_UNKNOWN;
			  continue;
			}
		      /* $B%3!<%k%P%C%/8F$S=P$7(B */
		      extendmodeCallback( modelist[modeNo].modeBit,
					  sign, arg );
		      continue;
		    }
		  /* $B$=$l0J30$N%b!<%I(B */
		  /* $B4{$K;XDj$7$?%-!<$N%A%'%C%/(B */
		  if( ( removeModes
			&& ( (*addModes|*removeModes)
			     & modelist[modeNo].modeBit) )
		      || ( !removeModes
			   && (  sign ^ ((*addModes
					  & modelist[modeNo].modeBit)!=0) ) ) )
		    error|=MAERROR_REPLACE;
		  /* $B%S%C%H@_Dj(B */
		  if(sign)
		    {
		      *addModes|=modelist[modeNo].modeBit;
		      if(removeModes)
			*removeModes&=~modelist[modeNo].modeBit;
		    }
		  else
		    {
		      *addModes&=~modelist[modeNo].modeBit;
		      if(removeModes)
			*removeModes|=modelist[modeNo].modeBit;
		    }
		  /* $B%-!<%o!<%I(B */
		  if( sign && modelist[modeNo].modeBit==CAREMODE_k )
		    {
		      ALCSTR as;
		      as=alcstrWord( line, argPos++ );
		      /* $B0z?t$NB8:_%A%'%C%/(B */
		      if( as==NULL )
			{
			  error|=MAERROR_NOARG;
			  continue;
			}
		      /* $B@_Dj(B */
		      alcstrUpdate( key, as);
		    }
		  /* $B?M?t@)8B(B */
		  if( sign && modelist[modeNo].modeBit==CAREMODE_l )
		    {
		      ALCSTR as;
		      as=alcstrWord( line, argPos++ );
		      /* $B0z?t$NB8:_%A%'%C%/(B */
		      if( as==NULL )
			{
			  error|=MAERROR_NOARG;
			  continue;
			}
		      /* $B0z?t$NCM%A%'%C%/(B */
		      if( atoi(as)<=0 )
			{
			  error|=MAERROR_INVARG;
			  continue;
			}
		      /* $B@_Dj(B */
		      *limit=atoi(as);
		    }
		}
	      /* $B:G8e$^$G$$$C$?$iCN$i$J$$%b!<%I(B */
	      if( modeNo<sizeof(modelist)/sizeof(modelist[0]) )
		error|=MAERROR_UNKNOWN;
	    }
	  cmdPos=argPos+1;
	  argPos=cmdPos+1;
	}
    }
  ALCSTR_END;

  return error;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                     $B%3%^%s%I(B                     $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

/* -------------------------------------------------- */
/* =============== $B%-!<%A%'%C%/%^%/%m(B =============== */
/* -------------------------------------------------- */
#define KEYCHECK(keyname,minarg,maxarg) \
if(stringCmp((keyname),key))				\
  {			 				\
    if(numWords<(minarg))				\
      {							\
	Ctrl->returnFunc("Not enough parameters");	\
	ALCSTR_RETURN(1);				\
      }							\
    if(numWords>(maxarg))				\
      {							\
	Ctrl->returnFunc("Too many parameters");	\
	ALCSTR_RETURN(1);				\
      }							\
  }							\
if(stringCmp((keyname),key))

/* -------------------------------------------------- */
/* ================== $B%3%^%s%I2r@O(B ================== */
/* -------------------------------------------------- */
PLUGINFUNC int
PluginCommand(const char *line)
{
  ALCSTR_BEGIN
    {
      int numWords;
      ALCSTR key;
      /* $B%3%^%s%I<hF@(B */
      key=alcstrWord(line,0);
      numWords=stringNumberOfWord(line);
      if(key==NULL)
	ALCSTR_RETURN(0);

      /* $B%A%c%s%M%k4IM}(B */
      KEYCHECK("CHANNEL",4,256)
	{
	  int    addModes=0;
	  int    removeModes=0;
	  ALCSTR key=NULL;
	  int    limit=0;
	  /* $B%b!<%I9T2r@O(B */
	  if( analyzeModes( line, 4,
			    &addModes, &removeModes, &key, &limit, NULL ) )
	    {
	      if(key)
		alcstrDestroy(key);
	      Ctrl->returnFunc("mode error.");
	      ALCSTR_RETURN(1);
	    }
	  /* $B@_Dj(B */
	  CareChannel_Create( alcstrWord( line, 1 ),
			      alcstrWord( line, 2 ),
			      addModes, removeModes, key, limit );
	  ALCSTR_RETURN(1);
	}

      /* $B<+F0$J$k$H(B */
      KEYCHECK("AUTOOP",3,256)
	{
	  CareUser *cup;
	  int chno;
	  cup=CareUser_Create( alcstrWord(line,1), alcstrWord(line,2) );
	  for( chno=3; chno<numWords; chno++ )
	    cplistAddItem( &cup->channels, alcstrSet(alcstrWord(line,chno)) );
	  ALCSTR_RETURN(1);
	}

      /* $BCY1d(B */
      KEYCHECK("DELAY",2,2)
	{
	  ActionDelay=atoi(alcstrWord(line,1));
	  ALCSTR_RETURN(1);
	}

      /* $B:F;n9T(B */
      KEYCHECK("RETRY",2,2)
	{
	  ActionRetry=atoi(alcstrWord(line,1));
	  ALCSTR_RETURN(1);
	}
    }
  ALCSTR_END;
  return 0;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                 $B%a%C%;!<%8Aw<u?.(B                 $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */

/* -------------------------------------------------- */
/* ============== $B<+J,$N$J$k$H%A%'%C%/(B ============== */
/* -------------------------------------------------- */
static int
checkOperator( const ConnectionInfo *cninfo,
	       const char *connection, const char *channel )
{
  /* $B%A%c%s%M%k>pJs<hF@(B */
  const ChannelInfo *chinfo;
  chinfo = Ctrl->getChannelInfo( connection, channel );
  if( !chinfo )
    return 0;

  /* $B<+J,$N$J$k$H$r3NG'(B */
  {
    int i;
    for( i=0; i<chinfo->numUsers; i++ )
      {
	if( stringCmp( chinfo->users[i].nick, cninfo->nickname ) )
	  return chinfo->users[i].modeo;
      }
  }

  return 0;
}

/* -------------------------------------------------- */
/* ================= JOIN$B%a%C%;!<%8(B ================= */
/* -------------------------------------------------- */
static void
readJoin( const ConnectionInfo *cninfo,
	  const char *connection, const char *channel,
	  const char *nickname, UserData *up )
{
  /* $B<+J,$N(BJOIN$B$J$i%A%c%s%M%k%G!<%?:n@.(B */
  if( stringCmp( nickname, cninfo->nickname ) )
    ChannelData_Create( connection, channel );
  /* $BB>?M$N%f!<%6$J$i$J$k$H4IM}(B */
  else
    {
      CareUser *cup;
      cup=CareUser_Search(up);
      if( cup && CareUser_CheckChannel(cup,channel)
	  && checkOperator(cninfo,connection,channel) )
	{
	  /* $B%b!<%I@_Dj=`Hw(B */
	  WaitingMode *mp;
	  mp=WaitingMode_GetOrCreate( connection, channel );
	  plistAddItem( &mp->addO, up );
	}
    }
}

/* -------------------------------------------------- */
/* ================= PART$B%a%C%;!<%8(B ================= */
/* -------------------------------------------------- */
static void
readPart( const ConnectionInfo *cninfo,
	  const char *connection, const char *channel,
	  const char *nickname, UserData *up )
{
  /* $B<+J,$N(BPART$B$J$i%A%c%s%M%k%G!<%?:o=|(B */
  if( stringCmp( nickname, cninfo->nickname ) )
    {
      WaitingMode *mp;
      mp=WaitingMode_Get( connection, channel );
      if( mp )
	WaitingMode_Destroy( mp );
    }

  /* $BB>?M$N(BPART$B$J$i$=$N%f!<%6$r%A%'%C%/(B */
  else
    {
      /* $B$=$N%A%c%s%M%k$G$N%b!<%I@_DjBT$A$G$"$l$P%-%c%s%;%k(B */
      if( up )
	{
	  WaitingMode_RemoveUser( connection, channel, up );

	  /* $B:G8e$N%A%c%s%M%k$G$"$l$P%f!<%6%G!<%?:o=|(B */
	  {
	    const UserInfo *uinfo;
	    uinfo = Ctrl->getUserInfo( connection, nickname );
	    if( uinfo->numChannels == 1
		&& stringCmp( uinfo->channels[0], channel ) )
	      UserData_Destroy(up);
	  }
	}
    }
}

/* -------------------------------------------------- */
/* ================= QUIT$B%a%C%;!<%8(B ================= */
/* -------------------------------------------------- */
static void
readQuit( const ConnectionInfo *cninfo,
	  const char *connection,
	  const char *nickname, UserData *up )
{
  if( up )
    {
      /* $B$$$:$l$+$N%A%c%s%M%k$G$N%b!<%I@_DjBT$A$G$"$l$P%-%c%s%;%k(B */
      WaitingMode_RemoveUser( connection, NULL, up );

      /* $B%f!<%6%G!<%?:o=|(B */
      UserData_Destroy(up);
    }
}

/* -------------------------------------------------- */
/* ================= MODE$B%a%C%;!<%8(B ================= */
/* -------------------------------------------------- */
static const ConnectionInfo *readMode_cninfo;
static const char           *readMode_connection;
static const char           *readMode_channel;
static       int             readMode_operator;

static void
readMode_extendmodeCallback( int mode, int sign, const char *arg )
{
  UserData *up;
  /* +o,-o $B0J30$O6=L#$J$7(B */
  if( mode != CAREMODE_o )
    return;
  /* $B%f!<%6%G!<%?<hF@(B */
  up=UserData_Get( readMode_connection, arg );
  if( !up )
    return;

  /* +o $B$N>l9g(B */
  if( sign )
    {
      /* $B<+J,$N(B +o */
      if( stringCmp( arg, readMode_cninfo->nickname ) )
	{
	  readMode_operator=1;
	}
      /* $BB>?M$N(B +o */
      else
	{
	  WaitingMode *mp;
	  if( !readMode_operator )
	    return;

	  mp=WaitingMode_Get( readMode_connection, readMode_channel );
	  if( mp )
	    plistDeleteItem( &mp->addO, up);
	}
    }
  /* -o $B$N>l9g(B */
  else
    {
      /* $B<+J,$N(B -o */
      if( stringCmp( arg, readMode_cninfo->nickname ) )
	{
	  readMode_operator=0;
	}
      /* $BB>?M$N(B -o */
      else
	{
	  CareUser *cup;
	  if( !readMode_operator )
	    return;

	  /* $B4IM}BP>]%f!<%6$+$I$&$+%A%'%C%/(B */
	  cup=CareUser_Search( up );
	  if( !cup )
	    return;
	  /* $B4IM}BP>]%A%c%s%M%k$+$I$&$+%A%c%s%M%k(B */
	  if( cup->channels )
	    {
	      int check=0;
	      CPLISTLOOP_BEGIN( channel, const char, cup->channels )
		{
		  if( stringCmp( channel, readMode_channel ) )
		    {
		      check=1;
		      break;
		    }
		}
	      CPLISTLOOP_END;
	      if( !check )
		return;
	    }
	  /* $B$J$k$H>yM?@_Dj(B */
	  {
	    /* $B%b!<%I@_Dj=`Hw(B */
	    WaitingMode *mp;
	    mp=WaitingMode_GetOrCreate( readMode_connection,
					readMode_channel );
	    plistAddItem( &mp->addO, up );
	  }
	}
    }
}

static void
readMode( const ConnectionInfo *cninfo,
	  const char *connection, const char *channel,
	  const char *line )
{
  int addModes=0, removeModes=0;
  ALCSTR key=NULL;
  int limit=0;

  readMode_cninfo     = cninfo;
  readMode_connection = connection;
  readMode_channel    = channel;
  readMode_operator   = checkOperator(cninfo,connection,channel);

  analyzeModes( line, 3, &addModes, &removeModes,
		&key, &limit, readMode_extendmodeCallback );

  /* ALCSTR channel;
     ChannelData *chp;
     channel = alcstrWord( line, 3 );
     chp = ChannelData_Get( connection, channel );
     if( chp )
     {
     analyzeModes( line, 4,
     &chp->modes, NULL, &chp->key, &chp->limit,
     NULL );
     } */
}

/* -------------------------------------------------- */
/* ================= $B%a%C%;!<%8<u?.(B ================= */
/* -------------------------------------------------- */
/* $B%a%C%;!<%8<u?.(B */
PLUGINFUNC void
PluginConnectionRead(const char *connection, const char *line)
{
  /* $B%3%M%/%7%g%s>pJs(B */
  const ConnectionInfo *cninfo;
  cninfo=Ctrl->getConnectionInfo(connection);

  ALCSTR_BEGIN
    {
      int numWords;	/* $BC18l?t(B */
      ALCSTR nick,cmd;	/* $B9TF0$r5/$3$7$??M$N%K%C%/!"%3%^%s%I(B */
      UserData *up;	/* $B9TF0$r5/$3$7$??M$N%f!<%6%G!<%?(B */
      /* $B!V(B:$B!W$G;O$^$k%a%C%;!<%80J30$OL5;k(B */
      if(line[0]!=':')
	ALCSTR_RETURNNOARG;
      line++;
      /* $BC18l?t<hF@(B */
      numWords=stringNumberOfWord(line);
      /* $B%3%^%s%I(B */
      cmd=alcstrWord(line,1);
      if( cmd==NULL )
	ALCSTR_RETURNNOARG;
      /* $B%K%C%/<hF@(B */
      {
	int i;
	for(i=0;line[i]!='!' && ISWORDCHAR(line[i]);i++);
	nick = (line[i]=='!') ? alcstrMiddle(line,0,i) : NULL;
      }
      if( nick && nick[0]=='*' && nick[1]=='\0' )
	ALCSTR_RETURNNOARG;

      /* $B%5!<%P$NF0:n(B */
      if( !nick )
	{
	  /* MODE$B%a%C%;!<%8(B */
	  if( stringCmp(cmd,"MODE") && nick && numWords>=4)
	    {
	      readMode( cninfo, connection, alcstrWord(line,2), line );
	      ALCSTR_RETURNNOARG;
	    }

	  /* MODE$B<hF@(B */
	  if( stringCmp(cmd,"324") && nick && numWords>=4)
	    {
	      ALCSTR channel;
	      ChannelData *chp;
	      channel = alcstrWord( line, 3 );
	      chp = ChannelData_Get( connection, channel );
	      if( chp )
		{
		  analyzeModes( line, 4,
				&chp->modes, NULL, &chp->key, &chp->limit,
				NULL );
		}
	      ALCSTR_RETURNNOARG;
	    }

	  ALCSTR_RETURNNOARG;
	}

      /* $B%f!<%6$NF0:n(B */
      /* $B?75,3NG'$5$l$?%f!<%6$J$i%f!<%6DI2C(B */
      up=UserData_Get( connection, nick );
      if( !up )
	{
	  CareUser *cup;
	  up=UserData_Create( connection, nick,
			      alcstrWord(line,0)+strlen(nick)+1 );

	  /* $B4IM}%f!<%6$J$i$P$J$k$H3NG'(B */
	  cup=CareUser_Search( up );
	  if( cup )
	    {
	      int i,j;
	      const UserInfo *uinfo;
	      uinfo=Ctrl->getUserInfo( connection, nick );
	      if( uinfo )
		{
		  /* $B%f!<%6$N(BJOIN$B$7$F$$$k%A%c%s%M%k$r%A%'%C%/(B */
		  for( i=0; i<uinfo->numChannels; i++ )
		    {
		      const ChannelInfo *cinfo;
		      WaitingMode *mp;
		      /* $B$J$k$HBP>]%A%c%s%M%k$+$I$&$+%A%'%C%/(B */
		      if( !CareUser_CheckChannel( cup, uinfo->channels[i] ) )
			continue;
		      /* $B%A%c%s%M%k>pJs<hF@(B */
		      cinfo=Ctrl->getChannelInfo( connection,
						  uinfo->channels[i] );
		      /* $B%A%c%s%M%k$G$J$k$H$r;}$C$F$k$+%A%'%C%/(B */
		      for( j=0; j<cinfo->numUsers; j++ )
			{
			  if( stringCmp( cinfo->users[i].nick, nick ) )
			    {
			      if( cinfo->users[i].modeo )
				j=cinfo->numUsers;
			      break;
			    }
			}
		      if( j==cinfo->numUsers )
			continue;
		      
		      /* $B%b!<%I@_Dj=`Hw(B */
		      mp=WaitingMode_Create( connection, uinfo->channels[i] );
		      plistAddItem( &mp->addO, up );
		    }
		}
	    }
	}

      /* JOIN$B%a%C%;!<%8(B */
      if( stringCmp(cmd,"JOIN") && nick && numWords>=3 )
	{
	  readJoin( cninfo, connection, alcstrWord(line,2), nick, up );
	  ALCSTR_RETURNNOARG;
	}

      /* PART$B%a%C%;!<%8(B */
      if( stringCmp(cmd,"PART") && nick && numWords>=3 )
	{
	  readPart( cninfo, connection, alcstrWord(line,2), nick, up );
	  ALCSTR_RETURNNOARG;
	}

      /* KICK$B%a%C%;!<%8(B */
      if( stringCmp(cmd,"KICK") && nick  && numWords>=4 )
	{
	  ALCSTR nickname;
	  nickname = alcstrWord( line, 3 );
	  readPart( cninfo, connection, alcstrWord(line,2),
		    nickname, UserData_Get( connection, nick ) );
	  ALCSTR_RETURNNOARG;
	}

      /* NICK$B%a%C%;!<%8(B */
      if( stringCmp(cmd,"NICK") && nick && numWords>=3)
	{
	  if( up )
	    UserData_Nick( up, alcstrWord(line,2) );
	  ALCSTR_RETURNNOARG;
	}

      /* QUIT$B%a%C%;!<%8(B */
      if( stringCmp(cmd,"QUIT") && nick )
	{
	  readQuit( cninfo, connection, nick, up );
	  ALCSTR_RETURNNOARG;
	}

      /* MODE$B%a%C%;!<%8(B */
      if( stringCmp(cmd,"MODE") && nick && numWords>=4)
	{
	  readMode( cninfo, connection, alcstrWord(line,2), line );
	  ALCSTR_RETURNNOARG;
	}

    }
  ALCSTR_END;
}

/* -------------------------------------------------- */
/* =============== $B%f!<%64IM}(B($B$J$k$H(B) =============== */
/* -------------------------------------------------- */
PLUGINFUNC void
PluginConnectionClose(const char *connection, const char *reason)
{
  PLISTLOOP_BEGIN( up, UserData, Users )
    {
      if( stringCmp( up->connection, connection ) )
	UserData_Destroy( up );
    }
  PLISTLOOP_END;
}

/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B!C"#!C(B                    $BDj4|E*=hM}(B                    $B!C"#!C(B */
/* $B!C"#!C(B                                                  $B!C"#!C(B */
/* $B"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%(B */
/* $B"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'"%"'(B */
PLUGINFUNC void
PluginTimer(void)
{
  time_t now;
  time(&now);

  PLISTLOOP_BEGIN( mp, WaitingMode, WaitingModes )
    {
      if( now < mp->setTime )
	continue;

      PLISTLOOP_BEGIN( up, UserData, mp->addO )
	{
	  ALCSTR msg;
	  msg=alcstrFormat( "MODE $CHANNEL +o $NICKNAME",
			    "CHANNEL",  ASFORMAT_STRING, mp->channel,
			    "NICKNAME", ASFORMAT_STRING, up->nickname,
			    NULL );
	  Ctrl->writeToConnection( mp->connection, msg );
	  alcstrDestroy( msg );
	}
      PLISTLOOP_END;
      mp->setTime = now + ActionRetry;

       /* WaitingMode_Destroy(mp); */
    }
  PLISTLOOP_END;

}
