#ifndef __ACHAT_PLUGIN_HEADER__
#define __ACHAT_PLUGIN_HEADER__

/* $B%&%#%s%I%&%:HG(B */
#ifdef WIN32
#  include <windows.h>
#  define PLUGINFUNC __declspec(dllexport)
#  ifdef _USRDLL
#    undef errno
int errno;
#  endif
/* $B$=$l0J30(B */
#else
#  define PLUGINFUNC
#endif

#define PLUGIN_CMD_PRIVMSG "PRIVMSG"
#define PLUGIN_CMD_NOTICE  "NOTICE"

/* $B%M%C%H%o!<%/%G!<%?(B */
typedef struct {
  int numServers;	/* $B%5!<%P?t(B */
  const char **servers;	/* $B%5!<%PL>$NG[Ns(B */
} NetworkInfo;

/* $B%5!<%P%G!<%?(B */
typedef struct{
  const char *network;	/* $B%M%C%H%o!<%/L>(B */
  const char *address;	/* $B%"%I%l%9(B */
  int port;		/* $B%]!<%HHV9f(B */
  const char *password;	/* $B%Q%9%o!<%I(B */
} ServerInfo;

/* $B%3%M%/%7%g%s%G!<%?(B */
typedef struct {
  const char *server;	/* $B%5!<%PL>(B */
  int isConnected;	/* $B@\B3$5$l$F$$$k$+$I$&$+(B */
  const char *nickname;	/* $B<+J,$N%K%C%/(B($B@\B3Cf$G$J$1$l$P(BNULL) */
  int numChannels;	/* JOIN$B$7$F$$$k%A%c%s%M%k?t(B */
  const char **channels;/* $B%A%c%s%M%kL>$NG[Ns(B */
} ConnectionInfo;

/* $B%/%i%$%"%s%H(B */
typedef struct{
  int numChannels;	/* $BI=<($7$F$$$k%A%c%s%M%k?t(B */
  const char *channels;	/* $BI=<($7$F$$$k%A%c%s%M%kL>$NG[Ns(B */
} ClientInfo;

/* $B%f!<%6(B */
typedef struct{
  int numChannels;	/* JOIN$B$7$F$k%A%c%s%M%k?t(B */
  const char **channels;/* $B%A%c%s%M%kL>$NG[Ns(B */
} UserInfo;

/* $B%A%c%s%M%k(B */
typedef struct{
  int modeo;		/* +o$B$5$l$F$$$k$+$I$&$+(B */
  int modev;		/* +v$B$5$l$F$$$k$+$I$&$+(B */
  const char *nick;	/* $B%K%C%/(B */
} ChannelInfoUser;
typedef struct{
  const char *topic;		/* $B%H%T%C%/(B */
  int numUsers;			/* $B%f!<%6?t(B */
  const ChannelInfoUser *users;	/* $B%f!<%6%G!<%?(B */
} ChannelInfo;

typedef struct{
  /* $B%m!<%+%kL><hF@(B */
  const char *(*getLocalName)(const char *connection,const char *globalName);

  /* $B>pJs<hF@(B */
  const NetworkInfo    *(*getNetworkInfo   )(const char *network   );
  const ServerInfo     *(*getServerInfo    )(const char *server    );
  const ConnectionInfo *(*getConnectionInfo)(const char *connection);
  const ClientInfo     *(*getClientInfo    )(const char *client    );
  const ChannelInfo    *(*getChannelInfo   )(const char *connection,
					     const char *channel   );
  const UserInfo       *(*getUserInfo      )(const char *connection,
					     const char *nick      );
  const char *(*getMainConnection)(void);
  const char *(*getNickname)(void);

  /* $B%7%9%F%`%a%C%;!<%8(B */
  void (*systemMessage)(const char *msg);
  /* $B%a%C%;!<%8Aw?.(B */
  void (*writeToConnection)(const char *connection,const char *msg);
  /* PRIVMSG/NOTICE$BH/8@(B */
  void (*writeMessage)( const char *connection, const char *target,
		        const char *cmd, const char *msg );
  /* $B%/%i%$%"%s%H$K%a%C%;!<%8Aw?.(B */
  void (*writeToClient)(const char *client,const char *msg);
  /* aCHU^Hat$B%3%^%s%I$r<B9T(B */
  void (*command)(const char *cmd);

  /* $BJ8;zNs$rJV$9(B */
  int (*returnFunc)(const char *string);
} PluginCtrl;

/* $B=i4|2=(B */
PLUGINFUNC void PluginInitilize(const PluginCtrl *ctrl);

/* 1$BICKh$K8F$S=P$5$l$k4X?t(B */
PLUGINFUNC void PluginTimer(void);
/* aCHU^Hat$B%3%^%s%I!#(B
   $B=hM}ITG=$J%3%^%s%I$J$i$r(B0$B$rJV$9!#(B */
PLUGINFUNC int PluginCommand(const char *cmd);

/* CONNECTION$B$,@\B3$r@ZCG$7$?$H$-$K8F$S=P$5$l$k(B */
PLUGINFUNC void PluginConnectionClose(const char *connection,
				      const char *reason);
/* CONNECTION$B$,%a%C%;!<%8$rFI$_9~$s$@;~8F$S=P$5$l$k4X?t(B */
PLUGINFUNC void PluginConnectionRead(const char *connection, const char *msg);
/* CONNECTION$B$,%a%C%;!<%8$r=q$-9~$`;~8F$S=P$5$l$k4X?t(B */
PLUGINFUNC void PluginConnectionWrite(const char *connection, const char *msg);
/* CONNECTION$B$,FI$_9~$s$@%a%C%;!<%8$r=hM}$9$kA0$KDL$9%U%#%k%?(B */
PLUGINFUNC void PluginConnectionReadFilter( const char *connection,
					    const char *line );
/* CONNECTION$B$,=q$-9~$b$&$H$9$k%a%C%;!<%8$rDL$9%U%#%k%?(B */
PLUGINFUNC void PluginConnectionWriteFilter( const char *connection,
					     const char *line );

/* CLIENT$B$,@\B3$r@ZCG$7$?$H$-$K8F$S=P$5$l$k(B */
PLUGINFUNC void PluginClientClose(const char *connection, const char *reason);
/* CLIENT$B$,%a%C%;!<%8$rFI$_9~$s$@;~8F$S=P$5$l$k4X?t(B */
PLUGINFUNC void PluginClientRead(const char *connection, const char *msg);
/* CLIENT$B$,%a%C%;!<%8$r=q$-9~$`;~8F$S=P$5$l$k4X?t(B */
PLUGINFUNC void PluginClientWrite(const char *connection, const char *msg);
/* CLIENT$B$,FI$_9~$s$@%a%C%;!<%8$r=hM}$9$kA0$KDL$9%U%#%k%?(B */
PLUGINFUNC void PluginClientReadFilter( const char *connection,
					const char *line );
/* CLIENT$B$,=q$-9~$b$&$H$9$k%a%C%;!<%8$rDL$9%U%#%k%?(B */
PLUGINFUNC void PluginClientWriteFilter( const char *connection,
					 const char *line );

#endif /* __ACHAT_PLUGIN_HEADER__ */
