#ifndef __STRING_ADDITION_HEADER__
#define __STRING_ADDITION_HEADER__

#ifdef _WIN32
#  include <windows.h>
#endif

#include <time.h>
#include <stdarg.h>
#include "plist.h"

#define ISSPACE(c)    ((c)==' '  || (c)=='\t')
#define ISLINEFEED(c) ((c)=='\r' || (c)=='\n')
#define ISLINEEND(c)  ((c)=='\r' || (c)=='\n' || (c)=='\0')
#define ISWORDCHAR(c) (!ISSPACE(c) && !ISLINEEND(c))

int  stringNumberOfWord(const char *st);
int  stringCmp(const char *st1,const char *st2);
int  stringLeftCmp(const char *st1,const char *st2);
int  stringMatch(const char *st,const char *cnd);
int  stringCheckInteger( const char *st );
char *stringTime(const time_t *time);

char *stringJIStoMSKanji(char *ret,int len,const char *st);


/* $B%"%m%1!<%7%g%sHG(B */
typedef const char *ALCSTR;

#define ALCSTR_ALLOCEDLISTDPTH 256
extern PLIST *alcstrAllocdPointerList[ALCSTR_ALLOCEDLISTDPTH];
extern int    alcstrAllocdPointerDepth;
extern PLIST *alcstrAllocdPointerAll;

#define ALCSTR_BEGIN {\
  if(++alcstrAllocdPointerDepth==ALCSTR_ALLOCEDLISTDPTH) *(int*)0=0;\
  alcstrAllocdPointerList[alcstrAllocdPointerDepth]=NULL;

/* printf("ALCSTR_BEGIN(%s:%d) depth:%d\n",__FILE__,__LINE__,alcstrAllocdPointerDepth);
printf("ALCSTR_END(%s:%d) depth:%d\n",__FILE__,__LINE__,alcstrAllocdPointerDepth);\ */

#define ALCSTR_EXIT for(;;){\
  char *cp;\
  if(alcstrAllocdPointerList[alcstrAllocdPointerDepth]==NULL){\
    alcstrAllocdPointerDepth--;\
    break;\
  }\
  cp=plistGetItem(alcstrAllocdPointerList[alcstrAllocdPointerDepth],0);\
  alcstrDestroy(cp);\
}
#define ALCSTR_BREAK       { ALCSTR_EXIT; break;      }
#define ALCSTR_CONTINUE    { ALCSTR_EXIT; continue;   }
#define ALCSTR_RETURN(val) { ALCSTR_EXIT; return val; }
#define ALCSTR_RETURNNOARG { ALCSTR_EXIT; return;     }

#define ALCSTR_END ALCSTR_EXIT; }

/* $B@8@.$HGK4~(B */
ALCSTR alcstrSet(ALCSTR as);
ALCSTR alcstrUp(ALCSTR as);
void   alcstrDestroy(ALCSTR as);
/* $B%3%T!<(B */
ALCSTR alcstrCopy(const char *st);
ALCSTR alcstrCopySet(const char *st);
ALCSTR alcstrUpdate(ALCSTR *asp,const char *st);
/* $B2~9T!&I|5"$r:o=|(B */
ALCSTR alcstrDeleteCRLF  (const char *st);
ALCSTR realcstrDeleteCRLF(ALCSTR *asp);
/* $BCf4VJ8;zNs(B */
ALCSTR alcstrMiddle(const char *st,int start,int len);
ALCSTR realcstrMiddle(ALCSTR *asp ,int start,int len);
ALCSTR alcstrWord(const char *st,int index);
/* $BO"7k(B */
ALCSTR alcstrConcatenate (const char *st1,const char *st2);
ALCSTR alcstrConcatenateF(const char *stcp,const char *fmt,...);
ALCSTR realcstrConcatenate (ALCSTR *asp,const char *cp2);
ALCSTR realcstrConcatenateF(ALCSTR *asp,const char *fmt,...);
/* $B%U%)!<%^%C%H@8@.(B */
ALCSTR alcstrFormat(const char *fmt,...);
ALCSTR alcstrFormatV(const char *fmt,va_list args);
/* $BJ8;z%3!<%IJQ49(B */
ALCSTR alcstrJIStoMSKanji(const char *st);
ALCSTR alcstrMSKanjitoJIS(const char *st);

#define ASFORMAT_INT    0
#define ASFORMAT_STRING 1
#define ASFORMAT_CHAR   2
#define ASFORMAT_DOUBLE 3

#endif
