#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "string.h"
#define ENDOFLINE(c) ((c)=='\r' || (c)=='\n' || (c)=='\0')

int stringNumberOfWord(const char *st){
  int count;
  if(st==NULL) return 0;

  for(count=0;;count++){
    for(;ISSPACE(*st);st++);
    if(ISLINEEND(*st)) return count;
    if(*st==':') return count+1;
    for(;ISWORDCHAR(*st);st++);
  }
}

int stringCmp(const char *st1,const char *st2){
  int c1,c2;
  if(st1==NULL || st2==NULL) return 0;
  for(;;){
    c1=*(st1++); if(c1>='a' && c1<='z') c1+='A'-'a'; 
    c2=*(st2++); if(c2>='a' && c2<='z') c2+='A'-'a';
    if(c1!=c2) return 0;
    if(c1=='\0') return 1;
  }
}

static int
stringMatch_WithJISKey(const char *st ,int stmode,
		       const char *cnd,int cndmode)
{
  for(;;){
    /*  p[hSp[h ڍs`FbN */
    if(*cnd==0x1B)
      {
	if(cnd[1]==0x24 && cnd[2]==0x42)
	  /* Sp[h */
	  {
	    cnd+=3;
	    cndmode=1;
	    continue;
	  }
	else
	  /* p[h */
	  {
	    cnd++;
	    cnd+=(*cnd!='\0');
	    cnd+=(*cnd!='\0');
	    cndmode=0;
	    continue;
	  }
      }
    /*  p[hSp[h ڍs`FbN */
    if(*st==0x1B)
      {
	if(st[1]==0x24 && st[2]==0x42)
	  /* Sp[h */
	  {
	    st+=3;
	    stmode=1;
	    continue;
	  }
	else
	  /* p[h */
	  {
	    st++;
	    st+=(*st!='\0');
	    st+=(*st!='\0');
	    stmode=0;
	    continue;
	  }
      }

    /* Ō܂Ń`FbNł琬 */
    if(*cnd=='\0' && *st=='\0')
      return 1;
    /* p[hȂu?vсu*v̔ */
    if(cndmode==0)
      {
	if(*cnd=='?')
	  {
	    /* i߂ */
	    if(stmode==1)
	      st+=(*st!='\0');
	    if(*st=='\0')
	      return 0;
	    st++;
	    /* i߂ */
	    cnd++;

	    continue;
	  }
	if(*cnd=='*')
	  {
	    /* u*v̂낪낦΃}b` */
	    if(stringMatch_WithJISKey(st,stmode, cnd+1,cndmode))
	      return 1;
	    /* łȂΕi߂ */
	    if(stmode==1)
	      st+=(*st!='\0');
	    if(*st=='\0')
	      return 0;
	    st++;

	    continue;
	  }
	/* p[hȂ̂ɁA񂪑Sp̏ꍇ̓G[ */
	if(stmode!=0)
	  return 0;
	/* `FbN */
	{
	  int c1,c2;
	  c1=*st;
	  if(c1>='a' && c1<='z')
	    c1+='A'-'a';
	  c2=*cnd;
	  if(c2>='a' && c2<='z')
	    c2+='A'-'a';

	  if(c1!=c2)
	    return 0;
	}
	/* ̕Ȁ */
	st++;
	cnd++;
      }
    else
      {
	/* ꕶڃ`FbN */
	if(*st!=*cnd)
	  return 0;
	st++;
	cnd++;
	/* 񕶎ڃ`FbN */
	if(*st!=*cnd)
	  return 0;
	if(*st=='\0')
	  return 1;
	st++;
	cnd++;
      }
  }
}

int stringMatch(const char *st,const char *cnd)
{
  if(st==NULL || cnd==NULL)
    return 0;

  return stringMatch_WithJISKey(st,0,cnd,0);
}


int stringLeftCmp(const char *st1,const char *st2){
  int c1,c2;
  if(st1==NULL || st2==NULL) return 0;
  for(;;){
    c1=*(st1++); if(c1>='a' && c1<='z') c1+='A'-'a'; 
    c2=*(st2++); if(c2>='a' && c2<='z') c2+='A'-'a';
    if(c2=='\0') return 1;
    if(c1!=c2) return 0;
  }
}

int
stringCheckInteger( const char *st )
{
  int result=0;

  /* ÕXy[X */
  while( ISSPACE(*st) )
    st++;

  /*  */
  if( *st=='-' || *st=='+' )
    st++;
  /*  */
  while( *st>='0' && *st<='9' )
    st++, result=1;

  /* ̃Xy[X */
  while( ISSPACE(*st) )
    st++;

  /* ŕ񂪏IĂȂ΁Aȕ */
  if( *st!='\0' )
    result=0;

  return result;
}

static char ctime_buf[26];
char *stringTime(const time_t *tim){
  if(tim==NULL) return NULL;
  strcpy(ctime_buf,ctime(tim));
  ctime_buf[24]='\0';
  return(ctime_buf);
}

char *stringJIStoMSKanji(char *ret,int len,const char *st){
  int mode=0,i,j;
  if(len<=0) return NULL;

  for(i=j=0;st[i]!='\0';){
    /* p[h */
    if(mode==0){
      /* Sp[h */
      if(st[i]==0x1B && st[i+1]==0x24 && st[i+2]==0x42){
	i+=3;
	mode=1;
	continue;
      }
      if(j>len-2) break;
      ret[j++]=st[i++];
    }
    /* Sp[h */
    else{
      /* p[h */
      if(st[i]==0x1B){
	if(st[i+1]=='\0' || st[i+2]=='\0') break;
	i+=3;
	mode=0;
	continue;
      }
      if(j>len-3 || st[i+1]=='\0') break;
      /* ʃrbgϊ */
      ret[j]=((st[i]<0x5F)? (st[i]-0x21)/2+0x81: (st[i]-0x5F)/2+0xE0);
      /* ʃrbg */
      ret[j+1]=st[i+1]-0x21+(((st[i]&1)==1)?0x40:0x9F);

      i+=2;
      j+=2;
    }
  }
  ret[j]='\0';
  return ret;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                 AP[V                 bb */
/* bb                                                  bb */
/*  */
/*  */

PLIST *alcstrAllocdPointerList[ALCSTR_ALLOCEDLISTDPTH];
int    alcstrAllocdPointerDepth=-1;
PLIST *alcstrAllocdPointerAll=NULL;

/* -------------------------------------------------- */
/* ======================  ====================== */
/* -------------------------------------------------- */
static char *alcstrCreate(size_t length){
  char  *cp;

  /* ̈m */
  cp=malloc(length+1);
  /* mۂ̈Xgɒǉ */
  if(alcstrAllocdPointerDepth>=0){
    plistAddItem(&alcstrAllocdPointerList[alcstrAllocdPointerDepth],cp);
  }
  // plistAddItem(&alcstrAllocdPointerAll,cp);

  return cp;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ---------------- Ċm ---------------- */
/* PPPPPPPPPPPPPPPPPPPP */
static char *realcstrCreate(const char *old,size_t length){
  int depth;
  char *cp;

  /* ̈m */
  cp=malloc(length+1);

  /* mۂ̈Xgɒǉ */
  for(depth=0;depth<=alcstrAllocdPointerDepth;depth++){
    if(plistGetIndex(alcstrAllocdPointerList[depth],(void*)old)>=0){
      plistAddItem(&alcstrAllocdPointerList[depth],cp);
    }
  }
  // plistAddItem(&alcstrAllocdPointerAll,cp);

  return cp;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ---------------- Zbg ---------------- */
/* PPPPPPPPPPPPPPPPPPPP */
/* ALCSTR_ENDɊJȂ悤ɂ */ 
ALCSTR alcstrSet(ALCSTR as){
  int depth;
  /* Xg폜 */
  for(depth=0;depth<=alcstrAllocdPointerDepth;depth++){
    if(plistGetIndex(alcstrAllocdPointerList[depth],(void*)as)>=0){
      plistDeleteItem(&alcstrAllocdPointerList[depth],(void*)as);
    }
  }
  return as;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ---------------- Abv ---------------- */
/* PPPPPPPPPPPPPPPPPPPP */
/* ALCSTR_ENDŊJȂ悤ɂ */ 
ALCSTR alcstrUp(ALCSTR as){
  int depth;
  /* Xg폜 */
  for(depth=0;depth<=alcstrAllocdPointerDepth;depth++){
    if(plistGetIndex(alcstrAllocdPointerList[depth],(void*)as)>=0){
      plistDeleteItem(&alcstrAllocdPointerList[depth],(void*)as);
      if(depth>0){
	plistAddItem(&alcstrAllocdPointerList[depth-1],(void*)as);
      }
    }
  }
  return as;
}

/* -------------------------------------------------- */
/* ====================== j ====================== */
/* -------------------------------------------------- */
void alcstrDestroy(ALCSTR as){
  int depth;
  // char *cp=NULL;

  /* 쐬ALCSTRXg猟 */
  /* PLISTLOOP_BEGIN(p,void,alcstrAllocdPointerAll){
     if((ALCSTR)p!=as) continue;
     cp=p;
     }PLISTLOOP_END; */

  /* ΋p */
  // if(cp==NULL) return;

  /* 쐬Xg폜 */
  // plistDeleteItem(&alcstrAllocdPointerAll,cp);
  for(depth=0;depth<=alcstrAllocdPointerDepth;depth++){
    if(plistGetIndex(alcstrAllocdPointerList[depth],(void*)as)<0) continue;
    plistDeleteItem(&alcstrAllocdPointerList[depth],(void*)as);
  }

  /* ̈J */
  free((void*)as);
}

/* -------------------------------------------------- */
/* ===================== Rs[ ===================== */
/* -------------------------------------------------- */
ALCSTR alcstrCopy(const char *st){
  char *ret;
  ret=alcstrCreate(strlen(st));
  strcpy(ret,st);
  return ret;
}

ALCSTR alcstrCopySet(const char *st){
  return alcstrSet(alcstrCopy(st));
}

/* -------------------------------------------------- */
/* ====================== XV ====================== */
/* -------------------------------------------------- */
ALCSTR alcstrUpdate(ALCSTR *asp,const char *st){
  /* NULL̏ꍇ́AJNULL*/
  if(st==NULL){
    if(*asp!=NULL) alcstrDestroy(*asp);
    return *asp=NULL;
  }
  /* 悪NULL̏ꍇ̓Rs[ */
  if(*asp==NULL){
    return *asp=alcstrCopySet(st);
  }
  /* XV */
  if(strcmp(*asp,st)==0) return *asp;
  {
    char *ret;
    ret=realcstrCreate(*asp,strlen(st));
    strcpy(ret,st);
    alcstrDestroy(*asp);
    return *asp=ret;
  }
}

/* -------------------------------------------------- */
/* ================ sEA폜 ================ */
/* -------------------------------------------------- */
ALCSTR alcstrDeleteCRLF(const char *st){
  int i;
  for(i=0;!ISLINEEND(st[i]);i++);
  return alcstrMiddle(st,0,i);
}

ALCSTR realcstrDeleteCRLF(ALCSTR *asp){
  int i;
  for(i=0;!ISLINEEND((*asp)[i]);i++);
  return realcstrMiddle(asp,0,i);
}

/* -------------------------------------------------- */
/* =================== ԕ =================== */
/* -------------------------------------------------- */
ALCSTR alcstrMiddle(const char *st,int start,int len){
  int i;
  char *cp;
  if(len>=0){
    if((int)strlen(st)<start+len) return NULL;
  }else{
    len=strlen(st)-start;
  }
  cp=alcstrCreate(len);
  for(i=0;i<len;i++) cp[i]=st[start+i];
  cp[len]='\0';
  return cp;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* --------------- Ċm۔ --------------- */
/* PPPPPPPPPPPPPPPPPPPP */
ALCSTR realcstrMiddle(ALCSTR *asp,int start,int len){
  int i;
  char *cp;
  if(len>=0){
    if((int)strlen(*asp)<start+len) return NULL;
  }else{
    len=strlen(*asp)-start;
  }
  cp=realcstrCreate(*asp,len);
  for(i=0;i<len;i++) cp[i]=(*asp)[start+i];
  cp[len]='\0';
  alcstrDestroy(*asp);
  return *asp=cp;
}

/* -------------------------------------------------- */
/* ====================== A ====================== */
/* -------------------------------------------------- */
ALCSTR alcstrConcatenate(const char *st1,const char *st2){
  char *cp;
  int len1,len2;
  len1=strlen(st1);
  len2=strlen(st2);
  cp=alcstrCreate(len1+len2);
  strcpy(cp     ,st1);
  strcpy(cp+len1,st2);
  return cp;
}

/* tH[}bgΉ */
ALCSTR alcstrConcatenateF(const char *cp,const char *fmt,...){
  ALCSTR as;
  ALCSTR_BEGIN{
    ALCSTR tmp;
    va_list args;
    va_start(args,fmt);
    tmp=alcstrFormatV(fmt,args);
    va_end(args);
    as=alcstrUp(alcstrConcatenate(cp,tmp));
  }ALCSTR_END;
  return as;
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* --------------- Ċm۔ --------------- */
/* PPPPPPPPPPPPPPPPPPPP */
ALCSTR realcstrConcatenate(ALCSTR *asp,const char *st2){
  char *cp;
  int len1,len2;
  len1=strlen(*asp);
  len2=strlen( st2);
  cp=realcstrCreate(*asp,len1+len2);
  strcpy(cp     ,*asp);
  strcpy(cp+len1, st2);
  alcstrDestroy(*asp);
  return *asp=cp;
}

/* tH[}bgΉ */
ALCSTR realcstrConcatenateF(ALCSTR *asp,const char *fmt,...){
  ALCSTR tmp;
  {
    va_list args;
    va_start(args,fmt);
    tmp=alcstrFormatV(fmt,args);
    va_end(args);
  }
  realcstrConcatenate(asp,tmp);
  alcstrDestroy(tmp);
  return *asp;
}

/* -------------------------------------------------- */
/* ================ tH[}bg ================ */
/* -------------------------------------------------- */
ALCSTR alcstrFormatV(const char *fmt,va_list args){
  ALCSTR as;
  CPLIST *from=NULL,*to=NULL;
  as=alcstrCopy("");
  ALCSTR_BEGIN;

  /* ϊ&ϊ惊Xg쐬 */
  {
    char *key;
    while((key=va_arg(args,char*))!=NULL){
      cplistAddItem(&from,alcstrCopy(key));
      switch(va_arg(args,int)){
	/* \L */
      case ASFORMAT_INT:
	{
	  int val,valabs,valcharp=14;
	  char valchar[16];
	  val=va_arg(args,int);
	  valabs=(val>=0)?val:-val;
	  valchar[15]='\0';
	  do{
	    valchar[valcharp--]=valabs%10+'0';
	    valabs/=10;
	  }while(valabs>0);
	  if(val<0) valchar[valcharp--]='-';
	  cplistAddItem(&to,alcstrCopy(valchar+valcharp+1));
	}
        break;
      /* \L */
      case ASFORMAT_STRING:
	{
	  char *st;
	  st=va_arg(args,char*);
	  if(st!=NULL) cplistAddItem(&to,alcstrCopy(st));
	  else         cplistAddItem(&to,alcstrCopy("(null)"));
	}
        break;
	/*  */
      case ASFORMAT_CHAR:
	{
	  char tmp[2];
	  tmp[0]=va_arg(args,int);
	  tmp[1]='\0';
	  cplistAddItem(&to,alcstrCopy(tmp));
	}
	break;
      }
    }
  }

  /* ϊ */
  {
    int start,len;
int i;
int bit[100];
for(i=0;cplistGetItem(from,i)!=NULL;i++) bit[i]=0;
    for(start=len=0;fmt[start+len]!='\0';len++){
      if(fmt[start+len]=='$'){
	int i;
	ALCSTR key;
	for(i=0;(key=cplistGetItem(from,i))!=NULL;i++){
	  if(stringLeftCmp(fmt+start+len+1,key)){
            realcstrConcatenate(&as,alcstrMiddle(fmt,start,len));
	    realcstrConcatenate(&as,cplistGetItem(to,i));
	    start+=len+strlen(key)+1;
	    len=-1;
bit[i]=1;
	    break;
	  }
	}
/* if(key==NULL) *(int*)0=0; * No such keyword */
      }
    }
/* for(i=0;cplistGetItem(from,i)!=NULL;i++) if(bit[i]==0) *(int*)0=0; * Unused keyword */
    if(len>0) realcstrConcatenate(&as,alcstrMiddle(fmt,start,len));
  }

  cplistClearItem(&from);
  cplistClearItem(&to);
  ALCSTR_END;
  return as;
}

ALCSTR alcstrFormat(const char *fmt,...){
  ALCSTR as;
  va_list args;
  va_start(args,fmt);
  as=alcstrFormatV(fmt,args);
  va_end(args);
  return as;
}

/* -------------------------------------------------- */
/* ==================== PEo ==================== */
/* -------------------------------------------------- */
ALCSTR alcstrWord(const char *st,int index){
  int start,len;
  if(st==NULL) return NULL;

  /* indexŖڂ̒P܂Ői */
  {
    int i;
    for(start=0;st[start]==' ';start++);
    for(i=0;i<index;i++){
      if(st[start]==':') return NULL;
      for(;ISWORDCHAR(st[start]);start++);
      for(;ISSPACE   (st[start]);start++);
    }
  }
  /* ܂łɍsIĂ܂ꍇNULLԂ */
  if(ISLINEEND(st[start])) return NULL;

  /* P̒𒲂ׂ */
  {
    /* u:vŎn܂P͂ȍ~ׂĈPƂ݂Ȃ */
    char f;
    if(st[start]==':'){ f=1; start++; } else f=0;
    /* P̏I[T */
    for(len=0;
	(!ISSPACE(st[start+len]) || f) && !ISLINEEND(st[start+len]);
	len++);
  }
  return alcstrMiddle(st,start,len);
}

/* -------------------------------------------------- */
/* ================= Zbgϊ ================= */
/* -------------------------------------------------- */
ALCSTR
alcstrJIStoMSKanji(const char *st)
{
  int mode,i,j;
  char *ret;
  
  for(i=j=0;st[i]!='\0';i++,j++)
    {
      while(st[i]==0x1B)
	{
	  int k;
	  for( k=0; k<3; k++ )
	    {
	      if(ISLINEEND(st[i+1]))
		break;
	      i++;
	    }
	}
    }
  ret=alcstrCreate(j);

  for( mode=i=j=0; st[i]!='\0'; )
    {
      /* [h */
      if(st[i]==0x1B)
	{
	  if(st[i+1]==0x24 && st[i+2]==0x42)
	    {
	      i+=3;
	      mode=1;
	    }
	  else
	    {
	      int k;
	      for( k=0; k<3; k++ )
		{
		  if(ISLINEEND(st[i]))
		    break;
		  i++;
		}
	      mode=0;
	    }
	  continue;
	}

      /* Sp[h */
      if(mode)
	{
	  if( st   [i  ]<0x21 || st[i  ]>0x7E
	      || st[i+1]<0x21 || st[i+1]>0x7E )
	    {
	      mode=0;
	      continue;
	    }

	  /* 1oCg */
	  if(st[i]<0x5F)
	    ret[j++]=(st[i++]-0x21)/2+0x81;
	  else
	    ret[j++]=(st[i++]-0x5F)/2+0xE0;

	  /* 2oCg */
	  if((st[i-1]&1)==1)
	    {
	      if(st[i]<0x60)
		ret[j++]=st[i++]-0x21+0x40;
	      else
		ret[j++]=st[i++]-0x21+0x41;
	    }
	  else
	    ret[j++]=st[i++]-0x21+0x9F;
	}
      /* p[h */
      else
	ret[j++]=st[i++];
    }

  ret[j]='\0';
  return ret;
}

ALCSTR
alcstrMSKanjitoJIS(const char *st)
{
  int mode,i,j;
  char *ret;

  for(i=j=mode=0;st[i]!='\0';i++,j++){
    if((((unsigned char)st[i]>=0x81 && (unsigned char)st[i]<=0x9F) ||
	((unsigned char)st[i]>=0xE0 && (unsigned char)st[i]<=0xEF)   ) &&
       ((unsigned char)st[i+1]>=0x40 && (unsigned char)st[i+1]<=0xFC)     ){
      if(mode==0) j+=3, mode=1;
      i++;
      j++;
    }else{
      if(mode==1) j+=3,mode=0;
    }
  }
  if(mode==1) j+=3;
  ret=alcstrCreate(j);

  for(i=j=mode=0;st[i]!='\0';){
    if((((unsigned char)st[i]>=0x81 && (unsigned char)st[i]<=0x9F) ||
	((unsigned char)st[i]>=0xE0 && (unsigned char)st[i]<=0xEF)   ) &&
       ((unsigned char)st[i+1]>=0x40 && (unsigned char)st[i+1]<=0xFC)     ){
      if(mode==0){
	ret[j++]=0x1B;
	ret[j++]=0x24;
	ret[j++]=0x42;
	mode=1;
      }
      /* 1oCg */
      if((unsigned char)st[i]<0xE0){
	ret[j]=(st[i++]-0x81)*2+0x21;
      }else{
	ret[j]=(st[i++]-0xE0)*2+0x5F;
      }
      ret[j++]+=((unsigned char)st[i]>0x9E);
      /* 2oCg */
      if((unsigned char)st[i]<0x9F){
	if((unsigned char)st[i]<0x7F){
	  ret[j++]=st[i++]-0x40+0x21;
	}else{
	  ret[j++]=st[i++]-0x80+0x60;
	}
      }else{
	ret[j++]=st[i++]-0x9F+0x21;
      }
    }else{
      if(mode==1){
	ret[j++]=0x1B;
	ret[j++]=0x28;
	ret[j++]=0x42;
	mode=0;
      }
      ret[j++]=st[i++];
    }
  }
  if(mode==1){
    ret[j++]=0x1B;
    ret[j++]=0x28;
    ret[j++]=0x42;
  }
  ret[j]='\0';
  return ret;
}

/*
void main(int argc,char *argv[]){
  char st[256];
  while(fgets(st,256,stdin)!=NULL) ALCSTR_BEGIN{
    printf("%s",alcstrJIStoMSKanji(alcstrMSKanjitoJIS(st)));
  }ALCSTR_END;
}

void main(int argc,char *argv[]){
  printf("%s\n",
	 alcstrFormat("hoehoe $hoe $payo $manyo",
		      "hoe",  ASFORMAT_INT,stringMatch("hoehoepayopayo",argv[1]),
		      "manyo",ASFORMAT_STRING,"munya",
		      NULL));

  PLISTLOOP_BEGIN(cp,char,alcstrAllocdPointerAll){
    printf("alloced:%s\n",cp);
  }PLISTLOOP_END;
}
*/
