#ifndef PLIST_HEADER
#define PLIST_HEADER

typedef struct pointer_list       PLIST;
typedef struct const_pointer_list CPLIST;

struct pointer_list{
  void  *item;
  PLIST *next;
};

struct const_pointer_list{
  const void  *item;
  CPLIST *next;
};

/* -------------------------------------------------- */
/* ================ 萔o[W ================ */
/* -------------------------------------------------- */
PLIST *plistAddItem     (PLIST **ppp,void *item);
int    plistDeleteItem  (PLIST **ppp,void *item);
int    plistChangeItem  (PLIST **ppp,void *old,void *new);
void   plistClearItem   (PLIST **ppp);
int    plistNumberOfItem(PLIST *pp);
void  *plistGetItem     (PLIST *pp,int index);
int    plistGetIndex    (PLIST *pp,void *item);

/* [v}N */
#define PLISTLOOP_BEGINDETAIL(pointer,type,plistp,prepare,loopPrepare) {\
  type *pointer;							\
  int plistLoopCounter;							\
  prepare;								\
  for(plistLoopCounter=0;						\
      ((pointer)=plistGetItem((plistp),plistLoopCounter))!=NULL;	\
      plistLoopCounter+=((pointer)==plistGetItem((plistp),		\
						 plistLoopCounter))){	\
    loopPrepare;

#define PLISTLOOP_BEGIN(pointer,type,plistp) {\
  type *pointer;							\
  int plistLoopCounter;							\
  for(plistLoopCounter=0;						\
      ((pointer)=plistGetItem((plistp),plistLoopCounter))!=NULL;	\
      plistLoopCounter+=((pointer)==plistGetItem((plistp),		\
						 plistLoopCounter))){

#define PLISTLOOP_END }}

/* -------------------------------------------------- */
/* ================= 萔o[W ================= */
/* -------------------------------------------------- */
CPLIST     *cplistAddItem     (CPLIST **ppp,const void *item);
int         cplistDeleteItem  (CPLIST **ppp,const void *item);
void        cplistClearItem   (CPLIST **ppp);
int         cplistNumberOfItem(CPLIST *pp);
const void *cplistGetItem     (CPLIST *pp,int index);
int         cplistGetIndex    (CPLIST *pp,const void *item);

/* [v}N */
#define CPLISTLOOP_BEGINDETAIL(pointer,type,plistp,prepare,loopPrepare) {\
  type *pointer;							\
  int plistLoopCounter;							\
  prepare;								\
  for(plistLoopCounter=0;						\
      ((pointer)=cplistGetItem((plistp),plistLoopCounter))!=NULL;	\
      plistLoopCounter+=((pointer)==cplistGetItem((plistp),		\
						  plistLoopCounter))){	\
    loopPrepare;

#define CPLISTLOOP_BEGIN(pointer,type,plistp) {\
  type *pointer;							\
  int plistLoopCounter;							\
  for(plistLoopCounter=0;						\
      ((pointer)=cplistGetItem((plistp),plistLoopCounter))!=NULL;	\
      plistLoopCounter+=((pointer)==cplistGetItem((plistp),		\
						  plistLoopCounter))){

#define CPLISTLOOP_END }}

#endif
