#ifndef BUFSOCK_IS_DEFINED
#define BUFSOCK_IS_DEFINED

#ifdef _WIN32
#include <windows.h>
#else
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#endif
#include "plist.h"
#include "string.h"

typedef struct buffered_socket *BUFSOCK;


BUFSOCK bufsockCreate(int fd,const char *server,int port);
BUFSOCK bufsockCreateListen (int port);
BUFSOCK bufsockCreateAccept (BUFSOCK listenBufsock);
BUFSOCK bufsockCreateConnect(const char *server,int port);
void    bufsockDestroy    (BUFSOCK bufsock);

int     bufsockGetFD      (BUFSOCK bufsock);
ALCSTR  bufsockGetAddress (BUFSOCK bufsock);
int     bufsockGetPort    (BUFSOCK bufsock);

int     bufsockSetFdset   (BUFSOCK bufsock,fd_set *fds,int maxfd);
int     bufsockIsSetFdset (BUFSOCK bufsock,fd_set *fds);

void    bufsockFlushRead  (BUFSOCK bufsock);
void    bufsockFlushWrite (BUFSOCK bufsock,int wait);
int     bufsockRead       (BUFSOCK bufsock);
ALCSTR  bufsockGetLine    (BUFSOCK bufsock);
int     bufsockWriteString(BUFSOCK bufsock,const char *st);

#endif
