#include "bufsock.h"
#include "string.h"
#ifdef _WIN32
#define read(fd,data,len)  recv(fd,data,len,0)
#define write(fd,data,len) send(fd,data,len,0)
#define close(fd) closesocket(fd)
#endif

struct buffered_socket{
  int     fd;		/* t@CLqq */
  long    lastWrite;	/* Ȍݎ */
  ALCSTR  reading;	/* ǂݍݒ̍s */
  CPLIST *readBuffer;	/* ǂݍݗpobt@ */
  CPLIST *writeBuffer;	/* ݗpobt@ */
  ALCSTR  address;	/* AhX */
  int     port;		/* |[gԍ */
};

/*  */
/*  */
/* bb                                                  bb */
/* bb                    쐬Ɣj                    bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ====================== 쐬 ====================== */
/* -------------------------------------------------- */
BUFSOCK
bufsockCreate(int fd,const char *address,int port)
{
  BUFSOCK bufsock;
  if(fd<0) return NULL;
  bufsock=malloc(sizeof(struct buffered_socket));
  if(bufsock==NULL)
    return NULL;

  bufsock->fd         =fd;
  bufsock->lastWrite  =0;
  bufsock->reading    =alcstrCopySet("");
  bufsock->readBuffer =NULL;
  bufsock->writeBuffer=NULL;
  if(address!=NULL)
    {
      bufsock->address=alcstrCopySet(address);
      bufsock->port   =port;
    }
  else
    {
      bufsock->address=NULL;
      bufsock->port   =-1;
    }

  return bufsock;
}

/* -------------------------------------------------- */
/* ====================== j ====================== */
/* -------------------------------------------------- */
void
bufsockDestroy(BUFSOCK bufsock)
{
  if(bufsock==NULL)
    return;
  /* obt@̃tbV */
  bufsockFlushWrite(bufsock,0);
  bufsockFlushRead(bufsock);
  /*  */
  if(bufsock->fd>=0)
    close(bufsock->fd);
  /* J */
  if(bufsock->address!=NULL)
    alcstrDestroy(bufsock->address);
  free(bufsock);
}

/* -------------------------------------------------- */
/* =================== ̎擾 =================== */
/* -------------------------------------------------- */
int
bufsockGetFD(BUFSOCK bufsock)
{
  return bufsock->fd;
}
ALCSTR
bufsockGetAddress(BUFSOCK bufsock)
{
  return alcstrCopy(bufsock->address);
}
int
bufsockGetPort(BUFSOCK bufsock)
{
  return bufsock->port;
}

/* -------------------------------------------------- */
/* ============== obt@̃tbV ============== */
/* -------------------------------------------------- */
/* QQQQQQQQQQQQQQQQQQQQ */
/* ---------- ǂݍݗpobt@ ---------- */
/* PPPPPPPPPPPPPPPPPPPP */
void
bufsockFlushRead(BUFSOCK bufsock)
{
  CPLISTLOOP_BEGIN(as,const char,bufsock->readBuffer)
    {
      alcstrDestroy(as);
    }
  CPLISTLOOP_END;

  cplistClearItem(&bufsock->readBuffer);
}

/* QQQQQQQQQQQQQQQQQQQQ */
/* ---------- ݗpobt@ ---------- */
/* PPPPPPPPPPPPPPPPPPPP */
#ifndef _WIN32
#include <sys/time.h>
#endif

void
bufsockFlushWrite(BUFSOCK bufsock,int wait)
{
  long now;
#ifdef _WIN32
  {
    SYSTEMTIME st;
    GetSystemTime(&st);
    now = ((st.wHour*60+st.wMinute)*60+st.wSecond)*1000+st.wMilliseconds;
  }
#else
  {
    struct timeval tval;
    gettimeofday(&tval,NULL);
    now = (tval.tv_sec%(24*60*60))*1000 + tval.tv_usec/1000;
  }
#endif
  /* StbV̏ꍇ */
  if(wait<=0)
    {
      CPLISTLOOP_BEGIN(as,const char,bufsock->writeBuffer)
	{
	  if(wait==0)
	    write(bufsock->fd,as,strlen(as));
	  alcstrDestroy(as);
	}
      CPLISTLOOP_END;
      cplistClearItem(&bufsock->writeBuffer);
      if(wait==0) bufsock->lastWrite=now;
    }
  /* tbV̏ꍇ */
  else
    {
      ALCSTR as;
      if( ( now>bufsock->lastWrite+wait
	    || ( now>bufsock->lastWrite+wait-24*60*60*1000
		 && now<bufsock->lastWrite) ) )
	{
	  as=cplistGetItem(bufsock->writeBuffer,0);
	  if( as!=NULL )
	    {
	      cplistDeleteItem(&bufsock->writeBuffer,as);
	      write(bufsock->fd,as,strlen(as));
	      alcstrDestroy(as);
	      bufsock->lastWrite=now;
	    }
	}
    }
}


/*  */
/*  */
/* bb                                                  bb */
/* bb                    select⏕                    bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ===================== Zbg ===================== */
/* -------------------------------------------------- */
int
bufsockSetFdset(BUFSOCK bufsock,fd_set *fds,int maxfd)
{
  /* G[`FbN */
  if(bufsock==NULL)
    return maxfd;
  if(bufsock->fd<0)
    return maxfd;
  /* Zbg */
  FD_SET(bufsock->fd,fds);

  return (bufsock->fd>maxfd)?bufsock->fd:maxfd;
}

/* -------------------------------------------------- */
/* ====================== mF ====================== */
/* -------------------------------------------------- */
int
bufsockIsSetFdset(BUFSOCK bufsock,fd_set *fds)
{
  if(bufsock==NULL)
    return 0;
  if(bufsock->fd<0)
    return 0;

  return FD_ISSET(bufsock->fd,fds);
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                     ǂݍ                     bb */
/* bb                                                  bb */
/*  */
/*  */
int
bufsockRead(BUFSOCK bufsock)
{
  if(bufsock==NULL)
    return 0;
  if(bufsock->fd<0)
    return 0;

  /* ǂݍ */
  {
    int  i,readLength;
    char tmp[1024];
    /* ǂݍ */
    readLength=read(bufsock->fd,tmp,1023);
    if(readLength<=0)
      return 0;
    /* `\0' ꍇ `@' ɕϊ(s̏IƂ݂Ȃ */
    for(i=0;i<readLength;i++)
      {
	if(tmp[i]=='\0')
	  tmp[i]='@';
      }
    tmp[i]='\0';
    /* ǂݍݒsɒǉ */
    realcstrConcatenate(&bufsock->reading,tmp);
  }
  /* ǂݍ݃obt@ɒǉ */
  {
    int start,len;
    for( start=len=0; bufsock->reading[start+len]!='\0'; len++ )
      {
	if(bufsock->reading[start+len]!='\n')
	  continue;
	if(bufsock->reading[start+len-1]=='\r')
	  cplistAddItem(&bufsock->readBuffer,
			alcstrSet(alcstrMiddle(bufsock->reading,start,len-1)));
	else
	  cplistAddItem(&bufsock->readBuffer,
			alcstrSet(alcstrMiddle(bufsock->reading,start,len)));
	start+=len+1;
	len=-1;
      }
    /* ǂݍ݃obt@ɒǉǂݍݒobt@폜 */
    if(start>0)
      realcstrMiddle(&bufsock->reading,start,len);
  }

  return 1;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                   obt@擾                   bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* ==================== s擾 ==================== */
/* -------------------------------------------------- */
ALCSTR
bufsockGetLine(BUFSOCK bufsock)
{
  ALCSTR as,ret;
  /* obt@o */
  as=cplistGetItem(bufsock->readBuffer,0);
  if(as==NULL)
    return NULL;

  /* osobt@폜 */
  cplistDeleteItem(&bufsock->readBuffer,as);

  ret=alcstrCopy(as);
  alcstrDestroy(as);
  return ret;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                                          bb */
/* bb                                                  bb */
/*  */
/*  */

/* -------------------------------------------------- */
/* =====================  ===================== */
/* -------------------------------------------------- */
int
bufsockWriteString(BUFSOCK bufsock,const char *st)
{
  if(bufsock==NULL)
    return 0;
  cplistAddItem(&bufsock->writeBuffer,alcstrCopySet(st));
  return 1;
}

/*  */
/*  */
/* bb                                                  bb */
/* bb                   \Pbg֘A                   bb */
/* bb                                                  bb */
/*  */
/*  */

#ifndef _WIN32
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif

/* -------------------------------------------------- */
/* ==================== ڑҋ@ ==================== */
/* -------------------------------------------------- */
BUFSOCK
bufsockCreateListen(int port)
{
  struct sockaddr_in name;
  int i,fd;

  /* \Pbg쐬 */
  fd=socket(PF_INET,SOCK_STREAM,0);
  if( fd < 0 )
    return NULL;
  {
    int opt=1;
    setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, (void*)&opt, sizeof(int) );
  }

  /* oCh */
  for(i=0;i<sizeof(name);i++) ((char*)&name)[i]=0;
  name.sin_port=htons((unsigned short)port);
  name.sin_addr.s_addr = INADDR_ANY;
  name.sin_family = PF_INET;
  if( bind(fd,(struct sockaddr*)&name,sizeof(name)) < 0 )
    return NULL;

  /* ҋ@ */
  if( listen(fd,5) != 0) return NULL;

  return bufsockCreate(fd,NULL,-1);
}

/* -------------------------------------------------- */
/* ==================== ڑeF ==================== */
/* -------------------------------------------------- */
#include <errno.h>
BUFSOCK
bufsockCreateAccept(BUFSOCK listenBufsock)
{
  int fd,port;
  ALCSTR address;
  struct sockaddr client_addr;
  size_t client_addr_len;
  BUFSOCK bufsock;

  errno=0;
  client_addr_len=sizeof(client_addr);
  while( (fd=accept(listenBufsock->fd,&client_addr,&client_addr_len)) < 0)
    {
      if(errno!=EINTR)
	return NULL;
    }

  {
    struct hostent *host;
    /* zXg擾 */
    host=gethostbyaddr((char*)&((struct sockaddr_in*)&client_addr)->sin_addr,
		       sizeof(struct in_addr),AF_INET);
    /* zXg΃zXg */
    if(host!=NULL)
      address=alcstrCopy(host->h_name);
    /* łȂ΃AhX */
    else
      {
	unsigned char *addr;
	addr=(unsigned char*)&((struct sockaddr_in*)&client_addr)->sin_addr;
	address=alcstrFormat("$IP1.$IP2.$IP3.$IP4",
			     "IP1",ASFORMAT_INT,(int)addr[0],
			     "IP2",ASFORMAT_INT,(int)addr[1],
			     "IP3",ASFORMAT_INT,(int)addr[2],
			     "IP4",ASFORMAT_INT,(int)addr[3],
			     NULL);
      }
  }

  /* |[g */
  port=ntohs(((struct sockaddr_in*)&client_addr)->sin_port);

  /* BUFSOCK쐬 */
  bufsock=bufsockCreate(fd,address,port);

  alcstrDestroy(address);
  return bufsock;
}

/* -------------------------------------------------- */
/* ====================== ڑ ====================== */
/* -------------------------------------------------- */
BUFSOCK
bufsockCreateConnect(const char *server,int port)
{
  int i,j,fd;
  struct sockaddr_in  serv_adr_in;
  struct sockaddr    *serv_adr;
  struct hostent     *host;

  for( i=0; i<sizeof(serv_adr_in); i++ )
    ((char*)&serv_adr_in)[i]=0;
  serv_adr=(struct sockaddr*)&serv_adr_in;

  /* zXgTȂꍇ(IPAhXƂĔ) */
  host = gethostbyname( server );
  if( host == NULL )
    {
      serv_adr_in.sin_family=AF_INET;
      for( i=j=0; i<4; i++ )
	{
	  *((char*)&serv_adr_in.sin_addr+i)=atoi(server+j);
	  for(;*(server+j)!='\0' && *(server+j)!='.';j++);
	  if(*(server+j)=='\0')
	    break;
	  j++;
	}
      if(i<3)
	return NULL;
    }
  /* zXgƂĔʂłꍇ */
  else
    {
      for(i=0;i<host->h_length;i++)
	((char*)&serv_adr_in.sin_addr)[i]=((char*)host->h_addr)[i];
      serv_adr_in.sin_family=host->h_addrtype;
    }

  /* |[gԍ */
  serv_adr_in.sin_port=htons((unsigned short)port);

  /* \Pbg쐬 */
  fd = socket( PF_INET, SOCK_STREAM, 0 );
  if( fd < 0 )
    return NULL;
  /* ڑ */
  if( connect( fd, serv_adr, sizeof(serv_adr_in) ) < 0)
    {
      close(fd);
      return NULL;
    }

  return bufsockCreate(fd,server,port);
}
